/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.code.services.tools;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.praxislive.code.services.tools.CompilationException;
import org.praxislive.code.services.tools.MemoryJavaFileManager;
import org.praxislive.code.services.tools.MessageHandler;

public class CompilerTask {
    private static final MessageHandler DEFAULT_MESSAGE_HANDLER = new MessageHandler(){

        @Override
        public void handleError(String msg) {
        }

        @Override
        public void handleWarning(String msg) {
        }
    };
    private final Map<String, String> sources;
    private Map<String, Supplier<InputStream>> existingClasses;
    private MessageHandler messageHandler;
    private List<String> options;
    private Map<String, byte[]> classes;

    private CompilerTask(Map<String, String> sources) {
        this.sources = Map.copyOf(sources);
        this.existingClasses = Map.of();
        this.messageHandler = DEFAULT_MESSAGE_HANDLER;
        this.options = List.of("");
    }

    public CompilerTask existingClasses(Map<String, Supplier<InputStream>> existing) {
        this.assertNotCompiled();
        this.existingClasses = Map.copyOf(existing);
        return this;
    }

    public CompilerTask options(List<String> options) {
        this.assertNotCompiled();
        this.options = List.copyOf(options);
        return this;
    }

    public CompilerTask messageHandler(MessageHandler messageHandler) {
        this.assertNotCompiled();
        this.messageHandler = Objects.requireNonNull(messageHandler);
        return this;
    }

    public Map<String, byte[]> compile() throws CompilationException, IOException {
        this.assertNotCompiled();
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            throw new CompilationException("JDK Java compiler not available", null);
        }
        StandardJavaFileManager fm = compiler.getStandardFileManager(null, null, null);
        MemoryJavaFileManager fileManager = new MemoryJavaFileManager(fm);
        this.existingClasses.entrySet().forEach(c -> fileManager.addExistingClass((String)c.getKey(), (Supplier)c.getValue()));
        List compilationUnits = this.sources.entrySet().stream().map(e -> fileManager.addSource((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
        try {
            final CompilationException[] caughtCompilationException = new CompilationException[1];
            if (!compiler.getTask(null, fileManager, (DiagnosticListener<? super JavaFileObject>)new DiagnosticListener<JavaFileObject>(){

                @Override
                public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                    block7: {
                        String message = "[" + diagnostic.getLineNumber() + ":" + diagnostic.getColumnNumber() + "] " + diagnostic.getMessage(null) + " (" + diagnostic.getCode() + ")";
                        try {
                            switch (diagnostic.getKind()) {
                                case ERROR: {
                                    if (CompilerTask.this.messageHandler != null) {
                                        CompilerTask.this.messageHandler.handleError(message);
                                    }
                                    throw new CompilationException(message);
                                }
                                case MANDATORY_WARNING: 
                                case WARNING: {
                                    if (CompilerTask.this.messageHandler == null) break;
                                    CompilerTask.this.messageHandler.handleWarning(message);
                                    break;
                                }
                            }
                        }
                        catch (CompilationException ce) {
                            if (caughtCompilationException[0] != null) break block7;
                            caughtCompilationException[0] = ce;
                        }
                    }
                }
            }, this.options, null, compilationUnits).call().booleanValue()) {
                if (caughtCompilationException[0] != null) {
                    throw caughtCompilationException[0];
                }
                throw new CompilationException("Compilation failed", null);
            }
        }
        catch (RuntimeException rte) {
            for (Throwable t = rte.getCause(); t != null; t = t.getCause()) {
                if (t instanceof CompilationException) {
                    throw (CompilationException)t;
                }
                if (!(t instanceof IOException)) continue;
                throw (IOException)t;
            }
            throw rte;
        }
        this.classes = fileManager.extractClassData();
        return this.classes;
    }

    public Map<String, byte[]> getCompiledClasses() {
        this.assertCompiled();
        return this.classes;
    }

    private void assertNotCompiled() {
        if (this.classes != null) {
            throw new IllegalStateException("Classes already compiled");
        }
    }

    private void assertCompiled() {
        if (this.classes == null) {
            throw new IllegalStateException("Classes not yet compiled");
        }
    }

    public static CompilerTask create(Map<String, String> sources) {
        return new CompilerTask(sources);
    }
}

