/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2020 Neil C Smith.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version 3 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License version 3
 * along with this work; if not, see http://www.gnu.org/licenses/
 *
 *
 * Please visit https://www.praxislive.org if you need additional information or
 * have any questions.
 */
package org.praxislive.core.components;

import org.praxislive.code.GenerateTemplate;

import org.praxislive.core.code.CoreCodeDelegate;

// default imports
import java.util.*;
import java.util.function.*;
import java.util.stream.*;
import org.praxislive.core.*;
import org.praxislive.core.types.*;
import org.praxislive.code.userapi.*;
import static org.praxislive.code.userapi.Constants.*;


/**
 *
 */
@GenerateTemplate(CoreTracker.TEMPLATE_PATH)
public class CoreTracker extends CoreCodeDelegate {
    
    final static String TEMPLATE_PATH = "resources/core_tracker.pxj";

    // PXJ-BEGIN:body
    
    @P(1) List<Table> patterns;
    @P(2) @Type.Integer(min = 0)
    int pattern;
    @P(3) @Type.Integer(min = 0) @Transient
    int position;

    @Out(1) Output out1;
    @Out(2) Output out2;
    @Out(3) Output out3;
    @Out(4) Output out4;
    @Out(5) Output out5;
    @Out(6) Output out6;
    @Out(7) Output out7;
    @Out(8) Output out8;

    Output[] outs;

    @Override
    public void init() {
        outs = new Output[]{out1, out2, out3, out4, out5, out6, out7, out8};
    }

    @Override
    public void starting() {
        position = 0;
    }

    @T(1) void trigger() {
        if (pattern >= patterns.size()) {
            position = 0;
            return;
        }
        Table p = patterns.get(pattern);
        if (p.rowCount() == 0) {
            position = 0;
            return;
        }
        position %= p.rowCount();
        int max = min(p.columnCount(), outs.length);
        for (int i = 0; i < max; i++) {
            p.valueAt(position, i).ifPresent(outs[i]::send);
        }
        position++;
        position %= p.rowCount();
    }

    @T(2) void reset() {
        position = 0;
    }
    
    // PXJ-END:body
    
}
