/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.core.components;

import java.util.List;
import org.praxislive.code.userapi.Out;
import org.praxislive.code.userapi.Output;
import org.praxislive.code.userapi.P;
import org.praxislive.code.userapi.T;
import org.praxislive.code.userapi.Table;
import org.praxislive.code.userapi.Transient;
import org.praxislive.code.userapi.Type;
import org.praxislive.core.code.CoreCodeDelegate;

public class CoreTracker
extends CoreCodeDelegate {
    static final String TEMPLATE_PATH = "resources/core_tracker.pxj";
    @P(value=1)
    List<Table> patterns;
    @P(value=2)
    @Type.Integer(min=0)
    int pattern;
    @P(value=3)
    @Type.Integer(min=0)
    @Transient
    int position;
    @Out(value=1)
    Output out1;
    @Out(value=2)
    Output out2;
    @Out(value=3)
    Output out3;
    @Out(value=4)
    Output out4;
    @Out(value=5)
    Output out5;
    @Out(value=6)
    Output out6;
    @Out(value=7)
    Output out7;
    @Out(value=8)
    Output out8;
    Output[] outs;

    public void init() {
        this.outs = new Output[]{this.out1, this.out2, this.out3, this.out4, this.out5, this.out6, this.out7, this.out8};
    }

    public void starting() {
        this.position = 0;
    }

    @T(value=1)
    void trigger() {
        if (this.pattern >= this.patterns.size()) {
            this.position = 0;
            return;
        }
        Table p = this.patterns.get(this.pattern);
        if (p.rowCount() == 0) {
            this.position = 0;
            return;
        }
        this.position %= p.rowCount();
        int max = this.min(p.columnCount(), this.outs.length);
        for (int i = 0; i < max; ++i) {
            p.valueAt(this.position, i).ifPresent(arg_0 -> ((Output)this.outs[i]).send(arg_0));
        }
        ++this.position;
        this.position %= p.rowCount();
    }

    @T(value=2)
    void reset() {
        this.position = 0;
    }
}

