/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.core.components;

import org.praxislive.code.userapi.ID;
import org.praxislive.code.userapi.In;
import org.praxislive.code.userapi.Out;
import org.praxislive.code.userapi.Output;
import org.praxislive.code.userapi.P;
import org.praxislive.code.userapi.Type;
import org.praxislive.core.code.CoreCodeDelegate;

public class CoreMathScale
extends CoreCodeDelegate {
    static final String TEMPLATE_PATH = "resources/math_scale.pxj";
    @P(value=1)
    @Type.Number(def=0.0)
    @ID(value="x1")
    double x1;
    @P(value=2)
    @Type.Number(def=1.0)
    @ID(value="x2")
    double x2;
    @P(value=3)
    @Type.Number(def=0.0)
    @ID(value="y1")
    double y1;
    @P(value=4)
    @Type.Number(def=1.0)
    @ID(value="y2")
    double y2;
    @Out(value=1)
    Output out;

    @In(value=1)
    void in(double value) {
        double xMax;
        double xMin = this.min(this.x1, this.x2);
        if (value < xMin) {
            value = xMin;
        }
        if (value > (xMax = this.max(this.x1, this.x2))) {
            value = xMax;
        }
        value = (value - this.x1) / (this.x2 - this.x1);
        value = value * (this.y2 - this.y1) + this.y1;
        this.out.send(value);
    }
}

