/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.core.components;

import org.praxislive.code.userapi.Constants;
import org.praxislive.code.userapi.In;
import org.praxislive.code.userapi.OnChange;
import org.praxislive.code.userapi.Out;
import org.praxislive.code.userapi.Output;
import org.praxislive.code.userapi.P;
import org.praxislive.code.userapi.Property;
import org.praxislive.code.userapi.ReadOnly;
import org.praxislive.code.userapi.T;
import org.praxislive.code.userapi.Type;
import org.praxislive.core.Value;
import org.praxislive.core.code.CoreCodeDelegate;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PNumber;

public class CoreRoutingGate
extends CoreCodeDelegate {
    static final String TEMPLATE_PATH = "resources/routing_gate.pxj";
    @P(value=1)
    boolean active;
    @P(value=2)
    @Type(value=PArray.class)
    @OnChange(value="updatePattern")
    Property pattern;
    @P(value=3)
    @ReadOnly
    int index;
    @Out(value=1)
    Output out;
    @Out(value=2)
    Output discard;
    double[] pt;

    public void init() {
        this.updatePattern();
    }

    @In(value=1)
    void in(Value arg) {
        if (this.checkSend()) {
            this.out.send(arg);
        } else {
            this.discard.send(arg);
        }
    }

    @T(value=1)
    void retrigger() {
        this.index = 0;
    }

    boolean checkSend() {
        if (this.active) {
            if (this.pt.length == 0) {
                return true;
            }
            double p = this.pt[this.index];
            ++this.index;
            this.index %= this.pt.length;
            if (p > 0.999999) {
                return true;
            }
            if (p < 1.0E-6) {
                return false;
            }
            return this.random(1.0) < p;
        }
        return false;
    }

    void updatePattern() {
        try {
            PArray arr = (PArray)PArray.from((Value)this.pattern.get()).orElseThrow();
            this.pt = new double[arr.size()];
            for (int i = 0; i < this.pt.length; ++i) {
                double d;
                this.pt[i] = d = ((PNumber)PNumber.from((Value)arr.get(i)).orElseThrow()).value();
            }
            this.index = this.pt.length == 0 ? 0 : (this.index %= this.pt.length);
        }
        catch (Exception ex) {
            this.log(Constants.WARNING, "Invalid pattern");
            this.pt = new double[0];
            this.index = 0;
            this.pattern.set((Value)PArray.EMPTY);
        }
    }
}

