/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.core.components;

import org.praxislive.code.AbstractComponentFactory;
import org.praxislive.core.code.CoreCode;
import org.praxislive.core.code.CoreCodeDelegate;
import org.praxislive.core.code.DataCode;
import org.praxislive.core.components.CoreArrayIterator;
import org.praxislive.core.components.CoreArrayRandom;
import org.praxislive.core.components.CoreContainer;
import org.praxislive.core.components.CoreCustom;
import org.praxislive.core.components.CoreMathAdd;
import org.praxislive.core.components.CoreMathMultiply;
import org.praxislive.core.components.CoreMathRandom;
import org.praxislive.core.components.CoreMathScale;
import org.praxislive.core.components.CoreMathThreshold;
import org.praxislive.core.components.CoreProperty;
import org.praxislive.core.components.CoreRootCustom;
import org.praxislive.core.components.CoreRoutingEvery;
import org.praxislive.core.components.CoreRoutingGate;
import org.praxislive.core.components.CoreRoutingInhibitor;
import org.praxislive.core.components.CoreRoutingJoin;
import org.praxislive.core.components.CoreRoutingOrder;
import org.praxislive.core.components.CoreRoutingSend;
import org.praxislive.core.components.CoreStartTrigger;
import org.praxislive.core.components.CoreTimingAnimator;
import org.praxislive.core.components.CoreTimingDelay;
import org.praxislive.core.components.CoreTimingTimer;
import org.praxislive.core.components.CoreTracker;
import org.praxislive.core.components.CoreVariable;
import org.praxislive.core.components.DataCustom;
import org.praxislive.core.components.DataRootCustom;
import org.praxislive.core.services.ComponentFactory;
import org.praxislive.core.services.ComponentFactoryProvider;

public class CoreComponents
implements ComponentFactoryProvider {
    private static final Factory instance = new Factory();

    public ComponentFactory getFactory() {
        return instance;
    }

    private static class Factory
    extends AbstractComponentFactory {
        private Factory() {
            this.build();
        }

        private void build() {
            this.add("core:custom", CoreCustom.class, "resources/custom.pxj");
            this.add("core:property", CoreProperty.class, "resources/property.pxj");
            this.add("core:start-trigger", CoreStartTrigger.class, "resources/start_trigger.pxj");
            this.add("core:tracker", CoreTracker.class, "resources/core_tracker.pxj");
            this.add("core:variable", CoreVariable.class, "resources/variable.pxj");
            this.add("core:array:random", CoreArrayRandom.class, "resources/array_random.pxj");
            this.add("core:array:iterator", CoreArrayIterator.class, "resources/array_iterator.pxj");
            this.add("core:math:add", CoreMathAdd.class, "resources/math_add.pxj");
            this.add("core:math:multiply", CoreMathMultiply.class, "resources/math_multiply.pxj");
            this.add("core:math:random", CoreMathRandom.class, "resources/math_random.pxj");
            this.add("core:math:scale", CoreMathScale.class, "resources/math_scale.pxj");
            this.add("core:math:threshold", CoreMathThreshold.class, "resources/math_threshold.pxj");
            this.add("core:routing:every", CoreRoutingEvery.class, "resources/routing_every.pxj");
            this.add("core:routing:gate", CoreRoutingGate.class, "resources/routing_gate.pxj");
            this.add("core:routing:inhibitor", CoreRoutingInhibitor.class, "resources/routing_inhibitor.pxj");
            this.add("core:routing:join", CoreRoutingJoin.class, "resources/routing_join.pxj");
            this.add("core:routing:order", CoreRoutingOrder.class, "resources/routing_order.pxj");
            this.add("core:routing:send", CoreRoutingSend.class, "resources/routing_send.pxj");
            this.add("core:timing:animator", CoreTimingAnimator.class, "resources/timing_animator.pxj");
            this.add("core:timing:delay", CoreTimingDelay.class, "resources/timing_delay.pxj");
            this.add("core:timing:timer", CoreTimingTimer.class, "resources/timing_timer.pxj");
            this.add(CoreCode.containerBase().create("core:container", CoreContainer.class, this.source("resources/container.pxj")));
            this.addRoot(CoreCode.rootContainerBase().create("root:custom", CoreRootCustom.class, this.source("resources/root_custom.pxj")));
            this.add(DataCode.base().create("data:custom", DataCustom.class, this.source("resources/data_custom.pxj")));
            this.addRoot(DataCode.rootContainerBase().create("root:data", DataRootCustom.class, this.source("resources/root_data.pxj")));
        }

        private void add(String type, Class<? extends CoreCodeDelegate> cls, String path) {
            this.add(CoreCode.base().create(type, cls, this.source(path)));
        }
    }
}

