/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.core.components;

import org.praxislive.code.userapi.Config;
import org.praxislive.code.userapi.OnChange;
import org.praxislive.code.userapi.Out;
import org.praxislive.code.userapi.Output;
import org.praxislive.code.userapi.P;
import org.praxislive.code.userapi.ReadOnly;
import org.praxislive.code.userapi.T;
import org.praxislive.code.userapi.Type;
import org.praxislive.core.code.CoreCodeDelegate;
import org.praxislive.core.types.PArray;

public class CoreArrayIterator
extends CoreCodeDelegate {
    static final String TEMPLATE_PATH = "resources/array_iterator.pxj";
    @P(value=1)
    @OnChange(value="valuesChanged")
    PArray values;
    @P(value=2)
    @ReadOnly
    int index;
    @P(value=3)
    @Type.Integer(min=1, max=1024, def=1)
    @Config.Port(value=false)
    int minSkip;
    @P(value=4)
    @Type.Integer(min=1, max=1024, def=1)
    @Config.Port(value=false)
    int maxSkip;
    @P(value=5)
    @Config.Port(value=false)
    boolean pingPong;
    @P(value=6)
    @Config.Port(value=false)
    @Type.Boolean(def=true)
    boolean resetOnChange;
    @T(value=2)
    boolean reset;
    @Out(value=1)
    Output out;
    boolean forwards;

    @T(value=1)
    void trigger() {
        int count = this.values.size();
        boolean r = this.reset;
        this.reset = false;
        if (count == 0) {
            this.index = -1;
            this.out.send();
        } else if (count == 1) {
            this.index = 0;
            this.out.send(this.values.get(0));
        } else {
            this.index = r ? 0 : this.nextIdx();
            this.out.send(this.values.get(this.index));
        }
    }

    void valuesChanged() {
        if (this.resetOnChange) {
            this.reset = true;
        }
    }

    int nextIdx() {
        int delta;
        int idx;
        if (!this.pingPong) {
            this.forwards = true;
        }
        int min = this.minSkip;
        int max = this.max(min, this.maxSkip);
        int oldIdx = idx = this.index;
        int count = this.values.size();
        if (min == max) {
            delta = min;
        } else {
            delta = (int)this.random(max + 1 - min);
            delta += min;
        }
        idx = this.forwards ? (idx += delta) : (idx -= delta);
        while (idx < 0 || idx >= count) {
            if (this.pingPong) {
                if (idx < 0) {
                    idx = 0 - idx;
                    this.forwards = true;
                    continue;
                }
                int hi = count - 1;
                idx = hi - (idx - hi);
                this.forwards = false;
                continue;
            }
            if (idx < 0) {
                idx = 0 - idx;
                continue;
            }
            idx %= count;
        }
        if (idx == oldIdx && min > 0) {
            if (this.forwards) {
                if (idx < count - 1) {
                    ++idx;
                } else if (this.pingPong) {
                    --idx;
                    this.forwards = false;
                } else {
                    idx = 0;
                }
            } else if (idx > 0) {
                --idx;
            } else {
                ++idx;
                this.forwards = true;
            }
        }
        return idx;
    }
}

