/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.gui.components;

import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.Box;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.praxislive.base.AbstractProperty;
import org.praxislive.base.Binding;
import org.praxislive.base.BindingContext;
import org.praxislive.core.Control;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.ControlInfo;
import org.praxislive.core.Info;
import org.praxislive.core.Value;
import org.praxislive.core.types.PBoolean;
import org.praxislive.core.types.PNumber;
import org.praxislive.core.types.PString;
import org.praxislive.gui.components.JRangeSlider;
import org.praxislive.gui.components.Utils;
import org.praxislive.gui.impl.AbstractGuiComponent;
import org.praxislive.gui.impl.BoundedValueAdaptor;

class RangeSlider
extends AbstractGuiComponent {
    private static Logger logger = Logger.getLogger(RangeSlider.class.getName());
    private final boolean vertical;
    private BindingContext bindingContext;
    private String labelText = "";
    private Box box;
    private JRangeSlider slider;
    private BoundedValueAdaptor lowAdaptor;
    private BoundedValueAdaptor highAdaptor;
    private ControlAddress lowBinding;
    private ControlAddress highBinding;
    private ModelConverter converter;
    private PNumber prefMin;
    private PNumber prefMax;

    public RangeSlider(boolean vertical) {
        this.vertical = vertical;
    }

    @Override
    protected void initControls(Info.ComponentInfoBuilder cmpInfo) {
        super.initControls(cmpInfo);
        this.registerControl("binding-low", (Control)new AddressBinding(false));
        this.registerControl("binding-high", (Control)new AddressBinding(true));
        ControlInfo bindingInfo = Info.control(c -> c.property().input(ControlAddress.class).property("allow-empty", (Object)PBoolean.TRUE));
        cmpInfo.control("binding-low", bindingInfo);
        cmpInfo.control("binding-high", bindingInfo);
        this.registerControl("minimum", (Control)new MinBinding());
        this.registerControl("maximum", (Control)new MaxBinding());
        ControlInfo rangeInfo = Info.control(c -> ((Info.PropertyInfoBuilder)c.property().property("allow-empty", (Object)PBoolean.TRUE)).property("empty-is-default", (Object)PBoolean.TRUE));
        cmpInfo.control("minimum", rangeInfo);
        cmpInfo.control("maximum", rangeInfo);
    }

    @Override
    protected JComponent createSwingComponent() {
        if (this.box == null) {
            this.createComponentAndAdaptors();
        }
        return this.box;
    }

    @Override
    public void hierarchyChanged() {
        super.hierarchyChanged();
        BindingContext ctxt = this.getLookup().find(BindingContext.class).orElse(null);
        if (this.bindingContext != ctxt) {
            if (this.bindingContext != null) {
                if (this.lowBinding != null) {
                    this.bindingContext.unbind(this.lowBinding, (Binding.Adaptor)this.lowAdaptor);
                }
                if (this.highBinding != null) {
                    this.bindingContext.unbind(this.highBinding, (Binding.Adaptor)this.highAdaptor);
                }
            }
            if (ctxt != null) {
                if (this.lowBinding != null) {
                    ctxt.bind(this.lowBinding, (Binding.Adaptor)this.lowAdaptor);
                }
                if (this.highBinding != null) {
                    ctxt.bind(this.highBinding, (Binding.Adaptor)this.highAdaptor);
                }
            }
            this.bindingContext = ctxt;
        }
    }

    @Override
    protected void updateLabel() {
        super.updateLabel();
        this.labelText = this.isLabelOnParent() ? "" : this.getLabel();
        this.updateBorders();
    }

    private void createComponentAndAdaptors() {
        DefaultBoundedRangeModel rangeModel = new DefaultBoundedRangeModel(0, 500, 0, 500);
        this.slider = new JRangeSlider(rangeModel, this.vertical ? 0 : 1, 0);
        DefaultBoundedRangeModel lowModel = new DefaultBoundedRangeModel(0, 0, 0, 500);
        DefaultBoundedRangeModel highModel = new DefaultBoundedRangeModel(500, 0, 0, 500);
        this.lowAdaptor = new BoundedValueAdaptor(lowModel);
        this.highAdaptor = new BoundedValueAdaptor(highModel);
        this.converter = new ModelConverter(rangeModel, lowModel, highModel);
        this.slider.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                RangeSlider.this.lowAdaptor.setActive(true);
                RangeSlider.this.highAdaptor.setActive(true);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                RangeSlider.this.lowAdaptor.setActive(false);
                RangeSlider.this.highAdaptor.setActive(false);
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
        this.box = this.vertical ? Box.createVerticalBox() : Box.createHorizontalBox();
        this.box.add(this.slider);
        this.updateBorders();
    }

    private void updateAdaptors() {
        if (this.lowAdaptor != null && this.highAdaptor != null) {
            this.lowAdaptor.setPreferredMinimum(this.prefMin);
            this.lowAdaptor.setPreferredMaximum(this.prefMax);
            this.highAdaptor.setPreferredMinimum(this.prefMin);
            this.highAdaptor.setPreferredMaximum(this.prefMax);
        }
    }

    private void updateBorders() {
        if (this.box != null) {
            Border etched = Utils.getBorder();
            if (this.labelText.isEmpty()) {
                this.box.setBorder(etched);
            } else {
                this.box.setBorder(BorderFactory.createTitledBorder(etched, this.labelText));
            }
            this.box.revalidate();
        }
    }

    private class ModelConverter
    implements ChangeListener {
        private final BoundedRangeModel rangeModel;
        private final BoundedRangeModel lowModel;
        private final BoundedRangeModel highModel;
        private boolean updating;

        private ModelConverter(BoundedRangeModel rangeModel, BoundedRangeModel lowModel, BoundedRangeModel highModel) {
            this.rangeModel = rangeModel;
            this.lowModel = lowModel;
            this.highModel = highModel;
            rangeModel.addChangeListener(this);
            lowModel.addChangeListener(this);
            highModel.addChangeListener(this);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (this.updating) {
                return;
            }
            this.updating = true;
            if (e.getSource() == this.rangeModel) {
                this.lowModel.setValueIsAdjusting(this.rangeModel.getValueIsAdjusting());
                this.highModel.setValueIsAdjusting(this.rangeModel.getValueIsAdjusting());
                this.lowModel.setValue(this.rangeModel.getValue());
                this.highModel.setValue(this.rangeModel.getValue() + this.rangeModel.getExtent());
            } else {
                int low = this.lowModel.getValue();
                int high = this.highModel.getValue();
                int ext = high - low;
                ext = ext < 0 ? 0 : ext;
                this.rangeModel.setRangeProperties(low, ext, 0, 500, false);
            }
            this.updating = false;
        }
    }

    private class AddressBinding
    extends AbstractProperty {
        final boolean high;

        AddressBinding(boolean high) {
            this.high = high;
        }

        protected void set(long time, Value arg) throws Exception {
            if (RangeSlider.this.lowAdaptor == null) {
                RangeSlider.this.createComponentAndAdaptors();
            }
            if (RangeSlider.this.bindingContext != null) {
                if (this.high) {
                    if (RangeSlider.this.highBinding != null) {
                        RangeSlider.this.bindingContext.unbind(RangeSlider.this.highBinding, (Binding.Adaptor)RangeSlider.this.highAdaptor);
                    }
                } else if (RangeSlider.this.lowBinding != null) {
                    RangeSlider.this.bindingContext.unbind(RangeSlider.this.lowBinding, (Binding.Adaptor)RangeSlider.this.lowAdaptor);
                }
                if (arg.isEmpty()) {
                    if (this.high) {
                        RangeSlider.this.highBinding = null;
                    } else {
                        RangeSlider.this.lowBinding = null;
                    }
                } else if (this.high) {
                    RangeSlider.this.highBinding = (ControlAddress)ControlAddress.from((Value)arg).get();
                    RangeSlider.this.bindingContext.bind(RangeSlider.this.highBinding, (Binding.Adaptor)RangeSlider.this.highAdaptor);
                } else {
                    RangeSlider.this.lowBinding = (ControlAddress)ControlAddress.from((Value)arg).get();
                    RangeSlider.this.bindingContext.bind(RangeSlider.this.lowBinding, (Binding.Adaptor)RangeSlider.this.lowAdaptor);
                }
            }
        }

        protected Value get() {
            ControlAddress ret = this.high ? RangeSlider.this.highBinding : RangeSlider.this.lowBinding;
            return ret == null ? PString.EMPTY : ret;
        }
    }

    private class MaxBinding
    extends AbstractProperty {
        private MaxBinding() {
        }

        public void set(long time, Value value) {
            RangeSlider.this.prefMax = value.isEmpty() ? null : (PNumber)PNumber.from((Value)value).orElse(null);
            RangeSlider.this.updateAdaptors();
        }

        public Value get() {
            if (RangeSlider.this.prefMax == null) {
                return PString.EMPTY;
            }
            return RangeSlider.this.prefMax;
        }
    }

    private class MinBinding
    extends AbstractProperty {
        private MinBinding() {
        }

        public void set(long time, Value value) {
            RangeSlider.this.prefMin = value.isEmpty() ? null : (PNumber)PNumber.from((Value)value).orElse(null);
            RangeSlider.this.updateAdaptors();
        }

        public Value get() {
            if (RangeSlider.this.prefMin == null) {
                return PString.EMPTY;
            }
            return RangeSlider.this.prefMin;
        }
    }
}

