/*
 * Decompiled with CFR 0.152.
 */
package net.miginfocom.layout;

import java.util.HashMap;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.BoundSize;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.DimConstraint;
import net.miginfocom.layout.Grid;
import net.miginfocom.layout.LC;
import net.miginfocom.layout.LayoutUtil;
import net.miginfocom.layout.PlatformDefaults;
import net.miginfocom.layout.UnitValue;

public class IDEUtil {
    public static final UnitValue ZERO = UnitValue.ZERO;
    public static final UnitValue TOP = UnitValue.TOP;
    public static final UnitValue LEADING = UnitValue.LEADING;
    public static final UnitValue LEFT = UnitValue.LEFT;
    public static final UnitValue CENTER = UnitValue.CENTER;
    public static final UnitValue TRAILING = UnitValue.TRAILING;
    public static final UnitValue RIGHT = UnitValue.RIGHT;
    public static final UnitValue BOTTOM = UnitValue.BOTTOM;
    public static final UnitValue LABEL = UnitValue.LABEL;
    public static final UnitValue INF = UnitValue.INF;
    public static final UnitValue BASELINE_IDENTITY = UnitValue.BASELINE_IDENTITY;
    private static final String[] X_Y_STRINGS = new String[]{"x", "y", "x2", "y2"};

    public String getIDEUtilVersion() {
        return "1.0";
    }

    public static HashMap<Object, int[]> getGridPositions(Object parentContainer) {
        return Grid.getGridPositions(parentContainer);
    }

    public static int[][] getRowSizes(Object parentContainer) {
        return Grid.getSizesAndIndexes(parentContainer, true);
    }

    public static int[][] getColumnSizes(Object parentContainer) {
        return Grid.getSizesAndIndexes(parentContainer, false);
    }

    public static final String getConstraintString(AC ac, boolean asAPI, boolean isCols) {
        StringBuffer sb = new StringBuffer(32);
        DimConstraint[] dims = ac.getConstaints();
        BoundSize defGap = isCols ? PlatformDefaults.getGridGapX() : PlatformDefaults.getGridGapY();
        for (int i = 0; i < dims.length; ++i) {
            DimConstraint dc = dims[i];
            IDEUtil.addRowDimConstraintString(dc, sb, asAPI);
            if (i >= dims.length - 1) continue;
            BoundSize gap = dc.getGapAfter();
            if (gap == defGap || gap == null) {
                gap = dims[i + 1].getGapBefore();
            }
            if (gap != null) {
                String gapStr = IDEUtil.getBS(gap);
                if (asAPI) {
                    sb.append(".gap(\"").append(gapStr).append("\")");
                    continue;
                }
                sb.append(gapStr);
                continue;
            }
            if (!asAPI) continue;
            sb.append(".gap()");
        }
        return sb.toString();
    }

    private static final void addRowDimConstraintString(DimConstraint dc, StringBuffer sb, boolean asAPI) {
        UnitValue al;
        String sg;
        String eg;
        Float sw;
        int sp;
        Float gw;
        int gp = dc.getGrowPriority();
        int firstComma = sb.length();
        BoundSize size = dc.getSize();
        if (!size.isUnset()) {
            if (asAPI) {
                sb.append(".size(\"").append(IDEUtil.getBS(size)).append("\")");
            } else {
                sb.append(',').append(IDEUtil.getBS(size));
            }
        }
        if (gp != 100) {
            if (asAPI) {
                sb.append(".growPrio(").append(gp).append("\")");
            } else {
                sb.append(",growprio ").append(gp);
            }
        }
        if ((gw = dc.getGrow()) != null) {
            String g;
            String string = g = gw.floatValue() != 100.0f ? IDEUtil.floatToString(gw.floatValue(), asAPI) : "";
            if (asAPI) {
                if (g.length() == 0) {
                    sb.append(".grow()");
                } else {
                    sb.append(".grow(\"").append(g).append("\")");
                }
            } else {
                sb.append(",grow").append((String)(g.length() > 0 ? " " + g : ""));
            }
        }
        if ((sp = dc.getShrinkPriority()) != 100) {
            if (asAPI) {
                sb.append(".shrinkPrio(").append(sp).append("\")");
            } else {
                sb.append(",shrinkprio ").append(sp);
            }
        }
        if ((sw = dc.getShrink()) != null && sw.intValue() != 100) {
            String s = IDEUtil.floatToString(sw.floatValue(), asAPI);
            if (asAPI) {
                sb.append(".shrink(\"").append(s).append("\")");
            } else {
                sb.append(",shrink ").append(s);
            }
        }
        if ((eg = dc.getEndGroup()) != null) {
            if (asAPI) {
                sb.append(".endGroup(\"").append(eg).append("\")");
            } else {
                sb.append(",endgroup ").append(eg);
            }
        }
        if ((sg = dc.getSizeGroup()) != null) {
            if (asAPI) {
                sb.append(".sizeGroup(\"").append(sg).append("\")");
            } else {
                sb.append(",sizegroup ").append(sg);
            }
        }
        if ((al = dc.getAlign()) != null) {
            if (asAPI) {
                sb.append(".align(\"").append(IDEUtil.getUV(al)).append("\")");
            } else {
                String s = IDEUtil.getUV(al);
                String alKw = s.equals("top") || s.equals("bottom") || s.equals("left") || s.equals("label") || s.equals("leading") || s.equals("center") || s.equals("trailing") || s.equals("right") || s.equals("baseline") ? "" : "align ";
                sb.append(',').append(alKw).append(s);
            }
        }
        if (dc.isNoGrid()) {
            if (asAPI) {
                sb.append(".noGrid()");
            } else {
                sb.append(",nogrid");
            }
        }
        if (dc.isFill()) {
            if (asAPI) {
                sb.append(".fill()");
            } else {
                sb.append(",fill");
            }
        }
        if (!asAPI) {
            if (sb.length() > firstComma) {
                sb.setCharAt(firstComma, '[');
                sb.append(']');
            } else {
                sb.append("[]");
            }
        }
    }

    private static final void addComponentDimConstraintString(DimConstraint dc, StringBuffer sb, boolean asAPI, boolean isHor, boolean noGrowAdd) {
        String sg;
        String eg;
        Float sw;
        int sp;
        Float gw;
        int gp = dc.getGrowPriority();
        if (gp != 100) {
            if (asAPI) {
                sb.append(isHor ? ".growPrioX(" : ".growPrioY(").append(gp).append(')');
            } else {
                sb.append(isHor ? ",growpriox " : ",growprioy ").append(gp);
            }
        }
        if (!noGrowAdd && (gw = dc.getGrow()) != null) {
            String g;
            String string = g = gw.floatValue() != 100.0f ? IDEUtil.floatToString(gw.floatValue(), asAPI) : "";
            if (asAPI) {
                sb.append(isHor ? ".growX(" : ".growY(").append(g).append(')');
            } else {
                sb.append(isHor ? ",growx" : ",growy").append((String)(g.length() > 0 ? " " + g : ""));
            }
        }
        if ((sp = dc.getShrinkPriority()) != 100) {
            if (asAPI) {
                sb.append(isHor ? ".shrinkPrioX(" : ".shrinkPrioY(").append(sp).append(')');
            } else {
                sb.append(isHor ? ",shrinkpriox " : ",shrinkprioy ").append(sp);
            }
        }
        if ((sw = dc.getShrink()) != null && sw.intValue() != 100) {
            String s = IDEUtil.floatToString(sw.floatValue(), asAPI);
            if (asAPI) {
                sb.append(isHor ? ".shrinkX(" : ".shrinkY(").append(s).append(')');
            } else {
                sb.append(isHor ? ",shrinkx " : ",shrinky ").append(s);
            }
        }
        if ((eg = dc.getEndGroup()) != null) {
            if (asAPI) {
                sb.append(isHor ? ".endGroupX(\"" : ".endGroupY(\"").append(eg).append("\")");
            } else {
                sb.append(isHor ? ",endgroupx " : ",endgroupy ").append(eg);
            }
        }
        if ((sg = dc.getSizeGroup()) != null) {
            if (asAPI) {
                sb.append(isHor ? ".sizeGroupX(\"" : ".sizeGroupY(\"").append(sg).append("\")");
            } else {
                sb.append(isHor ? ",sizegroupx " : ",sizegroupy ").append(sg);
            }
        }
        IDEUtil.appendBoundSize(dc.getSize(), sb, isHor, asAPI);
        UnitValue al = dc.getAlign();
        if (al != null) {
            if (asAPI) {
                sb.append(isHor ? ".alignX(\"" : ".alignY(\"").append(IDEUtil.getUV(al)).append("\")");
            } else {
                sb.append(isHor ? ",alignx " : ",aligny ").append(IDEUtil.getUV(al));
            }
        }
        BoundSize gapBef = dc.getGapBefore();
        BoundSize gapAft = dc.getGapAfter();
        if (gapBef != null || gapAft != null) {
            if (asAPI) {
                sb.append(isHor ? ".gapX(\"" : ".gapY(\"").append(IDEUtil.getBS(gapBef)).append("\", \"").append(IDEUtil.getBS(gapAft)).append("\")");
            } else {
                sb.append(isHor ? ",gapx " : ",gapy ").append(IDEUtil.getBS(gapBef));
                if (gapAft != null) {
                    sb.append(' ').append(IDEUtil.getBS(gapAft));
                }
            }
        }
    }

    private static void appendBoundSize(BoundSize size, StringBuffer sb, boolean isHor, boolean asAPI) {
        if (!size.isUnset()) {
            if (size.getPreferred() == null) {
                if (size.getMin() == null) {
                    if (asAPI) {
                        sb.append(isHor ? ".maxWidth(\"" : ".maxHeight(\"").append(IDEUtil.getUV(size.getMax())).append("\")");
                    } else {
                        sb.append(isHor ? ",wmax " : ",hmax ").append(IDEUtil.getUV(size.getMax()));
                    }
                } else if (size.getMax() == null) {
                    if (asAPI) {
                        sb.append(isHor ? ".minWidth(\"" : ".minHeight(\"").append(IDEUtil.getUV(size.getMin())).append("\")");
                    } else {
                        sb.append(isHor ? ",wmin " : ",hmin ").append(IDEUtil.getUV(size.getMin()));
                    }
                } else if (asAPI) {
                    sb.append(isHor ? ".width(\"" : ".height(\"").append(IDEUtil.getUV(size.getMin())).append("::").append(IDEUtil.getUV(size.getMax())).append("\")");
                } else {
                    sb.append(isHor ? ",width " : ",height ").append(IDEUtil.getUV(size.getMin())).append("::").append(IDEUtil.getUV(size.getMax()));
                }
            } else if (asAPI) {
                sb.append(isHor ? ".width(\"" : ".height(\"").append(IDEUtil.getBS(size)).append("\")");
            } else {
                sb.append(isHor ? ",width " : ",height ").append(IDEUtil.getBS(size));
            }
        }
    }

    public static final String getConstraintString(CC cc, boolean asAPI) {
        String s;
        int dock;
        int split;
        int skip;
        int hideMode;
        String tag;
        String id;
        UnitValue[] pos;
        UnitValue[] pad;
        Boolean flowX;
        StringBuffer sb = new StringBuffer(16);
        if (cc.isNewline()) {
            sb.append(asAPI ? ".newline()" : ",newline");
        }
        if (cc.isExternal()) {
            sb.append(asAPI ? ".external()" : ",external");
        }
        if ((flowX = cc.getFlowX()) != null) {
            if (asAPI) {
                sb.append(flowX != false ? ".flowX()" : ".flowY()");
            } else {
                sb.append(flowX != false ? ",flowx" : ",flowy");
            }
        }
        if ((pad = cc.getPadding()) != null) {
            sb.append(asAPI ? ".pad(\"" : ",pad ");
            for (int i = 0; i < pad.length; ++i) {
                sb.append(IDEUtil.getUV(pad[i])).append(i < pad.length - 1 ? " " : "");
            }
            if (asAPI) {
                sb.append("\")");
            }
        }
        if ((pos = cc.getPos()) != null) {
            if (cc.isBoundsInGrid()) {
                for (int i = 0; i < 4; ++i) {
                    if (pos[i] == null) continue;
                    if (asAPI) {
                        sb.append('.').append(X_Y_STRINGS[i]).append("(\"").append(IDEUtil.getUV(pos[i])).append("\")");
                        continue;
                    }
                    sb.append(',').append(X_Y_STRINGS[i]).append(IDEUtil.getUV(pos[i]));
                }
            } else {
                sb.append(asAPI ? ".pos(\"" : ",pos ");
                int iSz = pos[2] != null || pos[3] != null ? 4 : 2;
                for (int i = 0; i < iSz; ++i) {
                    sb.append(IDEUtil.getUV(pos[i])).append(i < iSz - 1 ? " " : "");
                }
                if (asAPI) {
                    sb.append("\")");
                }
            }
        }
        if ((id = cc.getId()) != null) {
            if (asAPI) {
                sb.append(".id(\"").append(id).append("\")");
            } else {
                sb.append(",id ").append(id);
            }
        }
        if ((tag = cc.getTag()) != null) {
            if (asAPI) {
                sb.append(".tag(\"").append(tag).append("\")");
            } else {
                sb.append(",tag ").append(tag);
            }
        }
        if ((hideMode = cc.getHideMode()) >= 0) {
            if (asAPI) {
                sb.append(".hideMode(").append(hideMode).append(')');
            } else {
                sb.append(",hideMode ").append(hideMode);
            }
        }
        if ((skip = cc.getSkip()) > 0) {
            if (asAPI) {
                sb.append(".skip(").append(skip).append(')');
            } else {
                sb.append(",skip ").append(skip);
            }
        }
        if ((split = cc.getSplit()) > 1) {
            String s2;
            String string = s2 = split == 2097051 ? "" : String.valueOf(split);
            if (asAPI) {
                sb.append(".split(").append(s2).append(')');
            } else {
                sb.append(",split ").append(s2);
            }
        }
        int cx = cc.getCellX();
        int cy = cc.getCellY();
        int spanX = cc.getSpanX();
        int spanY = cc.getSpanY();
        if (cx >= 0 && cy >= 0) {
            if (asAPI) {
                sb.append(".cell(").append(cx).append(", ").append(cy);
                if (spanX > 1 || spanY > 1) {
                    sb.append(", ").append(spanX).append(", ").append(spanY);
                }
                sb.append(')');
            } else {
                sb.append(",cell ").append(cx).append(' ').append(cy);
                if (spanX > 1 || spanY > 1) {
                    sb.append(' ').append(spanX).append(' ').append(spanY);
                }
            }
        } else if (spanX > 1 || spanY > 1) {
            if (spanX > 1 && spanY > 1) {
                sb.append(asAPI ? ".span(" : ",span ").append(spanX).append(asAPI ? ", " : " ").append(spanY);
            } else if (spanX > 1) {
                sb.append(asAPI ? ".spanX(" : ",spanx ").append(spanX == 2097051 ? "" : String.valueOf(spanX));
            } else if (spanY > 1) {
                sb.append(asAPI ? ".spanY(" : ",spany ").append(spanY == 2097051 ? "" : String.valueOf(spanY));
            }
            if (asAPI) {
                sb.append(')');
            }
        }
        Float pushX = cc.getPushX();
        Float pushY = cc.getPushY();
        if (pushX != null || pushY != null) {
            if (pushX != null && pushY != null) {
                sb.append(asAPI ? ".push(" : ",push ");
                if ((double)pushX.floatValue() != 100.0 || (double)pushY.floatValue() != 100.0) {
                    sb.append(pushX).append(asAPI ? ", " : " ").append(pushY);
                }
            } else if (pushX != null) {
                sb.append(asAPI ? ".pushX(" : ",pushx ").append(pushX.floatValue() == 100.0f ? "" : String.valueOf(pushX));
            } else if (pushY != null) {
                sb.append(asAPI ? ".pushY(" : ",pushy ").append(pushY.floatValue() == 100.0f ? "" : String.valueOf(pushY));
            }
            if (asAPI) {
                sb.append(')');
            }
        }
        if ((dock = cc.getDockSide()) >= 0) {
            String ds = CC.DOCK_SIDES[dock];
            if (asAPI) {
                sb.append(".dock").append(Character.toUpperCase(ds.charAt(0))).append(ds.substring(1)).append("()");
            } else {
                sb.append(",").append(ds);
            }
        }
        boolean noGrowAdd = cc.getHorizontal().getGrow() != null && cc.getHorizontal().getGrow().intValue() == 100 && cc.getVertical().getGrow() != null && cc.getVertical().getGrow().intValue() == 100;
        IDEUtil.addComponentDimConstraintString(cc.getHorizontal(), sb, asAPI, true, noGrowAdd);
        IDEUtil.addComponentDimConstraintString(cc.getVertical(), sb, asAPI, false, noGrowAdd);
        if (noGrowAdd) {
            sb.append(asAPI ? ".grow()" : ",grow");
        }
        if (cc.isWrap()) {
            sb.append(asAPI ? ".wrap()" : ",wrap");
        }
        return (s = sb.toString()).length() == 0 || s.charAt(0) != ',' ? s : s.substring(1);
    }

    public static final String getConstraintString(LC lc, boolean asAPI) {
        String s;
        int debugMillis;
        int wrapAfter;
        int hideMode;
        UnitValue[] insets;
        Boolean leftToRight;
        StringBuffer sb = new StringBuffer(16);
        if (!lc.isFlowX()) {
            sb.append(asAPI ? ".flowY()" : ",flowy");
        }
        boolean fillX = lc.isFillX();
        boolean fillY = lc.isFillY();
        if (fillX || fillY) {
            if (fillX == fillY) {
                sb.append(asAPI ? ".fill()" : ",fill");
            } else {
                sb.append(asAPI ? (fillX ? ".fillX()" : ".fillY()") : (fillX ? ",fillx" : ",filly"));
            }
        }
        if ((leftToRight = lc.getLeftToRight()) != null) {
            if (asAPI) {
                sb.append(".leftToRight(").append(leftToRight).append(')');
            } else {
                sb.append(leftToRight != false ? ",ltr" : ",rtl");
            }
        }
        if (!lc.getPackWidth().isUnset() || !lc.getPackHeight().isUnset()) {
            if (asAPI) {
                String w = IDEUtil.getBS(lc.getPackWidth());
                String h = IDEUtil.getBS(lc.getPackHeight());
                sb.append(".pack(");
                if (w.equals("pref") && h.equals("pref")) {
                    sb.append(')');
                } else {
                    sb.append('\"').append(w).append("\", \"").append(h).append("\")");
                }
            } else {
                sb.append(",pack");
                String size = IDEUtil.getBS(lc.getPackWidth()) + " " + IDEUtil.getBS(lc.getPackHeight());
                if (!size.equals("pref pref")) {
                    sb.append(' ').append(size);
                }
            }
        }
        if (lc.getPackWidthAlign() != 0.5f || lc.getPackHeightAlign() != 1.0f) {
            if (asAPI) {
                sb.append(".packAlign(").append(IDEUtil.floatToString(lc.getPackWidthAlign(), asAPI)).append(", ").append(IDEUtil.floatToString(lc.getPackHeightAlign(), asAPI)).append(')');
            } else {
                sb.append(",packalign ").append(IDEUtil.floatToString(lc.getPackWidthAlign(), asAPI)).append(' ').append(IDEUtil.floatToString(lc.getPackHeightAlign(), asAPI));
            }
        }
        if (!lc.isTopToBottom()) {
            sb.append(asAPI ? ".bottomToTop()" : ",btt");
        }
        if ((insets = lc.getInsets()) != null) {
            String cs = LayoutUtil.getCCString(insets);
            if (cs != null) {
                if (asAPI) {
                    sb.append(".insets(\"").append(cs).append("\")");
                } else {
                    sb.append(",insets ").append(cs);
                }
            } else {
                sb.append(asAPI ? ".insets(\"" : ",insets ");
                for (int i = 0; i < insets.length; ++i) {
                    sb.append(IDEUtil.getUV(insets[i])).append(i < insets.length - 1 ? " " : "");
                }
                if (asAPI) {
                    sb.append("\")");
                }
            }
        }
        if (lc.isNoGrid()) {
            sb.append(asAPI ? ".noGrid()" : ",nogrid");
        }
        if (!lc.isVisualPadding()) {
            sb.append(asAPI ? ".noVisualPadding()" : ",novisualpadding");
        }
        if ((hideMode = lc.getHideMode()) > 0) {
            if (asAPI) {
                sb.append(".hideMode(").append(hideMode).append(')');
            } else {
                sb.append(",hideMode ").append(hideMode);
            }
        }
        IDEUtil.appendBoundSize(lc.getWidth(), sb, true, asAPI);
        IDEUtil.appendBoundSize(lc.getHeight(), sb, false, asAPI);
        UnitValue alignX = lc.getAlignX();
        UnitValue alignY = lc.getAlignY();
        if (alignX != null || alignY != null) {
            if (alignX != null && alignY != null) {
                sb.append(asAPI ? ".align(\"" : ",align ").append(IDEUtil.getUV(alignX)).append(' ').append(IDEUtil.getUV(alignY));
            } else if (alignX != null) {
                sb.append(asAPI ? ".alignX(\"" : ",alignx ").append(IDEUtil.getUV(alignX));
            } else if (alignY != null) {
                sb.append(asAPI ? ".alignY(\"" : ",aligny ").append(IDEUtil.getUV(alignY));
            }
            if (asAPI) {
                sb.append("\")");
            }
        }
        BoundSize gridGapX = lc.getGridGapX();
        BoundSize gridGapY = lc.getGridGapY();
        if (gridGapX != null || gridGapY != null) {
            if (gridGapX != null && gridGapY != null) {
                sb.append(asAPI ? ".gridGap(\"" : ",gap ").append(IDEUtil.getBS(gridGapX)).append(' ').append(IDEUtil.getBS(gridGapY));
            } else if (gridGapX != null) {
                sb.append(asAPI ? ".gridGapX(\"" : ",gapx ").append(IDEUtil.getBS(gridGapX));
            } else if (gridGapY != null) {
                sb.append(asAPI ? ".gridGapY(\"" : ",gapy ").append(IDEUtil.getBS(gridGapY));
            }
            if (asAPI) {
                sb.append("\")");
            }
        }
        if ((wrapAfter = lc.getWrapAfter()) != 2097051) {
            String ws;
            String string = ws = wrapAfter > 0 ? String.valueOf(wrapAfter) : "";
            if (asAPI) {
                sb.append(".wrap(").append(ws).append(')');
            } else {
                sb.append(",wrap ").append(ws);
            }
        }
        if ((debugMillis = lc.getDebugMillis()) > 0) {
            if (asAPI) {
                sb.append(".debug(").append(debugMillis).append(')');
            } else {
                sb.append(",debug ").append(debugMillis);
            }
        }
        return (s = sb.toString()).length() == 0 || s.charAt(0) != ',' ? s : s.substring(1);
    }

    private static String getUV(UnitValue uv) {
        return uv != null ? uv.getConstraintString() : "null";
    }

    private static String getBS(BoundSize bs) {
        return bs != null ? bs.getConstraintString() : "null";
    }

    private static final String floatToString(float f, boolean asAPI) {
        String valS = String.valueOf(f);
        return valS.endsWith(".0") ? valS.substring(0, valS.length() - 2) : valS + (asAPI ? "f" : "");
    }
}

