/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.gui.components;

import com.formdev.flatlaf.FlatDarkLaf;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import net.miginfocom.swing.MigLayout;
import org.praxislive.base.AbstractRoot;
import org.praxislive.base.AbstractRootContainer;
import org.praxislive.base.BindingContextControl;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.Control;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.Info;
import org.praxislive.core.Lookup;
import org.praxislive.core.protocols.ComponentProtocol;
import org.praxislive.core.protocols.ContainerProtocol;
import org.praxislive.core.protocols.StartableProtocol;
import org.praxislive.gui.GuiContext;

public class DefaultGuiRoot
extends AbstractRootContainer {
    private static final ComponentInfo INFO = Info.component(cmp -> cmp.merge(ComponentProtocol.API_INFO).merge(ContainerProtocol.API_INFO).merge(StartableProtocol.API_INFO));
    private static boolean lafConfigured = false;
    private JFrame frame;
    private JPanel container;
    private MigLayout layout;
    private LayoutChangeListener layoutListener;
    private BindingContextControl bindings;
    private Context context;
    private Lookup lookup;

    public Lookup getLookup() {
        return this.lookup == null ? super.getLookup() : this.lookup;
    }

    protected void activating() {
        SwingDelegate delegate = new SwingDelegate();
        this.attachDelegate(delegate);
        delegate.start();
    }

    protected void starting() {
        this.frame.pack();
        this.frame.setVisible(true);
    }

    protected void stopping() {
        this.frame.setVisible(false);
    }

    private void setup() {
        if (!lafConfigured) {
            this.setupLookAndFeel();
            lafConfigured = true;
        }
        this.frame = new JFrame();
        this.frame.setTitle("PRAXIS : " + this.getAddress());
        this.frame.setMinimumSize(new Dimension(150, 50));
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DefaultGuiRoot.this.setIdle();
            }
        });
        this.frame.getContentPane().setLayout(new MigLayout("fill", "[fill, grow]"));
        this.layout = new MigLayout("fill", "[fill]");
        this.container = new JPanel(this.layout);
        this.container.addContainerListener(new ChildrenListener());
        this.layoutListener = new LayoutChangeListener();
        this.frame.getContentPane().add((Component)new JScrollPane(this.container), "grow, push");
        this.bindings = new BindingContextControl(ControlAddress.of((ComponentAddress)this.getAddress(), (String)"_bindings"), this.getExecutionContext(), this.getRouter());
        this.registerControl("_bindings", (Control)this.bindings);
        this.context = new Context();
        this.lookup = Lookup.of((Lookup)super.getLookup(), (Object[])new Object[]{this.bindings, this.context});
    }

    private void setupLookAndFeel() {
        FlatDarkLaf.install();
    }

    private void dispose() {
        this.frame.setVisible(false);
        this.frame.dispose();
    }

    public ComponentInfo getInfo() {
        return INFO;
    }

    private void setLayoutConstraint(JComponent child) {
        this.layout.setComponentConstraints(child, child.getClientProperty("Praxis.LayoutConstraint"));
        this.container.revalidate();
        this.container.repaint();
    }

    private class LayoutChangeListener
    implements PropertyChangeListener {
        private LayoutChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof JComponent) {
                JComponent comp = (JComponent)evt.getSource();
                LayoutManager lm = DefaultGuiRoot.this.container.getLayout();
                if (lm instanceof MigLayout) {
                    ((MigLayout)lm).setComponentConstraints(comp, evt.getNewValue());
                    DefaultGuiRoot.this.container.revalidate();
                }
            }
        }
    }

    private class ChildrenListener
    implements ContainerListener {
        private ChildrenListener() {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            if (e.getChild() instanceof JComponent) {
                JComponent child = (JComponent)e.getChild();
                child.addPropertyChangeListener("Praxis.LayoutConstraint", DefaultGuiRoot.this.layoutListener);
                DefaultGuiRoot.this.setLayoutConstraint(child);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            if (e.getChild() instanceof JComponent) {
                ((JComponent)e.getChild()).removePropertyChangeListener("Praxis.LayoutConstraint", DefaultGuiRoot.this.layoutListener);
            }
        }
    }

    private class Context
    extends GuiContext {
        private Context() {
        }

        @Override
        public JComponent getContainer() {
            return DefaultGuiRoot.this.container;
        }
    }

    private class SwingDelegate
    extends AbstractRoot.Delegate {
        private Timer timer;

        private SwingDelegate() {
            super((AbstractRoot)DefaultGuiRoot.this);
        }

        private void start() {
            EventQueue.invokeLater(() -> {
                DefaultGuiRoot.this.setup();
                this.timer = new Timer(50, e -> this.update());
                this.timer.start();
            });
        }

        private void update() {
            boolean ok = this.doUpdate(DefaultGuiRoot.this.getRootHub().getClock().getTime());
            if (!ok) {
                this.timer.stop();
                DefaultGuiRoot.this.dispose();
                DefaultGuiRoot.this.detachDelegate(this);
            }
        }
    }
}

