/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.gui.components;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import org.praxislive.gui.components.Utils;

class JXYController
extends JComponent {
    private int controlWidth = 32;
    private int controlXPos;
    private int controlYPos;
    protected transient ChangeEvent changeEvent = null;
    private BoundedRangeModel xRangeModel;
    private BoundedRangeModel yRangeModel;
    private int mouseXOffset;
    private int mouseYOffset;
    private boolean draggingControl;

    public JXYController() {
        this.setPreferredSize(new Dimension(200, 200));
        MouseInput mouseAdapter = new MouseInput();
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
        this.addComponentListener(new ResizeHandler());
        this.mouseXOffset = 0;
        this.mouseYOffset = 0;
        this.draggingControl = false;
        this.xRangeModel = new DefaultBoundedRangeModel(0, 0, 0, 100);
        this.yRangeModel = new DefaultBoundedRangeModel(0, 0, 0, 100);
        ModelListener modelListener = new ModelListener();
        this.xRangeModel.addChangeListener(modelListener);
        this.yRangeModel.addChangeListener(modelListener);
    }

    public BoundedRangeModel getXRangeModel() {
        return this.xRangeModel;
    }

    public BoundedRangeModel getYRangeModel() {
        return this.yRangeModel;
    }

    public int getXValue() {
        return this.xRangeModel.getValue();
    }

    public int getYValue() {
        return this.yRangeModel.getValue();
    }

    public int getXMinimum() {
        return this.xRangeModel.getMinimum();
    }

    public int getYMinimum() {
        return this.yRangeModel.getMinimum();
    }

    public int getXMaximum() {
        return this.xRangeModel.getMaximum();
    }

    public int getYMaximum() {
        return this.yRangeModel.getMaximum();
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D g2d = (Graphics2D)graphics;
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.draggingControl) {
            g2d.setColor(Utils.mix(this.getBackground(), this.getForeground(), 0.4));
        } else {
            g2d.setColor(Utils.mix(this.getBackground(), this.getForeground(), 0.2));
        }
        g2d.fillRect(this.controlXPos + 2, this.controlYPos + 2, this.controlWidth - 2, this.controlWidth - 2);
        if (this.draggingControl) {
            g2d.setColor(this.getForeground());
        } else {
            g2d.setColor(Utils.mix(this.getBackground(), this.getForeground(), 0.8));
        }
        int radius = this.controlWidth / 2;
        g2d.drawLine(this.controlXPos + radius, 0, this.controlXPos + radius, height);
        g2d.drawLine(0, this.controlYPos + radius, width, this.controlYPos + radius);
        g2d.drawRect(this.controlXPos + 1, this.controlYPos + 1, this.controlWidth - 1, this.controlWidth - 1);
        g2d.setColor(Utils.mix(this.getBackground(), this.getForeground(), 0.6));
        g2d.drawRect(0, 0, width - 1, height - 1);
    }

    protected int xPositionForModelValue() {
        int normalizedValue = this.xRangeModel.getValue() - this.xRangeModel.getMinimum();
        int modelRange = this.xRangeModel.getMaximum() - this.xRangeModel.getMinimum();
        float ratio = (float)normalizedValue / (float)modelRange;
        return (int)(ratio * (float)(this.getWidth() - this.controlWidth));
    }

    protected int yPositionForModelValue() {
        int normalizedValue = this.yRangeModel.getValue() - this.yRangeModel.getMinimum();
        int modelRange = this.yRangeModel.getMaximum() - this.yRangeModel.getMinimum();
        float ratio = (float)normalizedValue / (float)modelRange;
        ratio = 1.0f - ratio;
        return (int)(ratio * (float)(this.getHeight() - this.controlWidth));
    }

    protected int xModelValueForPosition() {
        float ratio = (float)this.controlXPos / (float)(this.getWidth() - this.controlWidth);
        int modelRange = this.xRangeModel.getMaximum() - this.xRangeModel.getMinimum();
        return (int)(ratio * (float)modelRange + (float)this.xRangeModel.getMinimum());
    }

    protected int yModelValueForPosition() {
        float ratio = (float)this.controlYPos / (float)(this.getHeight() - this.controlWidth);
        ratio = 1.0f - ratio;
        int modelRange = this.yRangeModel.getMaximum() - this.yRangeModel.getMinimum();
        return (int)(ratio * (float)modelRange + (float)this.yRangeModel.getMinimum());
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    private class ResizeHandler
    extends ComponentAdapter {
        private ResizeHandler() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            JXYController.this.controlXPos = JXYController.this.xPositionForModelValue();
            JXYController.this.controlYPos = JXYController.this.yPositionForModelValue();
            JXYController.this.repaint();
        }
    }

    class MouseInput
    extends MouseInputAdapter {
        MouseInput() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (JXYController.this.draggingControl) {
                int x = mouseEvent.getX() - JXYController.this.mouseXOffset;
                int y = mouseEvent.getY() - JXYController.this.mouseYOffset;
                int xMax = JXYController.this.getWidth() - JXYController.this.controlWidth;
                int yMax = JXYController.this.getHeight() - JXYController.this.controlWidth;
                JXYController.this.controlXPos = x < 0 ? 0 : (x > xMax ? xMax : x);
                JXYController.this.controlYPos = y < 0 ? 0 : (y > yMax ? yMax : y);
                JXYController.this.xRangeModel.setValue(JXYController.this.xModelValueForPosition());
                JXYController.this.yRangeModel.setValue(JXYController.this.yModelValueForPosition());
                JXYController.this.repaint();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int x = mouseEvent.getX();
            int y = mouseEvent.getY();
            if (x >= JXYController.this.controlXPos && x < JXYController.this.controlXPos + JXYController.this.controlWidth && y >= JXYController.this.controlYPos && y < JXYController.this.controlYPos + JXYController.this.controlWidth) {
                JXYController.this.mouseXOffset = x - JXYController.this.controlXPos;
                JXYController.this.mouseYOffset = y - JXYController.this.controlYPos;
            } else {
                int rad = JXYController.this.controlWidth / 2;
                int maxY = JXYController.this.getHeight() - JXYController.this.controlWidth;
                int maxX = JXYController.this.getWidth() - JXYController.this.controlWidth;
                JXYController.this.controlXPos = x - rad;
                if (JXYController.this.controlXPos < 0) {
                    JXYController.this.controlXPos = 0;
                } else if (JXYController.this.controlXPos > maxX) {
                    JXYController.this.controlXPos = maxX;
                }
                JXYController.this.controlYPos = y - rad;
                if (JXYController.this.controlYPos < 0) {
                    JXYController.this.controlYPos = 0;
                } else if (JXYController.this.controlYPos > maxY) {
                    JXYController.this.controlYPos = maxY;
                }
                JXYController.this.mouseXOffset = x - JXYController.this.controlXPos;
                JXYController.this.mouseYOffset = y - JXYController.this.controlYPos;
            }
            JXYController.this.draggingControl = true;
            JXYController.this.xRangeModel.setValue(JXYController.this.xModelValueForPosition());
            JXYController.this.xRangeModel.setValueIsAdjusting(true);
            JXYController.this.yRangeModel.setValue(JXYController.this.yModelValueForPosition());
            JXYController.this.yRangeModel.setValueIsAdjusting(true);
            JXYController.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (JXYController.this.draggingControl) {
                JXYController.this.xRangeModel.setValue(JXYController.this.xModelValueForPosition());
                JXYController.this.xRangeModel.setValueIsAdjusting(false);
                JXYController.this.yRangeModel.setValue(JXYController.this.yModelValueForPosition());
                JXYController.this.yRangeModel.setValueIsAdjusting(false);
                JXYController.this.draggingControl = false;
                JXYController.this.repaint();
            }
        }
    }

    class ModelListener
    implements ChangeListener {
        ModelListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Object source = changeEvent.getSource();
            if (!JXYController.this.draggingControl) {
                if (source == JXYController.this.xRangeModel) {
                    JXYController.this.controlXPos = JXYController.this.xPositionForModelValue();
                    JXYController.this.repaint();
                } else if (source == JXYController.this.yRangeModel) {
                    JXYController.this.controlYPos = JXYController.this.yPositionForModelValue();
                    JXYController.this.repaint();
                }
            }
            JXYController.this.fireStateChanged();
        }
    }
}

