/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.gui.components;

import java.awt.Dimension;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.praxislive.gui.components.Utils;
import org.praxislive.gui.impl.AbstractGuiContainer;

public class Panel
extends AbstractGuiContainer {
    private JPanel panel;
    private MigLayout layout;

    @Override
    protected JComponent createSwingContainer() {
        if (this.panel != null) {
            throw new IllegalStateException();
        }
        this.layout = new MigLayout("", "[fill]");
        this.panel = new JPanel(this.layout);
        this.panel.addContainerListener(new ChildrenListener());
        this.panel.setMinimumSize(new Dimension(50, 20));
        return this.panel;
    }

    @Override
    protected void updateLabel() {
        super.updateLabel();
        this.updateBorder();
    }

    private void updateBorder() {
        if (this.isLabelOnParent()) {
            this.panel.setBorder(null);
        } else {
            String labelText = this.getLabel();
            if (labelText.isEmpty()) {
                this.panel.setBorder(Utils.getBorder());
            } else {
                this.panel.setBorder(BorderFactory.createTitledBorder(Utils.getBorder(), labelText));
            }
        }
    }

    private void setLayoutConstraint(JComponent child) {
        this.layout.setComponentConstraints(child, child.getClientProperty("Praxis.LayoutConstraint"));
        this.panel.revalidate();
        this.panel.repaint();
    }

    private class ChildrenListener
    implements ContainerListener {
        private PropertyChangeListener listener;

        private ChildrenListener() {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            if (this.listener == null) {
                this.listener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getSource() instanceof JComponent) {
                            Panel.this.setLayoutConstraint((JComponent)evt.getSource());
                        }
                    }
                };
            }
            if (e.getChild() instanceof JComponent) {
                JComponent child = (JComponent)e.getChild();
                child.addPropertyChangeListener("Praxis.LayoutConstraint", this.listener);
                Panel.this.setLayoutConstraint(child);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            if (this.listener == null) {
                return;
            }
            if (e.getChild() instanceof JComponent) {
                ((JComponent)e.getChild()).removePropertyChangeListener("Praxis.LayoutConstraint", this.listener);
            }
        }
    }
}

