/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.gui.components;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.basic.BasicSliderUI;
import org.praxislive.base.AbstractProperty;
import org.praxislive.base.Binding;
import org.praxislive.core.Control;
import org.praxislive.core.ControlInfo;
import org.praxislive.core.Info;
import org.praxislive.core.Value;
import org.praxislive.core.types.PBoolean;
import org.praxislive.core.types.PNumber;
import org.praxislive.core.types.PString;
import org.praxislive.gui.components.Utils;
import org.praxislive.gui.impl.BoundedValueAdaptor;
import org.praxislive.gui.impl.SingleBindingGuiComponent;

class Slider
extends SingleBindingGuiComponent {
    private static final Logger LOG = Logger.getLogger(Slider.class.getName());
    private final boolean vertical;
    private String labelText = "";
    private Box box;
    private JSlider slider;
    private BoundedValueAdaptor adaptor;
    private PNumber prefMin;
    private PNumber prefMax;

    public Slider(boolean vertical) {
        this.vertical = vertical;
    }

    @Override
    protected void initControls(Info.ComponentInfoBuilder cmpInfo) {
        super.initControls(cmpInfo);
        this.registerControl("minimum", (Control)new MinBinding());
        this.registerControl("maximum", (Control)new MaxBinding());
        ControlInfo rangeInfo = Info.control(c -> ((Info.PropertyInfoBuilder)c.property().property("allow-empty", (Object)PBoolean.TRUE)).property("empty-is-default", (Object)PBoolean.TRUE));
        cmpInfo.control("minimum", rangeInfo);
        cmpInfo.control("maximum", rangeInfo);
    }

    @Override
    protected JComponent createSwingComponent() {
        if (this.box == null) {
            this.createComponentAndAdaptor();
        }
        return this.box;
    }

    @Override
    protected Binding.Adaptor getBindingAdaptor() {
        if (this.adaptor == null) {
            this.createComponentAndAdaptor();
        }
        return this.adaptor;
    }

    private void createComponentAndAdaptor() {
        this.slider = new JSlider(this.vertical ? 1 : 0, 0, 500, 0);
        this.slider.setUI(new UI(this.slider));
        this.adaptor = new BoundedValueAdaptor(this.slider.getModel());
        if (this.prefMin != null) {
            this.adaptor.setPreferredMinimum(this.prefMin);
        }
        if (this.prefMax != null) {
            this.adaptor.setPreferredMaximum(this.prefMax);
        }
        this.slider.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                Slider.this.adaptor.setActive(true);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                Slider.this.adaptor.setActive(false);
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
        this.box = this.vertical ? Box.createVerticalBox() : Box.createHorizontalBox();
        this.box.add(this.slider);
        this.updateBorders();
    }

    private void updateBorders() {
        if (this.box != null) {
            Border etched = Utils.getBorder();
            if (this.labelText.isEmpty()) {
                this.box.setBorder(etched);
            } else {
                this.box.setBorder(BorderFactory.createTitledBorder(etched, this.labelText));
            }
            this.box.revalidate();
        }
    }

    @Override
    protected void updateLabel() {
        super.updateLabel();
        this.labelText = this.isLabelOnParent() ? "" : this.getLabel();
        this.updateBorders();
    }

    private static class UI
    extends BasicSliderUI {
        public UI(JSlider slider) {
            super(slider);
        }

        @Override
        protected Dimension getThumbSize() {
            if (this.slider.getOrientation() == 1) {
                return new Dimension(36, 12);
            }
            return new Dimension(12, 36);
        }

        @Override
        public void paintFocus(Graphics g) {
        }

        @Override
        public void paintTrack(Graphics g) {
            Rectangle r = this.trackRect;
            g.setColor(this.slider.hasFocus() ? Utils.mix(this.slider.getBackground(), this.slider.getForeground(), 0.8) : Utils.mix(this.slider.getBackground(), this.slider.getForeground(), 0.6));
            g.drawRect(r.x, r.y, r.width - 1, r.height - 1);
        }

        @Override
        public void paintThumb(Graphics g) {
            Rectangle r = this.thumbRect;
            if (this.isDragging()) {
                g.setColor(this.slider.getForeground());
            } else {
                g.setColor(Utils.mix(this.slider.getBackground(), this.slider.getForeground(), 0.8));
            }
            g.fillRect(r.x, r.y, r.width, r.height);
        }

        @Override
        protected BasicSliderUI.TrackListener createTrackListener(final JSlider slider) {
            return new BasicSliderUI.TrackListener(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (!slider.isEnabled()) {
                        return;
                    }
                    this.calculateGeometry();
                    this.currentMouseX = e.getX();
                    this.currentMouseY = e.getY();
                    if (slider.isRequestFocusEnabled()) {
                        slider.requestFocus();
                    }
                    switch (slider.getOrientation()) {
                        case 1: {
                            this.offset = this.currentMouseY - ((UI)this).thumbRect.y;
                            break;
                        }
                        case 0: {
                            this.offset = this.currentMouseX - ((UI)this).thumbRect.x;
                        }
                    }
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (!slider.isEnabled()) {
                        return;
                    }
                    this.currentMouseX = e.getX();
                    this.currentMouseY = e.getY();
                    slider.setValueIsAdjusting(true);
                    if (slider.getOrientation() == 1) {
                        int halfThumbHeight = ((UI)this).thumbRect.height / 2;
                        int thumbTop = e.getY() - this.offset;
                        int trackTop = ((UI)this).trackRect.y;
                        int trackBottom = ((UI)this).trackRect.y + (((UI)this).trackRect.height - 1);
                        int vMax = this.yPositionForValue(slider.getMaximum() - slider.getExtent());
                        if (this.drawInverted()) {
                            trackBottom = vMax;
                        } else {
                            trackTop = vMax;
                        }
                        thumbTop = Math.max(thumbTop, trackTop - halfThumbHeight);
                        thumbTop = Math.min(thumbTop, trackBottom - halfThumbHeight);
                        this.setThumbLocation(((UI)this).thumbRect.x, thumbTop);
                        int thumbMiddle = thumbTop + halfThumbHeight;
                        slider.setValue(this.valueForYPosition(thumbMiddle));
                    } else {
                        int halfThumbWidth = ((UI)this).thumbRect.width / 2;
                        int thumbLeft = e.getX() - this.offset;
                        int trackLeft = ((UI)this).trackRect.x;
                        int trackRight = ((UI)this).trackRect.x + (((UI)this).trackRect.width - 1);
                        int hMax = this.xPositionForValue(slider.getMaximum() - slider.getExtent());
                        if (this.drawInverted()) {
                            trackLeft = hMax;
                        } else {
                            trackRight = hMax;
                        }
                        thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
                        thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
                        this.setThumbLocation(thumbLeft, ((UI)this).thumbRect.y);
                        int thumbMiddle = thumbLeft + halfThumbWidth;
                        slider.setValue(this.valueForXPosition(thumbMiddle));
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (!slider.isEnabled()) {
                        return;
                    }
                    this.offset = 0;
                    slider.setValueIsAdjusting(false);
                    slider.repaint();
                }
            };
        }
    }

    private class MaxBinding
    extends AbstractProperty {
        private MaxBinding() {
        }

        public void set(long time, Value value) {
            Slider.this.prefMax = value.isEmpty() ? null : (PNumber)PNumber.from((Value)value).orElse(null);
            if (Slider.this.adaptor != null) {
                Slider.this.adaptor.setPreferredMaximum(Slider.this.prefMax);
            }
        }

        public Value get() {
            if (Slider.this.prefMax == null) {
                return PString.EMPTY;
            }
            return Slider.this.prefMax;
        }
    }

    private class MinBinding
    extends AbstractProperty {
        private MinBinding() {
        }

        public void set(long time, Value value) {
            Slider.this.prefMin = value.isEmpty() ? null : (PNumber)PNumber.from((Value)value).orElse(null);
            if (Slider.this.adaptor != null) {
                Slider.this.adaptor.setPreferredMinimum(Slider.this.prefMin);
            }
        }

        public Value get() {
            if (Slider.this.prefMin == null) {
                return PString.EMPTY;
            }
            return Slider.this.prefMin;
        }
    }
}

