/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.gui.impl;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.praxislive.base.AbstractComponent;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.Container;
import org.praxislive.core.Control;
import org.praxislive.core.Info;
import org.praxislive.core.VetoException;
import org.praxislive.core.protocols.ComponentProtocol;
import org.praxislive.gui.GuiContext;
import org.praxislive.gui.impl.LabelBinding;
import org.praxislive.gui.impl.LayoutBinding;

public abstract class AbstractGuiComponent
extends AbstractComponent {
    private JComponent component;
    private LabelBinding label;
    private LayoutBinding layout;
    private GuiContext context;
    private ComponentInfo info;

    public final JComponent getSwingComponent() {
        if (EventQueue.isDispatchThread()) {
            if (this.component == null) {
                this.component = this.createSwingComponent();
                Info.ComponentInfoBuilder cmpInfo = Info.component();
                cmpInfo.merge(ComponentProtocol.API_INFO);
                this.label = new LabelBinding(this.component);
                this.label.addPropertyChangeListener(new LabelListener());
                this.registerControl("label", (Control)this.label);
                cmpInfo.control("label", c -> c.property().input(i -> i.string()));
                this.initControls(cmpInfo);
                this.layout = new LayoutBinding(this.component);
                this.registerControl("layout", (Control)this.layout);
                cmpInfo.control("layout", c -> c.property().input(i -> i.string()));
                this.info = cmpInfo.build();
                this.updateLabel();
            }
            return this.component;
        }
        return null;
    }

    public ComponentInfo getInfo() {
        return this.info;
    }

    protected void initControls(Info.ComponentInfoBuilder cmpInfo) {
    }

    public void parentNotify(Container parent) throws VetoException {
        if (!EventQueue.isDispatchThread()) {
            throw new VetoException("Trying to install GUI component in GUI incompatible container.");
        }
        super.parentNotify(parent);
        this.getSwingComponent();
    }

    public void hierarchyChanged() {
        super.hierarchyChanged();
        GuiContext ctxt = this.getLookup().find(GuiContext.class).orElse(null);
        if (this.context != ctxt) {
            if (this.context != null) {
                this.context.getContainer().remove(this.getSwingComponent());
            }
            if (ctxt != null) {
                ctxt.getContainer().add(this.getSwingComponent());
            }
            this.context = ctxt;
        }
        this.getSwingComponent().putClientProperty("Praxis.Address", this.getAddress());
    }

    protected abstract JComponent createSwingComponent();

    protected void updateLabel() {
    }

    protected String getLabel() {
        return this.label == null ? "" : this.label.get().toString();
    }

    protected boolean isLabelOnParent() {
        return this.label == null ? false : this.label.isLabelOnParent();
    }

    private class LabelListener
    implements PropertyChangeListener {
        private LabelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            AbstractGuiComponent.this.updateLabel();
        }
    }
}

