/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.gui.impl;

import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.praxislive.base.AbstractContainer;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.Container;
import org.praxislive.core.Control;
import org.praxislive.core.Info;
import org.praxislive.core.Lookup;
import org.praxislive.core.VetoException;
import org.praxislive.core.protocols.ComponentProtocol;
import org.praxislive.core.protocols.ContainerProtocol;
import org.praxislive.gui.GuiContext;
import org.praxislive.gui.impl.LabelBinding;
import org.praxislive.gui.impl.LayoutBinding;

public abstract class AbstractGuiContainer
extends AbstractContainer {
    private JComponent component;
    private Lookup lookup;
    private LabelBinding label;
    private GuiContext context;
    private LayoutBinding layout;
    private ComponentInfo info;

    public final JComponent getSwingContainer() {
        if (EventQueue.isDispatchThread()) {
            if (this.component == null) {
                this.component = this.createSwingContainer();
                Info.ComponentInfoBuilder cmpInfo = Info.component();
                cmpInfo.merge(ComponentProtocol.API_INFO);
                cmpInfo.merge(ContainerProtocol.API_INFO);
                this.label = new LabelBinding(this.component);
                this.label.addPropertyChangeListener(new LabelListener());
                this.registerControl("label", (Control)this.label);
                cmpInfo.control("label", c -> c.property().input(i -> i.string()));
                this.initControls(cmpInfo);
                this.layout = new LayoutBinding(this.component);
                this.registerControl("layout", (Control)this.layout);
                cmpInfo.control("layout", c -> c.property().input(i -> i.string()));
                this.info = cmpInfo.build();
                this.updateLabel();
            }
            return this.component;
        }
        return null;
    }

    public ComponentInfo getInfo() {
        return this.info;
    }

    protected void initControls(Info.ComponentInfoBuilder cmpInfo) {
    }

    public void parentNotify(Container parent) throws VetoException {
        if (!EventQueue.isDispatchThread()) {
            throw new VetoException("Trying to install GUI component in GUI incompatible container.");
        }
        super.parentNotify(parent);
        this.getSwingContainer();
    }

    public void hierarchyChanged() {
        super.hierarchyChanged();
        GuiContext ctxt = super.getLookup().find(GuiContext.class).orElse(null);
        if (this.context != ctxt) {
            if (this.context != null) {
                this.context.getContainer().remove(this.getSwingContainer());
            }
            if (ctxt != null) {
                ctxt.getContainer().add(this.getSwingContainer());
            }
            this.context = ctxt;
        }
        this.getSwingContainer().putClientProperty("Praxis.Address", this.getAddress());
    }

    public Lookup getLookup() {
        if (this.lookup == null) {
            this.lookup = Lookup.of((Lookup)super.getLookup(), (Object[])new Object[]{new GuiContext(){

                @Override
                public JComponent getContainer() {
                    return AbstractGuiContainer.this.getSwingContainer();
                }
            }});
        }
        return this.lookup;
    }

    protected abstract JComponent createSwingContainer();

    protected void updateLabel() {
    }

    protected String getLabel() {
        return this.label.get().toString();
    }

    protected boolean isLabelOnParent() {
        return this.label.isLabelOnParent();
    }

    private class LabelListener
    implements PropertyChangeListener {
        private LabelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            AbstractGuiContainer.this.updateLabel();
        }
    }
}

