/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.gui.impl;

import java.util.List;
import java.util.logging.Logger;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.praxislive.base.Binding;
import org.praxislive.core.ArgumentInfo;
import org.praxislive.core.ControlInfo;
import org.praxislive.core.Value;
import org.praxislive.core.types.PNumber;
import org.praxislive.core.types.PString;
import org.praxislive.gui.impl.PMath;

public class BoundedValueAdaptor
extends Binding.Adaptor {
    private static final double DEFAULT_MINIMUM = 0.0;
    private static final double DEFAULT_MAXIMUM = 1.0;
    private static final Logger LOG = Logger.getLogger(BoundedValueAdaptor.class.getName());
    private BoundedRangeModel model;
    private ControlInfo info;
    private boolean isUpdating;
    private double minimum;
    private double maximum;
    private PNumber prefMin;
    private PNumber prefMax;
    private PNumber prefSkew;
    private PString prefScale;
    private double value;
    private Interpolator interpolator;

    public BoundedValueAdaptor(BoundedRangeModel model) {
        if (model == null) {
            throw new NullPointerException();
        }
        this.model = model;
        model.addChangeListener(new ChangeHandler());
        this.interpolator = new Interpolator(1.0);
        this.value = 0.0;
        this.minimum = 0.0;
        this.maximum = 1.0;
        this.updateModel();
        this.setSyncRate(Binding.SyncRate.Medium);
    }

    public void setPreferredMinimum(PNumber min) {
        this.prefMin = min;
        this.updateAllowedRange();
    }

    public PNumber getPreferredMinimum() {
        return this.prefMin;
    }

    public void setPreferredMaximum(PNumber max) {
        this.prefMax = max;
        this.updateAllowedRange();
    }

    public PNumber getPreferredMaximum() {
        return this.prefMax;
    }

    public void setPreferredSkew(PNumber skew) {
        this.prefSkew = skew;
        this.updateScale();
    }

    public PNumber getPreferredSkew() {
        return this.prefSkew;
    }

    @Deprecated
    public void setPreferredScale(PString scale) {
        this.prefScale = scale;
    }

    @Deprecated
    public PString getInterpolator() {
        return this.prefScale;
    }

    private void updateAllowedRange() {
        double max;
        PNumber calcMin;
        List aIn;
        PNumber infMin = null;
        PNumber infMax = null;
        if (this.info != null && !(aIn = this.info.inputs()).isEmpty()) {
            infMin = this.coerce(((ArgumentInfo)aIn.get(0)).properties().get("minimum"));
            infMax = this.coerce(((ArgumentInfo)aIn.get(0)).properties().get("maximum"));
        }
        double min = (calcMin = PMath.getMaximum(infMin, this.prefMin)) == null ? 0.0 : calcMin.value();
        PNumber calcMax = PMath.getMinimum(infMax, this.prefMax);
        double d = max = calcMax == null ? 1.0 : calcMax.value();
        if (max < min || min > max) {
            max = 0.0;
            min = 0.0;
        }
        this.minimum = min;
        this.maximum = max;
        this.updateModel();
    }

    private void updateScale() {
        List args;
        double skew = 1.0;
        if (this.prefSkew != null) {
            skew = this.prefSkew.value();
        } else if (this.info != null && !(args = this.info.outputs()).isEmpty()) {
            skew = ((ArgumentInfo)args.get(0)).properties().getDouble("skew", skew);
        }
        skew = skew < 0.125 ? 0.125 : (skew > 8.0 ? 8.0 : skew);
        this.interpolator = new Interpolator(skew);
        this.updateModel();
    }

    private PNumber coerce(Value arg) {
        if (arg == null) {
            return null;
        }
        return PNumber.from((Value)arg).orElse(null);
    }

    public void update() {
        Binding binding = this.getBinding();
        if (binding == null) {
            return;
        }
        List values = binding.getValues();
        if (!this.model.getValueIsAdjusting() && !values.isEmpty()) {
            try {
                double val = ((PNumber)PNumber.from((Value)((Value)values.get(0))).orElseThrow()).value();
                if (val != this.value) {
                    this.value = val;
                    this.updateModel();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void updateModel() {
        this.value = this.value < this.minimum ? this.minimum : (this.value > this.maximum ? this.maximum : this.value);
        int val = this.convertToInt(this.value);
        this.isUpdating = true;
        this.model.setValue(val);
        this.model.setExtent(0);
        this.isUpdating = false;
    }

    public void updateBindingConfiguration() {
        Binding binding = this.getBinding();
        this.info = binding == null ? null : (ControlInfo)binding.getControlInfo().orElse(null);
        this.updateAllowedRange();
        this.updateScale();
    }

    public boolean getValueIsAdjusting() {
        return this.model.getValueIsAdjusting();
    }

    private double convertToDouble(int value) {
        int mMin = this.model.getMinimum();
        int mMax = this.model.getMaximum();
        double ratio = (double)(value - mMin) / (double)(mMax - mMin);
        ratio = this.interpolator.interpolate(ratio);
        return ratio * (this.maximum - this.minimum) + this.minimum;
    }

    private int convertToInt(double value) {
        if (this.maximum == this.minimum) {
            return 0;
        }
        double ratio = (value - this.minimum) / (this.maximum - this.minimum);
        ratio = this.interpolator.reverseInterpolate(ratio);
        int mMin = this.model.getMinimum();
        int mMax = this.model.getMaximum();
        int val = (int)Math.round(ratio * (double)(mMax - mMin));
        return val += mMin;
    }

    private static class Interpolator {
        private final double skew;

        Interpolator(double skew) {
            this.skew = skew;
        }

        double interpolate(double value) {
            if (value <= 0.0) {
                return 0.0;
            }
            if (value >= 1.0) {
                return 1.0;
            }
            return Math.pow(value, this.skew);
        }

        double reverseInterpolate(double value) {
            if (value <= 0.0) {
                return 0.0;
            }
            if (value >= 1.0) {
                return 1.0;
            }
            return Math.pow(value, 1.0 / this.skew);
        }
    }

    private class ChangeHandler
    implements ChangeListener {
        private ChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (!BoundedValueAdaptor.this.isUpdating) {
                BoundedValueAdaptor.this.value = BoundedValueAdaptor.this.convertToDouble(BoundedValueAdaptor.this.model.getValue());
                BoundedValueAdaptor.this.send(List.of(PNumber.of((double)BoundedValueAdaptor.this.value)));
            }
        }
    }
}

