/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.gui.components;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.praxislive.base.Binding;
import org.praxislive.core.Value;
import org.praxislive.core.types.PString;
import org.praxislive.gui.components.Utils;
import org.praxislive.gui.impl.SingleBindingGuiComponent;

public class TextField
extends SingleBindingGuiComponent {
    private static final int DEFAULT_COLUMNS = 8;
    private Box panel;
    private JTextField text;
    private TextAdaptor adaptor;
    private boolean activeEdit;
    private Action sendAction;
    private Action resetAction;
    private boolean syncing;
    private String labelText = "";

    @Override
    protected Binding.Adaptor getBindingAdaptor() {
        if (this.adaptor == null) {
            this.createComponentAndAdaptor();
        }
        return this.adaptor;
    }

    @Override
    protected JComponent createSwingComponent() {
        if (this.panel == null) {
            this.createComponentAndAdaptor();
        }
        return this.panel;
    }

    private void createComponentAndAdaptor() {
        this.panel = Box.createHorizontalBox();
        this.text = new JTextField(8);
        this.text.getDocument().addDocumentListener(new TextListener());
        this.panel.add(this.text);
        this.adaptor = new TextAdaptor();
        this.text.addAncestorListener(this.adaptor);
        this.text.addFocusListener(this.adaptor);
        this.sendAction = new SendAction();
        this.sendAction.setEnabled(false);
        this.resetAction = new ResetAction();
        this.resetAction.setEnabled(false);
        Keymap map = JTextComponent.addKeymap(null, this.text.getKeymap());
        map.addActionForKeyStroke(KeyStroke.getKeyStroke("ENTER"), this.sendAction);
        map.addActionForKeyStroke(KeyStroke.getKeyStroke("ESCAPE"), this.resetAction);
        this.text.setKeymap(map);
        this.updateBorders();
    }

    private void setActiveEdit(boolean active) {
        if (active == this.activeEdit) {
            return;
        }
        this.sendAction.setEnabled(active);
        this.resetAction.setEnabled(active);
        this.activeEdit = active;
    }

    private void updateBorders() {
        if (this.panel != null) {
            Border etched = Utils.getBorder();
            if (this.labelText.isEmpty()) {
                this.panel.setBorder(etched);
            } else {
                this.panel.setBorder(BorderFactory.createTitledBorder(etched, this.labelText));
            }
            this.panel.revalidate();
        }
    }

    @Override
    protected void updateLabel() {
        super.updateLabel();
        this.labelText = this.isLabelOnParent() ? "" : this.getLabel();
        this.updateBorders();
    }

    private class ResetAction
    extends AbstractAction {
        private ResetAction() {
            super("Reset");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TextField.this.setActiveEdit(false);
            TextField.this.adaptor.sync();
        }
    }

    private class SendAction
    extends AbstractAction {
        private SendAction() {
            super("Send");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TextField.this.adaptor.send(TextField.this.text.getText());
            TextField.this.setActiveEdit(false);
        }
    }

    private class TextListener
    implements DocumentListener {
        private TextListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changed();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changed();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.changed();
        }

        private void changed() {
            if (!TextField.this.syncing) {
                TextField.this.setActiveEdit(true);
            }
        }
    }

    private class TextAdaptor
    extends Binding.Adaptor
    implements AncestorListener,
    FocusListener {
        private TextAdaptor() {
            this.setSyncRate(Binding.SyncRate.Low);
        }

        private void send(String text) {
            PString val = PString.of((String)text);
            this.send(List.of(val));
        }

        public void update() {
            if (TextField.this.activeEdit || TextField.this.text.isFocusOwner()) {
                return;
            }
            this.sync();
        }

        private void sync() {
            TextField.this.syncing = true;
            Binding binding = this.getBinding();
            if (binding == null) {
                TextField.this.text.setText("");
            } else {
                List args = binding.getValues();
                if (args.size() < 1) {
                    TextField.this.text.setText("");
                } else {
                    TextField.this.text.setText(((Value)args.get(0)).toString());
                }
            }
            TextField.this.syncing = false;
        }

        public void updateBindingConfiguration() {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            this.setActive(true);
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            this.setActive(false);
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public void focusGained(FocusEvent e) {
            TextField.this.text.selectAll();
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

