/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.gui.components;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.praxislive.base.AbstractProperty;
import org.praxislive.base.Binding;
import org.praxislive.core.ArgumentInfo;
import org.praxislive.core.ComponentType;
import org.praxislive.core.Control;
import org.praxislive.core.ControlInfo;
import org.praxislive.core.Info;
import org.praxislive.core.TreeWriter;
import org.praxislive.core.Value;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PString;
import org.praxislive.gui.components.Utils;
import org.praxislive.gui.impl.SingleBindingGuiComponent;

public class ComboBox
extends SingleBindingGuiComponent {
    private static final Logger LOG = Logger.getLogger(ComboBox.class.getName());
    private final List<Value> values;
    private PArray userValues = PArray.EMPTY;
    private Value current = PString.EMPTY;
    private ArgumentInfo boundInfo;
    private Value temp;
    private Box container;
    private JComboBox combo;
    private DefaultComboBoxModel model;
    private boolean isUpdating;
    private Adaptor adaptor;
    private String labelText = "";

    public ComboBox() {
        this.values = new ArrayList<Value>();
    }

    @Override
    protected void initControls(Info.ComponentInfoBuilder cmpInfo) {
        super.initControls(cmpInfo);
        this.registerControl("values", (Control)new ValuesBinding());
        cmpInfo.control("values", c -> c.property().input(PArray.class));
        cmpInfo.property("component-type", (Object)ComponentType.of((String)"gui:combobox"));
    }

    @Override
    public void write(TreeWriter writer) {
        super.write(writer);
        if (!this.userValues.isEmpty()) {
            writer.writeProperty("values", (Value)this.userValues);
        }
    }

    @Override
    protected Binding.Adaptor getBindingAdaptor() {
        if (this.adaptor == null) {
            this.createComponentAndAdaptor();
        }
        return this.adaptor;
    }

    @Override
    protected JComponent createSwingComponent() {
        if (this.container == null) {
            this.createComponentAndAdaptor();
        }
        return this.container;
    }

    private void createComponentAndAdaptor() {
        this.model = new DefaultComboBoxModel();
        this.combo = new JComboBox(this.model);
        this.combo.setBorder(new ComboBorder(this));
        this.combo.putClientProperty("JComboBox.isTableCellEditor", true);
        this.adaptor = new Adaptor();
        this.adaptor.setSyncRate(Binding.SyncRate.Medium);
        this.combo.addActionListener(this.adaptor);
        this.container = Box.createHorizontalBox();
        this.container.add(this.combo);
        this.combo.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                ComboBox.this.adaptor.setActive(true);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                ComboBox.this.adaptor.setActive(false);
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
        this.updateBorders();
    }

    @Override
    protected void updateLabel() {
        super.updateLabel();
        this.labelText = this.isLabelOnParent() ? "" : this.getLabel();
        this.updateBorders();
    }

    private void updateBorders() {
        if (this.container != null) {
            if (this.labelText.isEmpty()) {
                this.container.setBorder(BorderFactory.createEmptyBorder());
            } else {
                this.container.setBorder(BorderFactory.createTitledBorder(this.labelText));
            }
            this.container.revalidate();
        }
    }

    private void updateCurrent(Value current) {
        LOG.log(Level.FINEST, "Update current : {0}", current);
        if (Utils.equivalent(this.current, current)) {
            LOG.finest("Current is equivalent, returning.");
            return;
        }
        this.current = current;
        this.updateSelection();
    }

    private void updateSelection() {
        LOG.finest("Updating selection");
        this.isUpdating = true;
        if (this.temp != null && this.current != this.temp) {
            this.model.removeElement(this.temp);
            this.temp = null;
        }
        int idx = -1;
        int count = this.model.getSize();
        for (int i = 0; i < count; ++i) {
            Object o = this.model.getElementAt(i);
            if (!(o instanceof Value) || !Utils.equivalent(this.current, (Value)o)) continue;
            idx = i;
            LOG.log(Level.FINEST, "Found current in model at position : {0}", idx);
            break;
        }
        if (idx == -1) {
            this.temp = this.current;
            this.model.addElement(this.temp);
            this.model.setSelectedItem(this.temp);
        } else {
            this.model.setSelectedItem(this.model.getElementAt(idx));
        }
        LOG.log(Level.FINEST, "Combobox selection changed to : {0}", this.combo.getSelectedItem());
        this.isUpdating = false;
    }

    private void updateModel() {
        LOG.finest("Updating model");
        this.isUpdating = true;
        this.model.removeAllElements();
        this.temp = null;
        for (Value value : this.values) {
            LOG.log(Level.FINEST, "Adding to model from values : {0}", value);
            this.model.addElement(value);
        }
        this.isUpdating = false;
    }

    private void updateValues() {
        this.values.clear();
        boolean intersect = false;
        PArray infoValues = PArray.EMPTY;
        if (this.boundInfo != null) {
            Value p = this.boundInfo.properties().get("allowed-values");
            if (p == null) {
                p = this.boundInfo.properties().get("suggested-values");
            } else {
                LOG.log(Level.FINEST, "Found allowed-values : {0}", p);
                intersect = true;
            }
            if (p != null) {
                infoValues = PArray.from((Value)p).orElse(PArray.EMPTY);
            }
        }
        if (this.userValues.isEmpty()) {
            for (Value value : infoValues) {
                LOG.log(Level.FINEST, "Adding to values : {0}", value);
                this.values.add(value);
            }
        } else {
            block1: for (Value value : this.userValues) {
                if (intersect) {
                    for (Value allowed : infoValues) {
                        if (!Utils.equivalent(allowed, value)) continue;
                        LOG.log(Level.FINEST, "Adding to values : {0}", value);
                        this.values.add(value);
                        continue block1;
                    }
                    continue;
                }
                LOG.log(Level.FINEST, "Adding to values : {0}", value);
                this.values.add(value);
            }
        }
    }

    private class ValuesBinding
    extends AbstractProperty {
        private ValuesBinding() {
        }

        public void set(long time, Value value) throws Exception {
            ComboBox.this.userValues = (PArray)PArray.from((Value)value).orElseThrow(IllegalArgumentException::new);
            ComboBox.this.updateValues();
            ComboBox.this.updateModel();
            ComboBox.this.updateSelection();
        }

        public PArray get() {
            return ComboBox.this.userValues;
        }
    }

    private class Adaptor
    extends Binding.Adaptor
    implements ActionListener {
        private Adaptor() {
        }

        public void update() {
            List curArgs;
            LOG.finest("Binding update called");
            Binding binding = this.getBinding();
            if (binding != null && !(curArgs = binding.getValues()).isEmpty()) {
                ComboBox.this.updateCurrent((Value)curArgs.get(0));
            }
        }

        public void updateBindingConfiguration() {
            LOG.finest("Binding configuration update called");
            ComboBox.this.boundInfo = null;
            Binding binding = this.getBinding();
            if (binding != null) {
                ComboBox.this.boundInfo = binding.getControlInfo().map(ControlInfo::inputs).filter(i -> !i.isEmpty()).map(i -> (ArgumentInfo)i.get(0)).orElse(null);
            }
            ComboBox.this.updateValues();
            ComboBox.this.updateModel();
            ComboBox.this.updateSelection();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LOG.finest("ComboBox actionPerformed called");
            if (ComboBox.this.isUpdating) {
                LOG.finest("isUpdating - returning");
                return;
            }
            Object obj = ComboBox.this.combo.getSelectedItem();
            if (obj instanceof Value) {
                Value arg = (Value)obj;
                this.send(List.of(arg));
                ComboBox.this.updateCurrent(ComboBox.this.current);
            } else if (obj != null) {
                PString arg = PString.of((Object)obj);
                this.send(List.of(arg));
                ComboBox.this.updateCurrent(ComboBox.this.current);
            }
        }
    }

    private class ComboBorder
    implements Border {
        private ComboBorder(ComboBox comboBox) {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (c.hasFocus()) {
                g.setColor(Utils.mix(c.getBackground(), c.getForeground(), 0.8));
            } else {
                g.setColor(Utils.mix(c.getBackground(), c.getForeground(), 0.6));
            }
            g.drawRect(x, y, width - 1, height - 1);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(4, 4, 4, 4);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

