/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.gui.components;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.praxislive.base.Binding;
import org.praxislive.core.ComponentType;
import org.praxislive.core.Info;
import org.praxislive.core.Value;
import org.praxislive.core.types.PResource;
import org.praxislive.gui.components.Utils;
import org.praxislive.gui.impl.SingleBindingGuiComponent;

public class FileField
extends SingleBindingGuiComponent {
    private String labelText = "";
    private URIAdaptor adaptor;
    private Box box;
    private JTextField field;
    private JButton button;
    private PResource uri;

    @Override
    protected void initControls(Info.ComponentInfoBuilder cmpInfo) {
        super.initControls(cmpInfo);
        cmpInfo.property("component-type", (Object)ComponentType.of((String)"gui:filefield"));
    }

    @Override
    protected Binding.Adaptor getBindingAdaptor() {
        if (this.adaptor == null) {
            this.createComponentAndAdaptor();
        }
        return this.adaptor;
    }

    @Override
    protected JComponent createSwingComponent() {
        if (this.box == null) {
            this.createComponentAndAdaptor();
        }
        return this.box;
    }

    @Override
    protected void updateLabel() {
        super.updateLabel();
        this.labelText = this.isLabelOnParent() ? "" : this.getLabel();
        this.updateBorders();
    }

    private void createComponentAndAdaptor() {
        this.box = Box.createHorizontalBox();
        this.field = new JTextField(8);
        this.field.setEditable(false);
        this.field.setMaximumSize(new Dimension(this.field.getMaximumSize().width, this.field.getPreferredSize().height));
        this.button = new JButton("...");
        this.button.addActionListener(new FileButtonAction());
        this.adaptor = new URIAdaptor();
        this.box.add(this.field);
        this.box.add(this.button);
        this.box.addAncestorListener(this.adaptor);
        this.updateBorders();
    }

    private void updateField() {
        if (this.field == null) {
            return;
        }
        if (this.uri == null) {
            this.field.setText("");
        } else {
            try {
                File file = new File(this.uri.value());
                this.field.setText(file.getName());
            }
            catch (Exception ex) {
                this.field.setText(this.uri.toString());
            }
        }
    }

    private void updateBorders() {
        if (this.box != null) {
            if (this.labelText.isEmpty()) {
                this.box.setBorder(Utils.getBorder());
            } else {
                this.box.setBorder(BorderFactory.createTitledBorder(Utils.getBorder(), this.labelText));
            }
            this.box.revalidate();
        }
    }

    private class URIAdaptor
    extends Binding.Adaptor
    implements AncestorListener {
        private URIAdaptor() {
            this.setSyncRate(Binding.SyncRate.Low);
        }

        public void update() {
            Binding binding = this.getBinding();
            if (binding == null) {
                return;
            }
            List args = binding.getValues();
            if (args.size() > 0) {
                Value arg = (Value)args.get(0);
                if (arg.isEmpty()) {
                    if (FileField.this.uri != null) {
                        FileField.this.uri = null;
                        FileField.this.updateField();
                    }
                } else {
                    PResource u = PResource.from((Value)((Value)args.get(0))).orElse(null);
                    if (u != null) {
                        if (!u.equals((Object)FileField.this.uri)) {
                            FileField.this.uri = u;
                            FileField.this.updateField();
                        }
                    } else if (FileField.this.uri != null) {
                        FileField.this.uri = null;
                        FileField.this.updateField();
                    }
                }
            }
        }

        public void updateBindingConfiguration() {
        }

        public void send(PResource uri) {
            super.send(List.of(uri));
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            this.setActive(true);
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            this.setActive(false);
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    }

    private class FileButtonAction
    implements ActionListener {
        private FileButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File cur = null;
            if (FileField.this.uri != null) {
                try {
                    cur = new File(FileField.this.uri.value());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            JFileChooser chooser = cur == null ? new JFileChooser() : new JFileChooser(cur);
            int ret = chooser.showOpenDialog(FileField.this.box.getTopLevelAncestor());
            System.out.println("File Dialog returned " + ret);
            if (ret == 0) {
                URI u = chooser.getSelectedFile().toURI();
                FileField.this.uri = PResource.of((URI)u);
                FileField.this.adaptor.send(FileField.this.uri);
                FileField.this.updateField();
            }
        }
    }
}

