/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.gui.components;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.praxislive.gui.components.Utils;

class JRangeSlider
extends JComponent
implements MouseListener,
MouseMotionListener,
KeyListener {
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    public static final int LEFTRIGHT_TOPBOTTOM = 0;
    public static final int RIGHTLEFT_BOTTOMTOP = 1;
    public static final int PREFERRED_BREADTH = 36;
    public static final int PREFERRED_LENGTH = 200;
    protected static final int ARROW_SZ = 12;
    protected BoundedRangeModel model;
    protected int orientation;
    protected int direction;
    protected boolean empty;
    protected int increment = 1;
    protected int minExtent = 0;
    protected ArrayList listeners = new ArrayList();
    protected ChangeEvent changeEvent = null;
    protected ChangeListener lstnr;
    static final int PICK_NONE = 0;
    static final int PICK_LEFT_OR_TOP = 1;
    static final int PICK_THUMB = 2;
    static final int PICK_RIGHT_OR_BOTTOM = 3;
    int pick;
    int pickOffsetLow;
    int pickOffsetHigh;
    int mouse;

    public JRangeSlider(int minimum, int maximum, int lowValue, int highValue, int orientation) {
        this(new DefaultBoundedRangeModel(lowValue, highValue - lowValue, minimum, maximum), orientation, 0);
    }

    public JRangeSlider(int minimum, int maximum, int lowValue, int highValue, int orientation, int direction) {
        this(new DefaultBoundedRangeModel(lowValue, highValue - lowValue, minimum, maximum), orientation, direction);
    }

    public JRangeSlider(BoundedRangeModel model, int orientation, int direction) {
        super.setFocusable(true);
        this.model = model;
        this.orientation = orientation;
        this.direction = direction;
        this.lstnr = this.createListener();
        model.addChangeListener(this.lstnr);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
    }

    protected ChangeListener createListener() {
        return new RangeSliderChangeListener();
    }

    public int getLowValue() {
        return this.model.getValue();
    }

    public void setLowValue(int lowValue) {
        int e = this.model.getValue() - lowValue + this.model.getExtent();
        this.model.setRangeProperties(lowValue, e, this.model.getMinimum(), this.model.getMaximum(), false);
        this.model.setValue(lowValue);
    }

    public int getHighValue() {
        return this.model.getValue() + this.model.getExtent();
    }

    public void setHighValue(int highValue) {
        this.model.setExtent(highValue - this.model.getValue());
    }

    public void setRange(int lowValue, int highValue) {
        this.model.setRangeProperties(lowValue, highValue - lowValue, this.model.getMinimum(), this.model.getMaximum(), false);
    }

    public int getMinimum() {
        return this.model.getMinimum();
    }

    public void setMinimum(int minimum) {
        this.model.setMinimum(minimum);
    }

    public int getMaximum() {
        return this.model.getMaximum();
    }

    public void setMaximum(int maximum) {
        this.model.setMaximum(maximum);
    }

    public void setMinExtent(int minExtent) {
        this.minExtent = minExtent;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
        this.repaint();
    }

    public BoundedRangeModel getModel() {
        return this.model;
    }

    public void setModel(BoundedRangeModel brm) {
        this.model.removeChangeListener(this.lstnr);
        this.model = brm;
        this.model.addChangeListener(this.lstnr);
        this.repaint();
    }

    public void addChangeListener(ChangeListener cl) {
        if (!this.listeners.contains(cl)) {
            this.listeners.add(cl);
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        this.listeners.remove(cl);
    }

    protected void fireChangeEvent() {
        this.repaint();
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ChangeListener)iter.next()).stateChanged(this.changeEvent);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.orientation == 0) {
            return new Dimension(36, 200);
        }
        return new Dimension(200, 36);
    }

    @Override
    public void paintComponent(Graphics g) {
        Rectangle bounds = this.getBounds();
        int width = (int)bounds.getWidth();
        int height = (int)bounds.getHeight();
        int min = this.toScreen(this.getLowValue());
        int max = this.toScreen(this.getHighValue());
        if (this.empty) {
            if (this.direction == 0) {
                min = 12;
                max = this.orientation == 0 ? height - 12 : width - 12;
            } else {
                min = this.orientation == 0 ? height - 12 : width - 12;
                max = 12;
            }
        }
        Graphics2D g2 = (Graphics2D)g;
        this.paintTrack(g2, 0, 0, width, height);
        if (this.orientation == 0) {
            if (this.direction == 0) {
                this.paintHandle(g2, 0, min - 12, width, 12, this.pick == 1);
                this.paintThumb(g2, 0, min, width, max - min, this.pick == 2);
                this.paintHandle(g2, 0, max, width, 12, this.pick == 3);
            } else {
                this.paintHandle(g2, 0, min, width, 12, this.pick == 1);
                this.paintThumb(g2, 0, max, width, min - max, this.pick == 2);
                this.paintHandle(g2, 0, max - 12, width, 12, this.pick == 3);
            }
        } else if (this.direction == 0) {
            this.paintHandle(g2, min - 12, 0, 12, height, this.pick == 1);
            this.paintThumb(g2, min, 0, max - min, height, this.pick == 2);
            this.paintHandle(g2, max, 0, 12, height, this.pick == 3);
        } else {
            this.paintHandle(g2, min, 0, 12, height, this.pick == 1);
            this.paintThumb(g2, max, 0, min - max, height, this.pick == 2);
            this.paintHandle(g2, max - 12, 0, 12, height, this.pick == 3);
        }
    }

    private void paintTrack(Graphics2D g2, int x, int y, int w, int h) {
        g2.setColor(this.hasFocus() ? Utils.mix(this.getBackground(), this.getForeground(), 0.8) : Utils.mix(this.getBackground(), this.getForeground(), 0.6));
        g2.drawRect(x, y, w - 1, h - 1);
    }

    private void paintThumb(Graphics2D g2, int x, int y, int w, int h, boolean selected) {
        if (selected) {
            g2.setColor(Utils.mix(this.getBackground(), this.getForeground(), 0.4));
        } else {
            g2.setColor(Utils.mix(this.getBackground(), this.getForeground(), 0.3));
        }
        g2.fillRect(x, y, w, h);
    }

    private void paintHandle(Graphics2D g2, int x, int y, int w, int h, boolean selected) {
        if (selected) {
            g2.setColor(this.getForeground());
        } else {
            g2.setColor(Utils.mix(this.getBackground(), this.getForeground(), 0.8));
        }
        g2.fillRect(x, y, w, h);
    }

    protected int toLocal(int xOrY) {
        Dimension sz = this.getSize();
        int min = this.getMinimum();
        double scale = this.orientation == 0 ? (double)(sz.height - 24) / (double)(this.getMaximum() - min) : (double)(sz.width - 24) / (double)(this.getMaximum() - min);
        if (this.direction == 0) {
            return (int)((double)(xOrY - 12) / scale + (double)min + 0.5);
        }
        if (this.orientation == 0) {
            return (int)((double)(sz.height - xOrY - 12) / scale + (double)min + 0.5);
        }
        return (int)((double)(sz.width - xOrY - 12) / scale + (double)min + 0.5);
    }

    protected int toScreen(int xOrY) {
        Dimension sz = this.getSize();
        int min = this.getMinimum();
        double scale = this.orientation == 0 ? (double)(sz.height - 24) / (double)(this.getMaximum() - min) : (double)(sz.width - 24) / (double)(this.getMaximum() - min);
        if (this.direction == 0) {
            return (int)(12.0 + (double)(xOrY - min) * scale + 0.5);
        }
        if (this.orientation == 0) {
            return (int)((double)sz.height - (double)(xOrY - min) * scale - 12.0 + 0.5);
        }
        return (int)((double)sz.width - (double)(xOrY - min) * scale - 12.0 + 0.5);
    }

    protected double toScreenDouble(int xOrY) {
        Dimension sz = this.getSize();
        int min = this.getMinimum();
        double scale = this.orientation == 0 ? (double)(sz.height - 24) / (double)(this.getMaximum() + 1 - min) : (double)(sz.width - 24) / (double)(this.getMaximum() + 1 - min);
        if (this.direction == 0) {
            return 12.0 + (double)(xOrY - min) * scale;
        }
        if (this.orientation == 0) {
            return (double)sz.height - (double)(xOrY - min) * scale - 12.0;
        }
        return (double)sz.width - (double)(xOrY - min) * scale - 12.0;
    }

    private int pickHandle(int xOrY) {
        int min = this.toScreen(this.getLowValue());
        int max = this.toScreen(this.getHighValue());
        int pick = 0;
        if (this.direction == 0) {
            if (xOrY < min) {
                pick = 1;
            } else if (xOrY >= min && xOrY <= max) {
                pick = 2;
            } else if (xOrY > max) {
                pick = 3;
            }
        } else if (xOrY > min && xOrY < min + 12) {
            pick = 1;
        } else if (xOrY <= min && xOrY >= max) {
            pick = 2;
        } else if (xOrY > max - 12 && xOrY < max) {
            pick = 3;
        }
        return pick;
    }

    private void offset(int dxOrDy) {
        this.model.setValue(this.model.getValue() + dxOrDy);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.orientation == 0) {
            this.pick = this.pickHandle(e.getY());
            this.pickOffsetLow = e.getY() - this.toScreen(this.getLowValue());
            this.pickOffsetHigh = e.getY() - this.toScreen(this.getHighValue());
            this.mouse = e.getY();
        } else {
            this.pick = this.pickHandle(e.getX());
            this.pickOffsetLow = e.getX() - this.toScreen(this.getLowValue());
            this.pickOffsetHigh = e.getX() - this.toScreen(this.getHighValue());
            this.mouse = e.getX();
        }
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.requestFocus();
        int value = this.orientation == 0 ? e.getY() : e.getX();
        int minimum = this.getMinimum();
        int maximum = this.getMaximum();
        int lowValue = this.getLowValue();
        int highValue = this.getHighValue();
        switch (this.pick) {
            case 1: {
                int low = this.toLocal(value - this.pickOffsetLow);
                if (low < minimum) {
                    low = minimum;
                }
                if (low > maximum - this.minExtent) {
                    low = maximum - this.minExtent;
                }
                if (low > highValue - this.minExtent) {
                    this.setRange(low, low + this.minExtent);
                    break;
                }
                this.setLowValue(low);
                break;
            }
            case 3: {
                int high = this.toLocal(value - this.pickOffsetHigh);
                if (high < minimum + this.minExtent) {
                    high = minimum + this.minExtent;
                }
                if (high > maximum) {
                    high = maximum;
                }
                if (high < lowValue + this.minExtent) {
                    this.setRange(high - this.minExtent, high);
                    break;
                }
                this.setHighValue(high);
                break;
            }
            case 2: {
                int dxOrDy = this.toLocal(value - this.pickOffsetLow) - lowValue;
                if (dxOrDy < 0 && lowValue + dxOrDy < minimum) {
                    dxOrDy = minimum - lowValue;
                }
                if (dxOrDy > 0 && highValue + dxOrDy > maximum) {
                    dxOrDy = maximum - highValue;
                }
                if (dxOrDy == 0) break;
                this.offset(dxOrDy);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.pick = 0;
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.orientation == 0) {
            switch (this.pickHandle(e.getY())) {
                case 1: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 3: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 2: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 0: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        } else {
            switch (this.pickHandle(e.getX())) {
                case 1: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 3: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 2: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break;
                }
                case 0: {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void grow(int increment) {
        this.model.setRangeProperties(this.model.getValue() - increment, this.model.getExtent() + 2 * increment, this.model.getMinimum(), this.model.getMaximum(), false);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int kc = e.getKeyCode();
        boolean v = this.orientation == 0;
        boolean d = kc == 40;
        boolean u = kc == 38;
        boolean l = kc == 37;
        boolean r = kc == 39;
        int minimum = this.getMinimum();
        int maximum = this.getMaximum();
        int lowValue = this.getLowValue();
        int highValue = this.getHighValue();
        if (v && r || !v && u) {
            if (lowValue - this.increment >= minimum && highValue + this.increment <= maximum) {
                this.grow(this.increment);
            }
        } else if (v && l || !v && d) {
            if (highValue - lowValue >= 2 * this.increment) {
                this.grow(-1 * this.increment);
            }
        } else if (v && d || !v && l) {
            if (lowValue - this.increment >= minimum) {
                this.offset(-this.increment);
            }
        } else if ((v && u || !v && r) && highValue + this.increment <= maximum) {
            this.offset(this.increment);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    protected class RangeSliderChangeListener
    implements ChangeListener {
        protected RangeSliderChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JRangeSlider.this.fireChangeEvent();
        }
    }
}

