/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.gui.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ComponentType;
import org.praxislive.core.Info;
import org.praxislive.gui.components.Utils;
import org.praxislive.gui.impl.AbstractGuiContainer;

public class Tabs
extends AbstractGuiContainer {
    private JTabbedPane tabs;
    private LabelListener addressListener;

    @Override
    protected void initControls(Info.ComponentInfoBuilder cmpInfo) {
        super.initControls(cmpInfo);
        cmpInfo.property("component-type", (Object)ComponentType.of((String)"gui:tabs"));
    }

    @Override
    protected JComponent createSwingContainer() {
        if (this.tabs == null) {
            this.tabs = new JTabbedPane();
            this.tabs.setUI(new UI());
            this.tabs.addContainerListener(new ChildrenListener());
            this.tabs.setMinimumSize(new Dimension(50, 20));
        }
        return this.tabs;
    }

    private void setTabName(JComponent cmp) {
        String label;
        Object val = cmp.getClientProperty("Praxis.Label");
        if (val instanceof String && !(label = (String)val).isEmpty()) {
            this.setTabName(cmp, label);
            cmp.putClientProperty("Praxis.LabelOnParent", true);
            return;
        }
        cmp.putClientProperty("Praxis.LabelOnParent", false);
        val = cmp.getClientProperty("Praxis.Address");
        if (val instanceof ComponentAddress) {
            ComponentAddress ad = (ComponentAddress)val;
            this.setTabName(cmp, ad.componentID());
            return;
        }
        this.setTabName(cmp, cmp.getName());
    }

    private void setTabName(JComponent cmp, String name) {
        int index = this.tabs.indexOfComponent(cmp);
        if (index > -1) {
            this.tabs.setTitleAt(index, name);
        }
    }

    private static class UI
    extends BasicTabbedPaneUI {
        private UI() {
        }

        @Override
        protected void installDefaults() {
            super.installDefaults();
            this.tabInsets = new Insets(8, 8, 8, 8);
            this.selectedTabPadInsets = new Insets(0, 0, 0, 0);
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            this.lightHighlight = Utils.mix(this.tabPane.getBackground(), this.tabPane.getForeground(), 0.3);
            this.shadow = Utils.mix(this.tabPane.getBackground(), this.tabPane.getForeground(), 0.2);
            super.paint(g, c);
        }

        @Override
        protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        }

        @Override
        protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
            if (isSelected) {
                if (this.getRolloverTab() == tabIndex) {
                    g.setColor(this.tabPane.getForeground());
                } else {
                    g.setColor(Utils.mix(this.tabPane.getBackground(), this.tabPane.getForeground(), 0.8));
                }
                g.fillRect(x, y, w, h);
            } else {
                g.setColor(Utils.mix(this.tabPane.getBackground(), this.tabPane.getForeground(), 0.2));
                if (this.getRolloverTab() == tabIndex) {
                    g.fillRect(x, y, w, h);
                } else {
                    g.drawRect(x, y, w - 1, h - 1);
                }
            }
        }

        @Override
        protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        }

        @Override
        protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
            if (isSelected) {
                g.setColor(this.tabPane.getBackgroundAt(tabIndex));
            } else {
                g.setColor(this.tabPane.getForegroundAt(tabIndex));
            }
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
        }
    }

    private class ChildrenListener
    implements ContainerListener {
        private ChildrenListener() {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            if (Tabs.this.addressListener == null) {
                Tabs.this.addressListener = new LabelListener();
            }
            Component child = e.getChild();
            child.addPropertyChangeListener("Praxis.Label", Tabs.this.addressListener);
            if (child instanceof JComponent) {
                Tabs.this.setTabName((JComponent)child);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            e.getChild().removePropertyChangeListener("Praxis.Label", Tabs.this.addressListener);
        }
    }

    private class LabelListener
    implements PropertyChangeListener {
        private LabelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof JComponent) {
                JComponent cmp = (JComponent)evt.getSource();
                Tabs.this.setTabName(cmp);
            }
        }
    }
}

