/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.gui.components;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.praxislive.base.AbstractProperty;
import org.praxislive.base.Binding;
import org.praxislive.base.BindingContext;
import org.praxislive.core.ComponentType;
import org.praxislive.core.Control;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.ControlInfo;
import org.praxislive.core.Info;
import org.praxislive.core.TreeWriter;
import org.praxislive.core.Value;
import org.praxislive.core.ValueFormatException;
import org.praxislive.core.types.PBoolean;
import org.praxislive.core.types.PNumber;
import org.praxislive.core.types.PString;
import org.praxislive.gui.components.JXYController;
import org.praxislive.gui.components.Utils;
import org.praxislive.gui.impl.AbstractGuiComponent;
import org.praxislive.gui.impl.BoundedValueAdaptor;

public class XYController
extends AbstractGuiComponent {
    private static Logger logger = Logger.getLogger(XYController.class.getName());
    private final Preferences xPrefs = new Preferences(this);
    private final Preferences yPrefs = new Preferences(this);
    private BindingContext bindingContext;
    private Box container;
    private JXYController controller;
    private BoundedValueAdaptor xAdaptor;
    private BoundedValueAdaptor yAdaptor;
    private ControlAddress xBinding;
    private ControlAddress yBinding;

    @Override
    protected void initControls(Info.ComponentInfoBuilder cmpInfo) {
        super.initControls(cmpInfo);
        this.registerControl("binding-x", (Control)new XAddressBinding());
        this.registerControl("binding-y", (Control)new YAddressBinding());
        ControlInfo bindingInfo = Info.control(c -> c.property().input(ControlAddress.class).property("allow-empty", (Object)PBoolean.TRUE));
        cmpInfo.control("binding-x", bindingInfo);
        cmpInfo.control("binding-y", bindingInfo);
        this.registerControl("minimum-x", (Control)new MinBinding(this.xPrefs));
        this.registerControl("minimum-y", (Control)new MinBinding(this.yPrefs));
        this.registerControl("maximum-x", (Control)new MaxBinding(this.xPrefs));
        this.registerControl("maximum-y", (Control)new MaxBinding(this.yPrefs));
        ControlInfo rangeInfo = Info.control(c -> ((Info.PropertyInfoBuilder)c.property().input(Value.class).property("allow-empty", (Object)PBoolean.TRUE)).property("empty-is-default", (Object)PBoolean.TRUE));
        cmpInfo.control("minimum-x", rangeInfo);
        cmpInfo.control("minimum-y", rangeInfo);
        cmpInfo.control("maximum-x", rangeInfo);
        cmpInfo.control("maximum-y", rangeInfo);
        cmpInfo.property("component-type", (Object)ComponentType.of((String)"gui:xy-pad"));
    }

    @Override
    public void write(TreeWriter writer) {
        super.write(writer);
        if (this.xBinding != null) {
            writer.writeProperty("binding-x", (Value)this.xBinding);
        }
        if (this.yBinding != null) {
            writer.writeProperty("binding-y", (Value)this.yBinding);
        }
        if (this.xPrefs.minimum != null) {
            writer.writeProperty("minimum-x", (Value)this.xPrefs.minimum);
        }
        if (this.yPrefs.minimum != null) {
            writer.writeProperty("minimum-y", (Value)this.yPrefs.minimum);
        }
        if (this.xPrefs.maximum != null) {
            writer.writeProperty("maximum-x", (Value)this.xPrefs.maximum);
        }
        if (this.yPrefs.maximum != null) {
            writer.writeProperty("maximum-y", (Value)this.yPrefs.maximum);
        }
    }

    @Override
    protected JComponent createSwingComponent() {
        if (this.container == null) {
            this.createComponentAndAdaptors();
        }
        return this.container;
    }

    @Override
    protected void updateLabel() {
        super.updateLabel();
        this.updateBorders();
    }

    private void createComponentAndAdaptors() {
        this.container = Box.createHorizontalBox();
        this.controller = new JXYController();
        this.controller.setAlignmentX(0.5f);
        this.controller.setAlignmentY(0.5f);
        this.xAdaptor = new BoundedValueAdaptor(this.controller.getXRangeModel());
        this.yAdaptor = new BoundedValueAdaptor(this.controller.getYRangeModel());
        this.controller.addAncestorListener(new AncestorAdaptor());
        this.updateAdaptors();
        this.updateBorders();
        this.container.add(this.controller);
    }

    private void updateAdaptors() {
        if (this.xAdaptor != null && this.yAdaptor != null) {
            this.xAdaptor.setPreferredMinimum(this.xPrefs.minimum);
            this.xAdaptor.setPreferredMaximum(this.xPrefs.maximum);
            this.yAdaptor.setPreferredMinimum(this.yPrefs.minimum);
            this.yAdaptor.setPreferredMaximum(this.yPrefs.maximum);
        }
    }

    private void updateBorders() {
        String lbl;
        String string = lbl = this.isLabelOnParent() ? "" : this.getLabel();
        if (this.container != null) {
            if (lbl.isEmpty()) {
                this.container.setBorder(Utils.getBorder());
            } else {
                this.container.setBorder(BorderFactory.createTitledBorder(Utils.getBorder(), lbl));
            }
            this.container.revalidate();
        }
    }

    @Override
    public void hierarchyChanged() {
        super.hierarchyChanged();
        BindingContext ctxt = this.getLookup().find(BindingContext.class).orElse(null);
        if (this.bindingContext != ctxt) {
            if (this.bindingContext != null) {
                if (this.xBinding != null) {
                    this.bindingContext.unbind(this.xBinding, (Binding.Adaptor)this.xAdaptor);
                }
                if (this.yBinding != null) {
                    this.bindingContext.unbind(this.yBinding, (Binding.Adaptor)this.yAdaptor);
                }
            }
            if (ctxt != null) {
                if (this.xBinding != null) {
                    ctxt.bind(this.xBinding, (Binding.Adaptor)this.xAdaptor);
                }
                if (this.yBinding != null) {
                    ctxt.bind(this.yBinding, (Binding.Adaptor)this.yAdaptor);
                }
            }
            this.bindingContext = ctxt;
        }
    }

    private class Preferences {
        PNumber minimum;
        PNumber maximum;
        PString scale;

        private Preferences(XYController xYController) {
        }
    }

    private class XAddressBinding
    extends AbstractProperty {
        private XAddressBinding() {
        }

        public void set(long time, Value value) {
            if (XYController.this.xAdaptor == null) {
                XYController.this.createComponentAndAdaptors();
            }
            if (XYController.this.bindingContext != null) {
                if (XYController.this.xBinding != null) {
                    XYController.this.bindingContext.unbind(XYController.this.xBinding, (Binding.Adaptor)XYController.this.xAdaptor);
                }
                if (value.isEmpty()) {
                    XYController.this.xBinding = null;
                } else {
                    try {
                        XYController.this.xBinding = (ControlAddress)ControlAddress.from((Value)value).get();
                        XYController.this.bindingContext.bind(XYController.this.xBinding, (Binding.Adaptor)XYController.this.xAdaptor);
                    }
                    catch (Exception ex) {
                        logger.log(Level.WARNING, "Could not create binding-x", ex);
                        XYController.this.xBinding = null;
                    }
                }
            }
        }

        public Value get() {
            return XYController.this.xBinding == null ? PString.EMPTY : XYController.this.xBinding;
        }
    }

    private class YAddressBinding
    extends AbstractProperty {
        private YAddressBinding() {
        }

        public void set(long time, Value value) {
            if (XYController.this.yAdaptor == null) {
                XYController.this.createComponentAndAdaptors();
            }
            if (XYController.this.bindingContext != null) {
                if (XYController.this.yBinding != null) {
                    XYController.this.bindingContext.unbind(XYController.this.yBinding, (Binding.Adaptor)XYController.this.yAdaptor);
                }
                if (value.isEmpty()) {
                    XYController.this.yBinding = null;
                } else {
                    try {
                        XYController.this.yBinding = (ControlAddress)ControlAddress.from((Value)value).orElseThrow(ValueFormatException::new);
                        XYController.this.bindingContext.bind(XYController.this.yBinding, (Binding.Adaptor)XYController.this.yAdaptor);
                    }
                    catch (ValueFormatException ex) {
                        logger.log(Level.WARNING, "Could not create binding-y", ex);
                        XYController.this.yBinding = null;
                    }
                }
            }
        }

        public Value get() {
            return XYController.this.yBinding == null ? PString.EMPTY : XYController.this.yBinding;
        }
    }

    private class MinBinding
    extends AbstractProperty {
        private final Preferences prefs;

        private MinBinding(Preferences prefs) {
            this.prefs = prefs;
        }

        public void set(long time, Value value) {
            if (value.isEmpty()) {
                this.prefs.minimum = null;
            } else {
                try {
                    this.prefs.minimum = (PNumber)PNumber.from((Value)value).get();
                }
                catch (Exception ex) {
                    this.prefs.minimum = null;
                }
            }
            XYController.this.updateAdaptors();
        }

        public Value get() {
            PNumber arg = this.prefs.minimum;
            if (arg == null) {
                return PString.EMPTY;
            }
            return arg;
        }
    }

    private class MaxBinding
    extends AbstractProperty {
        private final Preferences prefs;

        private MaxBinding(Preferences prefs) {
            this.prefs = prefs;
        }

        public void set(long time, Value value) {
            if (value.isEmpty()) {
                this.prefs.maximum = null;
            } else {
                try {
                    this.prefs.maximum = (PNumber)PNumber.from((Value)value).get();
                }
                catch (Exception ex) {
                    this.prefs.maximum = null;
                }
            }
            XYController.this.updateAdaptors();
        }

        public Value get() {
            PNumber arg = this.prefs.maximum;
            if (arg == null) {
                return PString.EMPTY;
            }
            return arg;
        }
    }

    private class AncestorAdaptor
    implements AncestorListener {
        private AncestorAdaptor() {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            XYController.this.xAdaptor.setActive(true);
            XYController.this.yAdaptor.setActive(true);
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            XYController.this.xAdaptor.setActive(false);
            XYController.this.yAdaptor.setActive(false);
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    }
}

