/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.gui.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.ConstraintParser;
import net.miginfocom.layout.IDEUtil;
import org.praxislive.base.AbstractProperty;
import org.praxislive.core.Value;
import org.praxislive.core.types.PString;

class LayoutBinding
extends AbstractProperty
implements PropertyChangeListener {
    private final JComponent component;
    private PString layoutString = PString.EMPTY;

    LayoutBinding(JComponent component) {
        this.component = component;
        component.addPropertyChangeListener("Praxis.LayoutConstraint", this);
    }

    protected void set(long time, Value arg) throws Exception {
        PString value = PString.of((Object)arg);
        CC constraint = arg.isEmpty() ? null : ConstraintParser.parseComponentConstraint(value.toString());
        this.component.putClientProperty("Praxis.LayoutConstraint", constraint);
        this.layoutString = value;
    }

    protected Value get() {
        if (this.layoutString == null) {
            try {
                CC constraint = (CC)this.component.getClientProperty("Praxis.LayoutConstraint");
                this.layoutString = PString.of((String)IDEUtil.getConstraintString(constraint, false));
            }
            catch (Exception ex) {
                this.layoutString = PString.EMPTY;
            }
        }
        return this.layoutString;
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        this.layoutString = null;
    }
}

