/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.gui.impl;

import org.praxislive.base.AbstractProperty;
import org.praxislive.base.Binding;
import org.praxislive.base.BindingContext;
import org.praxislive.core.Control;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.Info;
import org.praxislive.core.TreeWriter;
import org.praxislive.core.Value;
import org.praxislive.core.types.PBoolean;
import org.praxislive.core.types.PString;
import org.praxislive.gui.impl.AbstractGuiComponent;

public abstract class SingleBindingGuiComponent
extends AbstractGuiComponent {
    private ControlAddress binding;
    private Binding.Adaptor adaptor;
    private BindingContext bindingContext;

    protected SingleBindingGuiComponent() {
    }

    @Override
    protected void initControls(Info.ComponentInfoBuilder cmpInfo) {
        super.initControls(cmpInfo);
        this.registerControl("binding", (Control)new AddressBinding());
        cmpInfo.control("binding", c -> c.property().input(ControlAddress.class).property("allow-empty", (Object)PBoolean.TRUE));
    }

    @Override
    public void hierarchyChanged() {
        super.hierarchyChanged();
        BindingContext ctxt = this.getLookup().find(BindingContext.class).orElse(null);
        if (this.bindingContext != ctxt) {
            if (this.bindingContext != null && this.binding != null) {
                this.bindingContext.unbind(this.binding, this.adaptor);
            }
            if (ctxt != null && this.binding != null) {
                ctxt.bind(this.binding, this.adaptor);
            }
            this.bindingContext = ctxt;
        }
    }

    @Override
    public void write(TreeWriter writer) {
        super.write(writer);
        if (this.binding != null) {
            writer.writeProperty("binding", (Value)this.binding);
        }
    }

    protected abstract Binding.Adaptor getBindingAdaptor();

    private class AddressBinding
    extends AbstractProperty {
        private AddressBinding() {
        }

        protected void set(long time, Value arg) throws Exception {
            if (SingleBindingGuiComponent.this.adaptor == null) {
                SingleBindingGuiComponent.this.adaptor = SingleBindingGuiComponent.this.getBindingAdaptor();
            }
            if (SingleBindingGuiComponent.this.bindingContext != null) {
                if (SingleBindingGuiComponent.this.binding != null) {
                    SingleBindingGuiComponent.this.bindingContext.unbind(SingleBindingGuiComponent.this.binding, SingleBindingGuiComponent.this.adaptor);
                }
                if (arg.isEmpty()) {
                    SingleBindingGuiComponent.this.binding = null;
                } else {
                    try {
                        SingleBindingGuiComponent.this.binding = (ControlAddress)ControlAddress.from((Value)arg).orElseThrow();
                        SingleBindingGuiComponent.this.bindingContext.bind(SingleBindingGuiComponent.this.binding, SingleBindingGuiComponent.this.adaptor);
                    }
                    catch (Exception ex) {
                        SingleBindingGuiComponent.this.binding = null;
                    }
                }
            }
        }

        protected Value get() {
            return SingleBindingGuiComponent.this.binding == null ? PString.EMPTY : SingleBindingGuiComponent.this.binding;
        }
    }
}

