/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.gui.impl;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ButtonModel;
import org.praxislive.base.Binding;
import org.praxislive.core.ControlInfo;
import org.praxislive.core.Value;
import org.praxislive.core.types.PString;

public class ToggleButtonModelAdaptor
extends Binding.Adaptor {
    private static Logger logger = Logger.getLogger(ToggleButtonModelAdaptor.class.getName());
    private ButtonModel model;
    private Value onArg;
    private Value offArg;
    private boolean isProperty;
    private ControlInfo info;
    private boolean isUpdating;

    public ToggleButtonModelAdaptor(ButtonModel model) {
        if (model == null) {
            throw new NullPointerException();
        }
        model.addActionListener(new ActionHandler());
        this.model = model;
        this.onArg = this.offArg = PString.EMPTY;
        this.setSyncRate(Binding.SyncRate.Low);
    }

    public void setOnArgument(Value onArg) {
        if (onArg == null) {
            throw new NullPointerException();
        }
        this.onArg = onArg;
        if (this.isProperty) {
            this.update();
        }
    }

    public Value getOnArgument() {
        return this.onArg;
    }

    public void setOffArgument(Value offArg) {
        if (offArg == null) {
            throw new NullPointerException();
        }
        this.offArg = offArg;
        if (this.isProperty) {
            this.update();
        }
    }

    public Value getOffArgument() {
        return this.offArg;
    }

    public void update() {
        this.isUpdating = true;
        this.model.setSelected(this.checkSelection());
        this.isUpdating = false;
    }

    public void updateBindingConfiguration() {
        this.isProperty = false;
        Binding binding = this.getBinding();
        if (binding != null) {
            this.isProperty = binding.getControlInfo().map(ControlInfo::controlType).map(t -> t == ControlInfo.Type.Property || t == ControlInfo.Type.ReadOnlyProperty).orElse(Boolean.FALSE);
        }
    }

    protected boolean checkSelection() {
        Binding binding = this.getBinding();
        if (binding == null) {
            return false;
        }
        List args = binding.getValues();
        if (!args.isEmpty()) {
            Value arg = (Value)args.get(0);
            return arg.equivalent(this.onArg) || this.onArg.equivalent(arg);
        }
        return false;
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ToggleButtonModelAdaptor.this.isUpdating) {
                return;
            }
            Value arg = ToggleButtonModelAdaptor.this.model.isSelected() ? ToggleButtonModelAdaptor.this.onArg : ToggleButtonModelAdaptor.this.offArg;
            ToggleButtonModelAdaptor.this.send(List.of(arg));
        }
    }
}

