/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.gui.components;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import org.praxislive.base.AbstractProperty;
import org.praxislive.base.Binding;
import org.praxislive.core.Call;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ComponentType;
import org.praxislive.core.Control;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.ExecutionContext;
import org.praxislive.core.Info;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.TreeWriter;
import org.praxislive.core.Value;
import org.praxislive.core.services.ScriptService;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PString;
import org.praxislive.gui.components.Utils;
import org.praxislive.gui.impl.ActionAdaptor;
import org.praxislive.gui.impl.SingleBindingGuiComponent;

public class Button
extends SingleBindingGuiComponent {
    private static final Logger LOG = Logger.getLogger(Button.class.getName());
    private JButton button;
    private ActionAdaptor adaptor;
    private List<Value> values = List.of();
    private OnClickProperty onClick;

    @Override
    protected void initControls(Info.ComponentInfoBuilder cmpInfo) {
        super.initControls(cmpInfo);
        this.registerControl("values", (Control)new ValuesBinding());
        cmpInfo.control("values", c -> c.property().input(PArray.class));
        this.onClick = new OnClickProperty(this);
        this.registerControl("on-click", (Control)new OnClickProperty(this));
        cmpInfo.control("on-click", c -> c.property().input(i -> i.string().mime("text/x-praxis-script")));
        this.registerControl("_on-click-log", new OnClickLog(this));
        cmpInfo.property("component-type", (Object)ComponentType.of((String)"gui:button"));
    }

    @Override
    public void write(TreeWriter writer) {
        super.write(writer);
        if (!this.values.isEmpty()) {
            writer.writeProperty("values", (Value)PArray.of(this.values));
        }
        if (!this.onClick.value.isEmpty()) {
            writer.writeProperty("on-click", (Value)this.onClick.value);
        }
    }

    @Override
    protected void updateLabel() {
        super.updateLabel();
        this.button.setText(this.getLabel());
    }

    @Override
    protected JComponent createSwingComponent() {
        if (this.button == null) {
            this.createComponentAndAdaptor();
        }
        return this.button;
    }

    @Override
    protected Binding.Adaptor getBindingAdaptor() {
        if (this.adaptor == null) {
            this.createComponentAndAdaptor();
        }
        return this.adaptor;
    }

    private void createComponentAndAdaptor() {
        this.button = new JButton();
        this.button.setUI(new UI());
        this.adaptor = new ActionAdaptor();
        this.button.addActionListener(this.adaptor);
        this.adaptor.setCallArguments(this.values);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Button.this.processOnClick();
            }
        });
        this.button.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                Button.this.adaptor.setActive(true);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                Button.this.adaptor.setActive(false);
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    private void processOnClick() {
        try {
            String script = this.onClick.get().toString().trim();
            if (script.isEmpty()) {
                return;
            }
            ControlAddress to = ControlAddress.of((ComponentAddress)this.findService(ScriptService.class), (String)"eval");
            ControlAddress from = ControlAddress.of((ComponentAddress)this.getAddress(), (String)"_on-click-log");
            Call call = Call.createQuiet((ControlAddress)to, (ControlAddress)from, (long)((ExecutionContext)this.getLookup().find(ExecutionContext.class).get()).getTime(), (Value)PString.of((String)script));
            ((PacketRouter)this.getLookup().find(PacketRouter.class).get()).route((Packet)call);
        }
        catch (Exception ex) {
            Logger.getLogger(Button.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private class ValuesBinding
    extends AbstractProperty {
        private PArray value = PArray.EMPTY;

        private ValuesBinding() {
        }

        public void set(long time, Value value) {
            PArray arr = (PArray)PArray.from((Value)value).orElseThrow(IllegalArgumentException::new);
            Button.this.values = arr.isEmpty() ? List.of() : arr.stream().collect(Collectors.toList());
            this.value = arr;
            Button.this.adaptor.setCallArguments(Button.this.values);
        }

        public Value get() {
            return this.value;
        }
    }

    private class OnClickProperty
    extends AbstractProperty {
        private PString value = PString.EMPTY;

        private OnClickProperty(Button button) {
        }

        protected void set(long time, Value arg) throws Exception {
            this.value = PString.of((Object)arg);
        }

        protected Value get() {
            return this.value;
        }
    }

    private class OnClickLog
    implements Control {
        private OnClickLog(Button button) {
        }

        public void call(Call call, PacketRouter router) throws Exception {
            if (call.isError()) {
                LOG.warning(call.toString());
            }
        }
    }

    private static class UI
    extends BasicButtonUI {
        private UI() {
        }

        @Override
        public void installUI(JComponent c) {
            super.installUI(c);
            AbstractButton b = (AbstractButton)c;
            b.setRolloverEnabled(true);
            b.setBorder(new EmptyBorder(8, 8, 8, 8));
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            AbstractButton b = (AbstractButton)c;
            g.setColor(b.hasFocus() || b.getModel().isRollover() ? Utils.mix(c.getBackground(), c.getForeground(), 0.8) : Utils.mix(c.getBackground(), c.getForeground(), 0.6));
            g.drawRect(0, 0, c.getWidth() - 1, c.getHeight() - 1);
            super.paint(g, c);
        }

        @Override
        protected void paintButtonPressed(Graphics g, AbstractButton b) {
            g.setColor(b.getForeground());
            g.fillRect(0, 0, b.getWidth(), b.getHeight());
        }

        @Override
        protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
            Color fg = b.getForeground();
            ButtonModel model = b.getModel();
            FontMetrics fm = g.getFontMetrics();
            int mnemonicIndex = b.getDisplayedMnemonicIndex();
            if (model.isPressed() || model.isSelected()) {
                g.setColor(b.getBackground());
            } else if (!model.isRollover()) {
                g.setColor(Utils.mix(b.getBackground(), fg, 0.8));
            } else {
                g.setColor(b.getForeground());
            }
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
        }
    }
}

