/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.gui.components;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import org.praxislive.base.AbstractProperty;
import org.praxislive.base.Binding;
import org.praxislive.core.ComponentType;
import org.praxislive.core.Control;
import org.praxislive.core.Info;
import org.praxislive.core.TreeWriter;
import org.praxislive.core.Value;
import org.praxislive.core.types.PBoolean;
import org.praxislive.gui.components.Utils;
import org.praxislive.gui.impl.SingleBindingGuiComponent;
import org.praxislive.gui.impl.ToggleButtonModelAdaptor;

public class ToggleButton
extends SingleBindingGuiComponent {
    private JToggleButton button;
    private Value onArg = PBoolean.TRUE;
    private Value offArg = PBoolean.FALSE;
    private ToggleButtonModelAdaptor adaptor;

    @Override
    protected void initControls(Info.ComponentInfoBuilder cmpInfo) {
        super.initControls(cmpInfo);
        this.registerControl("on-value", (Control)new OnBinding());
        cmpInfo.control("on-value", c -> c.property().input(Value.class).defaultValue((Value)PBoolean.TRUE));
        this.registerControl("off-value", (Control)new OffBinding());
        cmpInfo.control("off-value", c -> c.property().input(Value.class).defaultValue((Value)PBoolean.FALSE));
        cmpInfo.property("component-type", (Object)ComponentType.of((String)"gui:togglebutton"));
    }

    @Override
    public void write(TreeWriter writer) {
        super.write(writer);
        if (!PBoolean.TRUE.equivalent(this.onArg)) {
            writer.writeProperty("on-value", this.onArg);
        }
        if (!PBoolean.FALSE.equivalent(this.offArg)) {
            writer.writeProperty("off-value", this.offArg);
        }
    }

    @Override
    protected void updateLabel() {
        super.updateLabel();
        this.button.setText(this.getLabel());
    }

    @Override
    protected Binding.Adaptor getBindingAdaptor() {
        if (this.adaptor == null) {
            this.createComponentAndAdaptor();
        }
        return this.adaptor;
    }

    @Override
    protected JComponent createSwingComponent() {
        if (this.button == null) {
            this.createComponentAndAdaptor();
        }
        return this.button;
    }

    private void createComponentAndAdaptor() {
        this.button = new JToggleButton(this.getLabel());
        this.button.setUI(new UI());
        this.adaptor = new ToggleButtonModelAdaptor(this.button.getModel());
        this.setAdaptorArguments();
        this.button.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                ToggleButton.this.adaptor.setActive(true);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                ToggleButton.this.adaptor.setActive(false);
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    private void setAdaptorArguments() {
        if (this.adaptor != null) {
            this.adaptor.setOnArgument(this.onArg);
            this.adaptor.setOffArgument(this.offArg);
        }
    }

    private class OnBinding
    extends AbstractProperty {
        private OnBinding() {
        }

        public void set(long time, Value value) {
            ToggleButton.this.onArg = value;
            ToggleButton.this.setAdaptorArguments();
        }

        public Value get() {
            return ToggleButton.this.onArg;
        }
    }

    private class OffBinding
    extends AbstractProperty {
        private OffBinding() {
        }

        public void set(long time, Value value) {
            ToggleButton.this.offArg = value;
            ToggleButton.this.setAdaptorArguments();
        }

        public Value get() {
            return ToggleButton.this.offArg;
        }
    }

    private static class UI
    extends BasicToggleButtonUI {
        private UI() {
        }

        @Override
        public void installUI(JComponent c) {
            super.installUI(c);
            AbstractButton b = (AbstractButton)c;
            b.setRolloverEnabled(true);
            b.setBorder(new EmptyBorder(8, 8, 8, 8));
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            AbstractButton b = (AbstractButton)c;
            g.setColor(b.hasFocus() || b.getModel().isRollover() ? Utils.mix(c.getBackground(), c.getForeground(), 0.8) : Utils.mix(c.getBackground(), c.getForeground(), 0.6));
            g.drawRect(0, 0, c.getWidth() - 1, c.getHeight() - 1);
            super.paint(g, c);
        }

        @Override
        protected void paintButtonPressed(Graphics g, AbstractButton b) {
            g.setColor(b.getForeground());
            g.fillRect(4, 4, b.getWidth() - 8, b.getHeight() - 8);
        }

        @Override
        protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
            ButtonModel model = b.getModel();
            FontMetrics fm = g.getFontMetrics();
            int mnemonicIndex = b.getDisplayedMnemonicIndex();
            if (model.isPressed() || model.isSelected()) {
                g.setColor(b.getBackground());
            } else if (!model.isRollover()) {
                g.setColor(Utils.mix(b.getBackground(), b.getForeground(), 0.8));
            } else {
                g.setColor(b.getForeground());
            }
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemonicIndex, textRect.x + this.getTextShiftOffset(), textRect.y + fm.getAscent() + this.getTextShiftOffset());
        }
    }
}

