/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.gui.components;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import net.miginfocom.swing.MigLayout;
import org.praxislive.base.Binding;
import org.praxislive.core.ComponentType;
import org.praxislive.core.Info;
import org.praxislive.core.Value;
import org.praxislive.core.types.PString;
import org.praxislive.gui.impl.SingleBindingGuiComponent;

public class TextArea
extends SingleBindingGuiComponent {
    private JPanel panel;
    private JTextArea text;
    private TextAdaptor adaptor;
    private boolean activeEdit;
    private Action sendAction;
    private Action resetAction;
    private boolean syncing;

    @Override
    protected void initControls(Info.ComponentInfoBuilder cmpInfo) {
        super.initControls(cmpInfo);
        cmpInfo.property("component-type", (Object)ComponentType.of((String)"gui:textarea"));
    }

    @Override
    protected Binding.Adaptor getBindingAdaptor() {
        if (this.adaptor == null) {
            this.createComponentAndAdaptor();
        }
        return this.adaptor;
    }

    @Override
    protected JComponent createSwingComponent() {
        if (this.panel == null) {
            this.createComponentAndAdaptor();
        }
        return this.panel;
    }

    private void createComponentAndAdaptor() {
        this.panel = new JPanel(new MigLayout("fill", "[grow]", "[grow][nogrid]"));
        this.text = new JTextArea();
        this.text.getDocument().addDocumentListener(new TextListener());
        JScrollPane sp = new JScrollPane(this.text, 20, 30);
        this.panel.add((Component)sp, "grow, wrap, width 450, height 300");
        this.adaptor = new TextAdaptor();
        this.text.addAncestorListener(this.adaptor);
        this.sendAction = new SendAction();
        this.sendAction.setEnabled(false);
        this.panel.add((Component)new JButton(this.sendAction), "tag ok");
        this.resetAction = new ResetAction();
        this.resetAction.setEnabled(false);
        this.panel.add((Component)new JButton(this.resetAction), "tag cancel");
        Keymap map = JTextComponent.addKeymap("PraxisTextArea", this.text.getKeymap());
        map.addActionForKeyStroke(KeyStroke.getKeyStroke("control ENTER"), this.sendAction);
        map.addActionForKeyStroke(KeyStroke.getKeyStroke("ESCAPE"), this.resetAction);
        this.text.setKeymap(map);
    }

    private void setActiveEdit(boolean active) {
        if (active == this.activeEdit) {
            return;
        }
        this.sendAction.setEnabled(active);
        this.resetAction.setEnabled(active);
        this.activeEdit = active;
    }

    private class TextAdaptor
    extends Binding.Adaptor
    implements AncestorListener {
        private TextAdaptor() {
            this.setSyncRate(Binding.SyncRate.Low);
        }

        private void send(String text) {
            PString val = PString.of((String)text);
            this.send(List.of(val));
        }

        public void update() {
            if (TextArea.this.activeEdit || TextArea.this.text.isFocusOwner()) {
                return;
            }
            this.sync();
        }

        private void sync() {
            TextArea.this.syncing = true;
            Binding binding = this.getBinding();
            if (binding == null) {
                TextArea.this.text.setText("");
            } else {
                List args = binding.getValues();
                if (args.size() < 1) {
                    TextArea.this.text.setText("");
                } else {
                    TextArea.this.text.setText(((Value)args.get(0)).toString());
                }
            }
            TextArea.this.syncing = false;
        }

        protected void onError(List<Value> args) {
            JOptionPane.showMessageDialog(TextArea.this.panel, args, "Error", 0);
        }

        public void updateBindingConfiguration() {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            this.setActive(true);
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            this.setActive(false);
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    }

    private class TextListener
    implements DocumentListener {
        private TextListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changed();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changed();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.changed();
        }

        private void changed() {
            if (!TextArea.this.syncing) {
                TextArea.this.setActiveEdit(true);
            }
        }
    }

    private class SendAction
    extends AbstractAction {
        private SendAction() {
            super("Send");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TextArea.this.adaptor.send(TextArea.this.text.getText());
            TextArea.this.setActiveEdit(false);
        }
    }

    private class ResetAction
    extends AbstractAction {
        private ResetAction() {
            super("Reset");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TextArea.this.setActiveEdit(false);
            TextArea.this.adaptor.sync();
        }
    }
}

