/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.hub;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.praxislive.base.AbstractAsyncControl;
import org.praxislive.base.AbstractRoot;
import org.praxislive.core.Call;
import org.praxislive.core.Component;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.Control;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.Root;
import org.praxislive.core.RootHub;
import org.praxislive.core.Value;
import org.praxislive.core.services.RootFactoryService;
import org.praxislive.core.services.RootManagerService;
import org.praxislive.core.services.Service;
import org.praxislive.core.services.SystemManagerService;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PError;
import org.praxislive.core.types.PReference;
import org.praxislive.core.types.PString;
import org.praxislive.hub.Hub;

public class BasicCoreRoot
extends AbstractRoot {
    private static final Logger LOG = Logger.getLogger(BasicCoreRoot.class.getName());
    private final Hub.Accessor hubAccess;
    private final List<Root> exts;
    private final Map<String, Control> controls;
    private AbstractRoot.Controller controller;

    protected BasicCoreRoot(Hub.Accessor hubAccess, List<Root> exts) {
        this.hubAccess = Objects.requireNonNull(hubAccess);
        this.exts = Objects.requireNonNull(exts);
        this.controls = new HashMap<String, Control>();
    }

    public AbstractRoot.Controller initialize(String id, RootHub hub) {
        AbstractRoot.Controller ctrl;
        this.controller = ctrl = super.initialize(id, hub);
        return ctrl;
    }

    protected void activating() {
        this.registerServices();
        HashMap<String, Control> ctrls = new HashMap<String, Control>();
        this.buildControlMap(ctrls);
        this.controls.putAll(ctrls);
        this.installExtensions();
        this.setRunning();
    }

    protected void terminating() {
        String[] ids;
        for (String id : ids = this.hubAccess.getRootIDs()) {
            this.uninstallRoot(id);
        }
    }

    protected void forceTermination() {
        this.controller.shutdown();
        this.interrupt();
    }

    protected void processCall(Call call, PacketRouter router) {
        block5: {
            Control control = this.controls.get(call.to().controlID());
            try {
                if (control != null) {
                    control.call(call, router);
                } else if (call.isRequest()) {
                    router.route((Packet)call.error(PError.of((String)("Unknown control address : " + call.to()))));
                }
            }
            catch (Exception ex) {
                if (!call.isRequest()) break block5;
                router.route((Packet)call.error(PError.of((Exception)ex)));
            }
        }
    }

    protected void registerServices() {
        this.hubAccess.registerService(RootManagerService.class, this.getAddress());
        this.hubAccess.registerService(SystemManagerService.class, this.getAddress());
    }

    protected void buildControlMap(Map<String, Control> ctrls) {
        ctrls.computeIfAbsent("add-root", k -> new AddRootControl());
        ctrls.computeIfAbsent("remove-root", k -> new RemoveRootControl());
        ctrls.computeIfAbsent("roots", k -> new RootsControl());
        ctrls.computeIfAbsent("system-exit", k -> (call, router) -> {
            if (call.isRequest()) {
                this.forceTermination();
                router.route((Packet)call.reply());
            }
        });
    }

    protected void installExtensions() {
        for (Root ext : this.exts) {
            List<Class<? extends Service>> services = this.extractServices(ext);
            String extID = "_sys_ext_" + Integer.toHexString(ext.hashCode());
            try {
                LOG.log(Level.CONFIG, "Installing extension {0}", extID);
                this.installRoot(extID, "sysex", ext);
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Failed to install extension\n{0} to /{1}\n{2}", new Object[]{ext.getClass(), extID, ex});
                continue;
            }
            ComponentAddress ad = ComponentAddress.of((String)("/" + extID));
            for (Class<? extends Service> service : services) {
                LOG.log(Level.CONFIG, "Registering service {0}", service);
                this.hubAccess.registerService(service, ad);
            }
        }
    }

    private List<Class<? extends Service>> extractServices(Root root) {
        if (root instanceof RootHub.ServiceProvider) {
            return ((RootHub.ServiceProvider)root).services();
        }
        if (root instanceof Component) {
            ComponentInfo info = ((Component)root).getInfo();
            return info.protocols().filter(Service.class::isAssignableFrom).map(c -> c.asSubclass(Service.class)).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }

    protected void installRoot(String id, String type, Root root) throws Exception {
        if (!ComponentAddress.isValidID((String)id) || this.hubAccess.getRootController(id) != null) {
            throw new IllegalArgumentException();
        }
        Root.Controller ctrl = root.initialize(id, this.hubAccess.getRootHub());
        if (this.hubAccess.registerRootController(id, ctrl)) {
            this.startRoot(id, type, ctrl);
        } else assert (false);
    }

    protected void uninstallRoot(String id) {
        Root.Controller ctrl = this.hubAccess.unregisterRootController(id);
        if (ctrl != null) {
            ctrl.shutdown();
        }
    }

    protected void startRoot(String id, String type, Root.Controller ctrl) {
        ctrl.start(r -> new Thread(r, id));
    }

    protected Hub.Accessor getHubAccessor() {
        return this.hubAccess;
    }

    public static Hub.CoreRootFactory factory() {
        return new Factory();
    }

    private static class Factory
    extends Hub.CoreRootFactory {
        private Factory() {
        }

        @Override
        public Root createCoreRoot(Hub.Accessor accessor, List<Root> extensions) {
            return new BasicCoreRoot(accessor, extensions);
        }
    }

    private class RootsControl
    implements Control {
        private String[] knownIDs = new String[0];
        private PArray ret = PArray.EMPTY;

        private RootsControl() {
        }

        public void call(Call call, PacketRouter router) throws Exception {
            if (call.isRequest()) {
                Object[] ids = BasicCoreRoot.this.hubAccess.getRootIDs();
                if (!Arrays.equals(ids, this.knownIDs)) {
                    this.knownIDs = ids;
                    this.ret = (PArray)Stream.of(ids).map(PString::of).collect(PArray.collector());
                }
            } else {
                throw new IllegalArgumentException();
            }
            router.route((Packet)call.reply((Value)this.ret));
        }
    }

    private class RemoveRootControl
    implements Control {
        private RemoveRootControl() {
        }

        public void call(Call call, PacketRouter router) throws Exception {
            if (!call.isRequest()) {
                throw new IllegalArgumentException();
            }
            String id = ((Value)call.args().get(0)).toString();
            BasicCoreRoot.this.uninstallRoot(id);
            router.route((Packet)call.reply());
        }
    }

    private class AddRootControl
    extends AbstractAsyncControl {
        private AddRootControl() {
        }

        protected Call processInvoke(Call call) throws Exception {
            List args = call.args();
            if (args.size() < 2) {
                throw new IllegalArgumentException("Invalid arguments");
            }
            if (!ComponentAddress.isValidID((String)((Value)args.get(0)).toString())) {
                throw new IllegalArgumentException("Invalid Component ID");
            }
            ControlAddress to = ControlAddress.of((ComponentAddress)BasicCoreRoot.this.findService(RootFactoryService.class), (String)"new-root-instance");
            return Call.create((ControlAddress)to, (ControlAddress)call.to(), (long)call.time(), (Value)((Value)args.get(1)));
        }

        protected Call processResponse(Call call) throws Exception {
            List args = call.args();
            if (args.size() < 1) {
                throw new IllegalArgumentException("Invalid response");
            }
            Root r = (Root)PReference.from((Value)((Value)args.get(0))).flatMap(ref -> ref.as(Root.class)).orElseThrow();
            Call active = this.getActiveCall();
            String id = ((Value)active.args().get(0)).toString();
            String type = ((Value)active.args().get(1)).toString();
            BasicCoreRoot.this.installRoot(id, type, r);
            return active.reply();
        }
    }
}

