/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.hub;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.praxislive.base.AbstractAsyncControl;
import org.praxislive.base.AbstractRoot;
import org.praxislive.core.Call;
import org.praxislive.core.Component;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ComponentType;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.Root;
import org.praxislive.core.RootHub;
import org.praxislive.core.Value;
import org.praxislive.core.services.ComponentFactory;
import org.praxislive.core.services.ComponentFactoryService;
import org.praxislive.core.services.RootFactoryService;
import org.praxislive.core.services.Service;
import org.praxislive.core.services.Services;
import org.praxislive.core.types.PError;
import org.praxislive.core.types.PReference;
import org.praxislive.hub.ComponentRegistry;

class DefaultComponentFactoryService
extends AbstractRoot
implements RootHub.ServiceProvider {
    private final ComponentRegistry registry = ComponentRegistry.getInstance();
    private final NewInstanceControl newInstance = new NewInstanceControl();
    private final NewRootInstanceControl newRoot = new NewRootInstanceControl();

    public List<Class<? extends Service>> services() {
        return Stream.of(ComponentFactoryService.class, RootFactoryService.class).collect(Collectors.toList());
    }

    protected void activating() {
        this.setRunning();
    }

    protected void processCall(Call call, PacketRouter router) {
        switch (call.to().controlID()) {
            case "new-instance": {
                try {
                    this.newInstance.call(call, router);
                }
                catch (Exception ex) {
                    router.route((Packet)call.error(PError.of((Exception)ex)));
                }
                break;
            }
            case "new-root-instance": {
                try {
                    this.newRoot.call(call, router);
                }
                catch (Exception ex) {
                    router.route((Packet)call.error(PError.of((Exception)ex)));
                }
                break;
            }
            default: {
                if (!call.isRequest()) break;
                router.route((Packet)call.error(PError.of((String)"Unknown control ID")));
            }
        }
    }

    private class NewRootInstanceControl
    extends AbstractAsyncControl {
        private NewRootInstanceControl() {
        }

        protected Call processInvoke(Call call) throws Exception {
            ComponentType type = (ComponentType)ComponentType.from((Value)((Value)call.args().get(0))).orElseThrow();
            ComponentFactory factory = DefaultComponentFactoryService.this.registry.getRootComponentFactory(type);
            Root root = factory.createRootComponent(type);
            return call.reply((Value)PReference.of((Object)root));
        }

        protected Call processResponse(Call call) throws Exception {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class NewInstanceControl
    extends AbstractAsyncControl {
        private NewInstanceControl() {
        }

        protected Call processInvoke(Call call) throws Exception {
            ComponentType type = (ComponentType)ComponentType.from((Value)((Value)call.args().get(0))).orElseThrow();
            ComponentFactory factory = DefaultComponentFactoryService.this.registry.getComponentFactory(type);
            if (factory.getFactoryService() != ComponentFactoryService.class) {
                ControlAddress altFactory = DefaultComponentFactoryService.this.getLookup().find(Services.class).flatMap(srvs -> srvs.locate(factory.getFactoryService())).map(cmp -> ControlAddress.of((ComponentAddress)cmp, (String)"new-instance")).orElseThrow(() -> new IllegalStateException("Alternative factory service not found"));
                return Call.create((ControlAddress)altFactory, (ControlAddress)call.to(), (long)call.time(), (List)call.args());
            }
            Component component = factory.createComponent(type);
            return call.reply((Value)PReference.of((Object)component));
        }

        protected Call processResponse(Call call) throws Exception {
            return this.getActiveCall().reply(call.args());
        }
    }
}

