/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.hub;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.praxislive.base.AbstractRoot;
import org.praxislive.core.Call;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.RootHub;
import org.praxislive.core.Value;
import org.praxislive.core.services.Service;
import org.praxislive.core.services.TaskService;
import org.praxislive.core.types.PError;
import org.praxislive.core.types.PReference;

class DefaultTaskService
extends AbstractRoot
implements RootHub.ServiceProvider {
    private static final Logger LOG = Logger.getLogger(DefaultTaskService.class.getName());
    private final ExecutorService threadService = Executors.newCachedThreadPool(r -> {
        Thread thr = new Thread(r);
        thr.setPriority(1);
        return thr;
    });
    private final Map<Future<Value>, Call> futures = new HashMap<Future<Value>, Call>();
    private final List<Future> completed = new ArrayList<Future>();

    protected void activating() {
        this.setRunning();
    }

    protected void processCall(Call call, PacketRouter router) {
        if (call.isRequest()) {
            try {
                this.submitTask(call);
            }
            catch (Exception ex) {
                router.route((Packet)call.error(PError.of((Exception)ex)));
            }
        }
    }

    public List<Class<? extends Service>> services() {
        return Collections.singletonList(TaskService.class);
    }

    protected void update() {
        for (Future<Value> future : this.futures.keySet()) {
            Call call;
            if (!future.isDone()) continue;
            try {
                Value value = future.get();
                call = this.futures.get(future);
                call = call.reply(value);
                this.getRouter().route((Packet)call);
                this.completed.add(future);
            }
            catch (Exception ex) {
                Throwable t;
                LOG.log(Level.FINEST, null, ex);
                if (ex instanceof ExecutionException && (t = ex.getCause()) instanceof Exception) {
                    ex = (Exception)t;
                }
                call = this.futures.get(future);
                call = call.error(PError.of((Exception)ex));
                this.getRouter().route((Packet)call);
                this.completed.add(future);
            }
        }
        while (!this.completed.isEmpty()) {
            this.futures.remove(this.completed.get(0));
            this.completed.remove(0);
        }
    }

    protected void terminating() {
        this.threadService.shutdownNow();
    }

    private void submitTask(Call call) throws Exception {
        List args = call.args();
        if (args.size() == 1) {
            Value arg = (Value)args.get(0);
            if (arg instanceof PReference) {
                ((PReference)arg).as(TaskService.Task.class).ifPresent(task -> {
                    Future<Value> future = this.threadService.submit(() -> ((TaskService.Task)task).execute());
                    this.futures.put(future, call);
                });
            }
        } else {
            throw new IllegalArgumentException();
        }
    }
}

