/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.hub;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.praxislive.core.ComponentRegistry;
import org.praxislive.core.ComponentType;
import org.praxislive.core.Lookup;
import org.praxislive.core.services.ComponentFactory;
import org.praxislive.core.services.ComponentFactoryProvider;

class ComponentRegistry {
    private static final System.Logger LOG = System.getLogger(ComponentRegistry.class.getName());
    private final Map<ComponentType, ComponentFactory> componentCache;
    private final Map<ComponentType, ComponentFactory> rootCache;

    private ComponentRegistry(Map<ComponentType, ComponentFactory> componentCache, Map<ComponentType, ComponentFactory> rootCache) {
        this.componentCache = componentCache;
        this.rootCache = rootCache;
    }

    ComponentType[] getComponentTypes() {
        Set<ComponentType> keys = this.componentCache.keySet();
        return keys.toArray(new ComponentType[keys.size()]);
    }

    ComponentType[] getRootComponentTypes() {
        Set<ComponentType> keys = this.rootCache.keySet();
        return keys.toArray(new ComponentType[keys.size()]);
    }

    ComponentFactory getComponentFactory(ComponentType type) {
        return this.componentCache.get(type);
    }

    ComponentFactory getRootComponentFactory(ComponentType type) {
        return this.rootCache.get(type);
    }

    ComponentRegistry.Result createRegistryResult() {
        Map components = this.componentCache.entrySet().stream().collect(Collectors.toMap(e -> (ComponentType)e.getKey(), e -> Lookup.of((Lookup)((ComponentFactory)e.getValue()).componentData((ComponentType)e.getKey()), (Object[])new Object[]{e.getValue()}), (v1, v2) -> v2, LinkedHashMap::new));
        Map roots = this.rootCache.entrySet().stream().collect(Collectors.toMap(e -> (ComponentType)e.getKey(), e -> Lookup.of((Lookup)((ComponentFactory)e.getValue()).rootData((ComponentType)e.getKey()), (Object[])new Object[]{e.getValue()}), (v1, v2) -> v2, LinkedHashMap::new));
        return new ComponentRegistry.Result(components, roots);
    }

    static ComponentRegistry getInstance() {
        LinkedHashMap<ComponentType, ComponentFactory> componentCache = new LinkedHashMap<ComponentType, ComponentFactory>();
        LinkedHashMap<ComponentType, ComponentFactory> rootCache = new LinkedHashMap<ComponentType, ComponentFactory>();
        Lookup.SYSTEM.findAll(ComponentFactoryProvider.class).map(ComponentFactoryProvider::getFactory).forEachOrdered(factory -> {
            LOG.log(System.Logger.Level.DEBUG, "Adding components from : {0}", factory.getClass());
            factory.componentTypes().forEachOrdered(type -> {
                LOG.log(System.Logger.Level.DEBUG, "Adding component type : {0}", type);
                componentCache.put((ComponentType)type, (ComponentFactory)factory);
            });
            factory.rootTypes().forEachOrdered(type -> {
                LOG.log(System.Logger.Level.DEBUG, "Adding root type : {0}", type);
                rootCache.put((ComponentType)type, (ComponentFactory)factory);
            });
        });
        return new ComponentRegistry(componentCache, rootCache);
    }
}

