/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.hub;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.praxislive.core.Clock;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ComponentRegistry;
import org.praxislive.core.Lookup;
import org.praxislive.core.Packet;
import org.praxislive.core.Root;
import org.praxislive.core.RootHub;
import org.praxislive.core.services.Service;
import org.praxislive.core.services.Services;
import org.praxislive.hub.BasicCoreRoot;
import org.praxislive.hub.ComponentRegistry;
import org.praxislive.hub.DefaultComponentFactoryService;
import org.praxislive.hub.DefaultTaskService;
import org.praxislive.script.DefaultScriptService;

public final class Hub {
    public static final String SYS_PREFIX = "_sys_";
    public static final String CORE_PREFIX = "_sys_core_";
    public static final String EXT_PREFIX = "_sys_ext_";
    private final ConcurrentMap<String, Root.Controller> roots;
    private final ConcurrentMap<Class<? extends Service>, List<ComponentAddress>> services;
    private final Root core;
    private final Lookup lookup;
    private final RootHubImpl rootHub;
    private final List<String> rootIDs;
    private Root.Controller coreController;
    long startTime;

    private Hub(Builder builder) {
        CoreRootFactory coreFactory = builder.coreRootFactory;
        ArrayList<Root> exts = new ArrayList<Root>();
        this.extractExtensions(builder, exts);
        this.core = coreFactory.createCoreRoot(new Accessor(), exts);
        ArrayList<Object> lookupContent = new ArrayList<Object>();
        lookupContent.add(new ServicesImpl());
        lookupContent.add(new ComponentRegistryImpl(this));
        lookupContent.addAll(builder.lookupContent);
        Lookup lkp = Lookup.of((Object[])lookupContent.toArray());
        this.lookup = lkp = coreFactory.extendLookup(lkp);
        this.roots = new ConcurrentHashMap<String, Root.Controller>();
        this.services = new ConcurrentHashMap<Class<? extends Service>, List<ComponentAddress>>();
        this.rootHub = new RootHubImpl();
        this.rootIDs = new CopyOnWriteArrayList<String>();
    }

    private void extractExtensions(Builder builder, List<Root> exts) {
        exts.add((Root)new DefaultComponentFactoryService());
        exts.add((Root)new DefaultScriptService());
        exts.add((Root)new DefaultTaskService());
        exts.addAll(builder.extensions);
    }

    public synchronized void start() throws Exception {
        if (this.coreController != null) {
            throw new IllegalStateException();
        }
        this.startTime = System.nanoTime();
        String coreID = CORE_PREFIX + Integer.toHexString(this.core.hashCode());
        this.coreController = this.core.initialize(coreID, (RootHub)this.rootHub);
        this.roots.put(coreID, this.coreController);
        this.coreController.start(Lookup.EMPTY);
    }

    public void shutdown() {
        this.coreController.shutdown();
    }

    public void await() throws InterruptedException {
        while (true) {
            try {
                this.await(1L, TimeUnit.MINUTES);
                return;
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            break;
        }
    }

    public void await(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
        try {
            this.coreController.awaitTermination(time, unit);
        }
        catch (ExecutionException ex) {
            return;
        }
    }

    public boolean isAlive() {
        return this.coreController.isAlive();
    }

    public int exitValue() {
        if (this.core instanceof BasicCoreRoot) {
            return ((BasicCoreRoot)this.core).exitValue();
        }
        return 0;
    }

    private boolean registerRootController(String id, Root.Controller controller) {
        if (id == null || controller == null) {
            throw new NullPointerException();
        }
        Root.Controller existing = this.roots.putIfAbsent(id, controller);
        if (existing == null) {
            this.rootIDs.add(id);
            return true;
        }
        return false;
    }

    private Root.Controller unregisterRootController(String id) {
        this.rootIDs.remove(id);
        return (Root.Controller)this.roots.remove(id);
    }

    private Root.Controller getRootController(String id) {
        return (Root.Controller)this.roots.get(id);
    }

    private String[] getRootIDs() {
        return (String[])this.rootIDs.toArray(String[]::new);
    }

    private RootHub getRootHub() {
        return this.rootHub;
    }

    private void registerService(Class<? extends Service> service, ComponentAddress provider) {
        Objects.requireNonNull(service);
        Objects.requireNonNull(provider);
        this.services.merge(service, List.of(provider), (existingValues, newValue) -> {
            ArrayList list = new ArrayList(newValue);
            list.addAll(existingValues);
            return list;
        });
    }

    private Set<Class<? extends Service>> getServices() {
        return Collections.unmodifiableSet(this.services.keySet());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<Root> extensions = new ArrayList<Root>();
        private final List<Object> lookupContent = new ArrayList<Object>();
        private CoreRootFactory coreRootFactory = BasicCoreRoot.factory();

        private Builder() {
            this.extensions.addAll(this.findDefaultExtensions());
        }

        private List<Root> findDefaultExtensions() {
            return Lookup.SYSTEM.findAll(RootHub.ExtensionProvider.class).flatMap(ep -> ep.getExtensions().stream()).collect(Collectors.toList());
        }

        public Builder setCoreRootFactory(CoreRootFactory coreRootFactory) {
            this.coreRootFactory = Objects.requireNonNull(coreRootFactory);
            return this;
        }

        public Builder addExtension(Root extension) {
            this.extensions.add(Objects.requireNonNull(extension));
            return this;
        }

        public Builder extendLookup(Object obj) {
            this.lookupContent.add(Objects.requireNonNull(obj));
            return this;
        }

        public Hub build() {
            Hub hub = new Hub(this);
            return hub;
        }
    }

    public static interface CoreRootFactory {
        public Root createCoreRoot(Accessor var1, List<Root> var2);

        default public Lookup extendLookup(Lookup lookup) {
            return lookup;
        }
    }

    public final class Accessor {
        private Accessor() {
        }

        public boolean registerRootController(String id, Root.Controller controller) {
            return Hub.this.registerRootController(id, controller);
        }

        public Root.Controller unregisterRootController(String id) {
            return Hub.this.unregisterRootController(id);
        }

        public Root.Controller getRootController(String id) {
            return Hub.this.getRootController(id);
        }

        public String[] getRootIDs() {
            return Hub.this.getRootIDs();
        }

        public void registerService(Class<? extends Service> service, ComponentAddress provider) {
            Hub.this.registerService(service, provider);
        }

        public RootHub getRootHub() {
            return Hub.this.getRootHub();
        }
    }

    private class ServicesImpl
    implements Services {
        private ServicesImpl() {
        }

        public Optional<ComponentAddress> locate(Class<? extends Service> service) {
            List list = (List)Hub.this.services.get(service);
            if (list == null || list.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of((ComponentAddress)list.get(0));
        }

        public Stream<ComponentAddress> locateAll(Class<? extends Service> service) {
            return Hub.this.services.getOrDefault(service, List.of()).stream();
        }
    }

    private class ComponentRegistryImpl
    implements org.praxislive.core.ComponentRegistry {
        private final ComponentRegistry.Result result = ComponentRegistry.getInstance().createRegistryResult();

        private ComponentRegistryImpl(Hub hub) {
        }

        public ComponentRegistry.Result query() {
            return this.result;
        }
    }

    private class RootHubImpl
    implements RootHub,
    Clock {
        private RootHubImpl() {
        }

        public boolean dispatch(Packet packet) {
            Root.Controller dest = (Root.Controller)Hub.this.roots.get(packet.rootID());
            try {
                if (dest != null) {
                    return dest.submitPacket(packet);
                }
                return Hub.this.coreController.submitPacket(packet);
            }
            catch (Exception e) {
                return false;
            }
        }

        public Lookup getLookup() {
            return Hub.this.lookup;
        }

        public Clock getClock() {
            return this;
        }

        public long getTime() {
            return System.nanoTime() - Hub.this.startTime;
        }
    }
}

