/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.hub;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.praxislive.base.AbstractAsyncControl;
import org.praxislive.base.AbstractRoot;
import org.praxislive.core.Call;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.Control;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.Root;
import org.praxislive.core.RootHub;
import org.praxislive.core.Value;
import org.praxislive.core.services.RootFactoryService;
import org.praxislive.core.services.RootManagerService;
import org.praxislive.core.services.Service;
import org.praxislive.core.services.SystemManagerService;
import org.praxislive.core.types.PArray;
import org.praxislive.core.types.PError;
import org.praxislive.core.types.PNumber;
import org.praxislive.core.types.PReference;
import org.praxislive.core.types.PString;
import org.praxislive.hub.Hub;

public class BasicCoreRoot
extends AbstractRoot {
    private static final System.Logger LOG = System.getLogger(BasicCoreRoot.class.getName());
    private final Hub.Accessor hubAccess;
    private final List<Root> exts;
    private final Map<String, Control> controls;
    private AbstractRoot.Controller controller;
    private int exitValue;

    protected BasicCoreRoot(Hub.Accessor hubAccess, List<Root> exts) {
        this.hubAccess = Objects.requireNonNull(hubAccess);
        this.exts = Objects.requireNonNull(exts);
        this.controls = new HashMap<String, Control>();
        this.exitValue = 0;
    }

    public final AbstractRoot.Controller initialize(String id, RootHub hub) {
        AbstractRoot.Controller ctrl;
        this.controller = ctrl = super.initialize(id, hub);
        return ctrl;
    }

    protected final void activating() {
        HashMap<Class<? extends Service>, ComponentAddress> services = new HashMap<Class<? extends Service>, ComponentAddress>();
        this.buildServiceMap(services);
        services.forEach(this.hubAccess::registerService);
        HashMap<String, Control> ctrls = new HashMap<String, Control>();
        this.buildControlMap(ctrls);
        this.controls.putAll(ctrls);
        Map<String, Root.Controller> extCtrls = this.installExtensions();
        this.setRunning();
        extCtrls.forEach(this::startRoot);
    }

    protected void terminating() {
        String[] ids;
        for (String id : ids = this.hubAccess.getRootIDs()) {
            this.uninstallRoot(id);
        }
    }

    protected final void forceTermination() {
        this.controller.shutdown();
        this.interrupt();
    }

    protected int exitValue() {
        return this.exitValue;
    }

    protected void processCall(Call call, PacketRouter router) {
        block5: {
            Control control = this.controls.get(call.to().controlID());
            try {
                if (control != null) {
                    control.call(call, router);
                } else if (call.isRequest()) {
                    router.route((Packet)call.error(PError.of((String)("Unknown control address : " + String.valueOf(call.to())))));
                }
            }
            catch (Exception ex) {
                if (!call.isRequest()) break block5;
                router.route((Packet)call.error(PError.of((Exception)ex)));
            }
        }
    }

    protected void buildServiceMap(Map<Class<? extends Service>, ComponentAddress> srvs) {
        srvs.putIfAbsent(RootManagerService.class, this.getAddress());
        srvs.putIfAbsent(SystemManagerService.class, this.getAddress());
    }

    protected void buildControlMap(Map<String, Control> ctrls) {
        ctrls.computeIfAbsent("add-root", k -> new AddRootControl());
        ctrls.computeIfAbsent("remove-root", k -> new RemoveRootControl());
        ctrls.computeIfAbsent("roots", k -> new RootsControl());
        ctrls.computeIfAbsent("system-exit", k -> (call, router) -> {
            if (call.isRequest()) {
                if (!call.args().isEmpty()) {
                    this.exitValue = PNumber.from((Value)((Value)call.args().get(0))).orElse(PNumber.ZERO).toIntValue();
                }
                this.forceTermination();
                router.route((Packet)call.reply());
            }
        });
    }

    protected final Root.Controller installRoot(String id, Root root) throws Exception {
        if (!ComponentAddress.isValidID((String)id) || this.hubAccess.getRootController(id) != null) {
            throw new IllegalArgumentException();
        }
        Root.Controller ctrl = root.initialize(id, this.hubAccess.getRootHub());
        if (this.hubAccess.registerRootController(id, ctrl)) {
            return ctrl;
        }
        throw new IllegalStateException();
    }

    protected final Root.Controller uninstallRoot(String id) {
        Root.Controller ctrl = this.hubAccess.unregisterRootController(id);
        if (ctrl != null) {
            ctrl.shutdown();
            return ctrl;
        }
        return null;
    }

    protected final void startRoot(String id, Root.Controller ctrl) {
        ctrl.start();
    }

    protected final Hub.Accessor getHubAccessor() {
        return this.hubAccess;
    }

    private Map<String, Root.Controller> installExtensions() {
        if (this.exts.isEmpty()) {
            return Map.of();
        }
        LinkedHashMap<String, Root.Controller> ctrls = new LinkedHashMap<String, Root.Controller>();
        for (Root ext : this.exts) {
            List<Class<? extends Service>> services = this.extractServices(ext);
            String extID = "_sys_ext_" + Integer.toHexString(ext.hashCode());
            try {
                LOG.log(System.Logger.Level.DEBUG, "Installing extension {0}", extID);
                Root.Controller ctrl = this.installRoot(extID, ext);
                ctrls.put(extID, ctrl);
            }
            catch (Exception ex) {
                LOG.log(System.Logger.Level.ERROR, "Failed to install extension\n{0} to /{1}\n{2}", ext.getClass(), extID, ex);
                continue;
            }
            ComponentAddress ad = ComponentAddress.of((String)("/" + extID));
            for (Class<? extends Service> service : services) {
                LOG.log(System.Logger.Level.DEBUG, "Registering service {0}", service);
                this.hubAccess.registerService(service, ad);
            }
        }
        return ctrls;
    }

    private List<Class<? extends Service>> extractServices(Root root) {
        if (root instanceof RootHub.ServiceProvider) {
            RootHub.ServiceProvider serviceProvider = (RootHub.ServiceProvider)root;
            return serviceProvider.services();
        }
        return List.of();
    }

    public static Hub.CoreRootFactory factory() {
        return new Factory();
    }

    private static class Factory
    implements Hub.CoreRootFactory {
        private Factory() {
        }

        @Override
        public Root createCoreRoot(Hub.Accessor accessor, List<Root> extensions) {
            return new BasicCoreRoot(accessor, extensions);
        }
    }

    private class RootsControl
    implements Control {
        private String[] knownIDs = new String[0];
        private PArray ret = PArray.EMPTY;

        private RootsControl() {
        }

        public void call(Call call, PacketRouter router) throws Exception {
            if (call.isRequest()) {
                Object[] ids = BasicCoreRoot.this.hubAccess.getRootIDs();
                if (!Arrays.equals(ids, this.knownIDs)) {
                    this.knownIDs = ids;
                    this.ret = (PArray)Stream.of(ids).map(PString::of).collect(PArray.collector());
                }
            } else {
                throw new IllegalArgumentException();
            }
            router.route((Packet)call.reply((Value)this.ret));
        }
    }

    private class RemoveRootControl
    implements Control {
        private RemoveRootControl() {
        }

        public void call(Call call, PacketRouter router) throws Exception {
            if (!call.isRequest()) {
                throw new IllegalArgumentException();
            }
            String id = ((Value)call.args().get(0)).toString();
            BasicCoreRoot.this.uninstallRoot(id);
            router.route((Packet)call.reply());
        }
    }

    private class AddRootControl
    extends AbstractAsyncControl {
        private AddRootControl() {
        }

        protected Call processInvoke(Call call) throws Exception {
            List args = call.args();
            if (args.size() < 2) {
                throw new IllegalArgumentException("Invalid arguments");
            }
            if (!ComponentAddress.isValidID((String)((Value)args.get(0)).toString())) {
                throw new IllegalArgumentException("Invalid Component ID");
            }
            ControlAddress to = ControlAddress.of((ComponentAddress)BasicCoreRoot.this.findService(RootFactoryService.class), (String)"new-root-instance");
            return Call.create((ControlAddress)to, (ControlAddress)call.to(), (long)call.time(), (Value)((Value)args.get(1)));
        }

        protected Call processResponse(Call call) throws Exception {
            List args = call.args();
            if (args.size() < 1) {
                throw new IllegalArgumentException("Invalid response");
            }
            Root r = (Root)PReference.from((Value)((Value)args.get(0))).flatMap(ref -> ref.as(Root.class)).orElseThrow();
            Call active = this.getActiveCall();
            String id = ((Value)active.args().get(0)).toString();
            BasicCoreRoot.this.startRoot(id, BasicCoreRoot.this.installRoot(id, r));
            return active.reply();
        }
    }
}

