/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.internal.osc;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.praxislive.internal.osc.NetUtil;
import org.praxislive.internal.osc.OSCBidi;
import org.praxislive.internal.osc.OSCException;
import org.praxislive.internal.osc.OSCListener;
import org.praxislive.internal.osc.OSCMessage;
import org.praxislive.internal.osc.OSCPacket;
import org.praxislive.internal.osc.OSCPacketCodec;
import org.praxislive.internal.osc.OSCReceiver;
import org.praxislive.internal.osc.OSCTransmitter;

public abstract class OSCServer
implements OSCBidi {
    protected OSCPacketCodec defaultCodec;
    private final String protocol;

    protected OSCServer(OSCPacketCodec c, String protocol) {
        this.defaultCodec = c;
        this.protocol = protocol;
    }

    public static OSCServer newUsing(String protocol) throws IOException {
        return OSCServer.newUsing(OSCPacketCodec.getDefaultCodec(), protocol);
    }

    public static OSCServer newUsing(OSCPacketCodec c, String protocol) throws IOException {
        return OSCServer.newUsing(c, protocol, 0);
    }

    public static OSCServer newUsing(String protocol, int port) throws IOException {
        return OSCServer.newUsing(OSCPacketCodec.getDefaultCodec(), protocol, port);
    }

    public static OSCServer newUsing(OSCPacketCodec c, String protocol, int port) throws IOException {
        return OSCServer.newUsing(c, protocol, port, false);
    }

    public static OSCServer newUsing(String protocol, int port, boolean loopBack) throws IOException {
        return OSCServer.newUsing(OSCPacketCodec.getDefaultCodec(), protocol, port, loopBack);
    }

    public static OSCServer newUsing(OSCPacketCodec c, String protocol, int port, boolean loopBack) throws IOException {
        InetSocketAddress localAddress = new InetSocketAddress(loopBack ? "127.0.0.1" : "0.0.0.0", port);
        return OSCServer.newUsing(c, protocol, localAddress);
    }

    public static OSCServer newUsing(String protocol, InetSocketAddress localAddress) throws IOException {
        return OSCServer.newUsing(OSCPacketCodec.getDefaultCodec(), protocol, localAddress);
    }

    public static OSCServer newUsing(OSCPacketCodec c, String protocol, InetSocketAddress localAddress) throws IOException {
        if (protocol.equals("udp")) {
            return new UDPOSCServer(c, localAddress);
        }
        if (protocol.equals("tcp")) {
            return new TCPOSCServer(c, localAddress);
        }
        throw new IllegalArgumentException(NetUtil.getResourceString("errUnknownProtocol") + protocol);
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public abstract InetSocketAddress getLocalAddress() throws IOException;

    public abstract void send(OSCPacket var1, SocketAddress var2) throws IOException;

    public abstract void addOSCListener(OSCListener var1);

    public abstract void removeOSCListener(OSCListener var1);

    @Override
    public abstract void start() throws IOException;

    @Override
    public abstract boolean isActive();

    @Override
    public abstract void stop() throws IOException;

    @Override
    public abstract void setBufferSize(int var1);

    @Override
    public abstract int getBufferSize();

    @Override
    public void setCodec(OSCPacketCodec c) {
        this.defaultCodec = c;
    }

    @Override
    public OSCPacketCodec getCodec() {
        return this.defaultCodec;
    }

    public abstract void setCodec(OSCPacketCodec var1, SocketAddress var2) throws IOException;

    public abstract OSCPacketCodec getCodec(SocketAddress var1) throws IOException;

    @Override
    public final void dumpOSC(int mode, PrintStream stream) {
        this.dumpIncomingOSC(mode, stream);
        this.dumpOutgoingOSC(mode, stream);
    }

    @Override
    public abstract void dumpIncomingOSC(int var1, PrintStream var2);

    @Override
    public abstract void dumpOutgoingOSC(int var1, PrintStream var2);

    @Override
    public abstract void dispose();

    protected InetSocketAddress getLocalAddress(InetAddress addr, int port) throws UnknownHostException {
        return new InetSocketAddress(addr.getHostName().equals("0.0.0.0") ? InetAddress.getLocalHost() : addr, port);
    }

    private static class TCPOSCServer
    extends OSCServer
    implements Runnable,
    OSCListener {
        private final Map mapRcv = new HashMap();
        private final Map mapTrns = new HashMap();
        private final List collListeners = new ArrayList();
        private Thread thread = null;
        private final Object startStopSync = new Object();
        private final Object threadSync = new Object();
        private final Object connSync = new Object();
        private boolean isListening = false;
        private int bufSize = 8192;
        private int inMode = 0;
        private int outMode = 0;
        private PrintStream inStream = null;
        private PrintStream outStream = null;
        private final ServerSocketChannel ssch = ServerSocketChannel.open();

        protected TCPOSCServer(OSCPacketCodec c, InetSocketAddress localAddress) throws IOException {
            super(c, "tcp");
            this.ssch.socket().bind(localAddress);
        }

        @Override
        public InetSocketAddress getLocalAddress() throws IOException {
            ServerSocket ss = this.ssch.socket();
            return this.getLocalAddress(ss.getInetAddress(), ss.getLocalPort());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addOSCListener(OSCListener listener) {
            List list = this.collListeners;
            synchronized (list) {
                this.collListeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeOSCListener(OSCListener listener) {
            List list = this.collListeners;
            synchronized (list) {
                this.collListeners.remove(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCodec(OSCPacketCodec c) {
            Object object = this.connSync;
            synchronized (object) {
                for (OSCTransmitter trns : this.mapTrns.values()) {
                    if (trns.getCodec() != this.defaultCodec) continue;
                    trns.setCodec(c);
                }
            }
            super.setCodec(c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCodec(OSCPacketCodec c, SocketAddress target) throws IOException {
            OSCTransmitter trns;
            Object object = this.connSync;
            synchronized (object) {
                trns = (OSCTransmitter)this.mapTrns.get(target);
            }
            if (trns == null) {
                throw new NotYetConnectedException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OSCPacketCodec getCodec(SocketAddress target) throws IOException {
            OSCTransmitter trns;
            Object object = this.connSync;
            synchronized (object) {
                trns = (OSCTransmitter)this.mapTrns.get(target);
            }
            if (trns == null) {
                throw new NotYetConnectedException();
            }
            return trns.getCodec();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void start() throws IOException {
            Object object = this.startStopSync;
            synchronized (object) {
                if (Thread.currentThread() == this.thread) {
                    throw new IllegalStateException("Cannot call startListening() in the server body thread");
                }
                if (this.isListening && (this.thread == null || !this.thread.isAlive())) {
                    this.isListening = false;
                }
                if (!this.isListening) {
                    this.isListening = true;
                    this.thread = new Thread((Runnable)this, "TCPServerBody");
                    this.thread.setDaemon(true);
                    this.thread.start();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() throws IOException {
            Object object = this.startStopSync;
            synchronized (object) {
                if (Thread.currentThread() == this.thread) {
                    throw new IllegalStateException("Cannot call stopListening() in the server body thread");
                }
                if (this.isListening) {
                    this.isListening = false;
                    if (this.thread != null && this.thread.isAlive()) {
                        try {
                            Object object2 = this.threadSync;
                            synchronized (object2) {
                                SocketChannel guard = SocketChannel.open();
                                guard.connect(this.ssch.socket().getLocalSocketAddress());
                                guard.close();
                                this.threadSync.wait(5000L);
                            }
                        }
                        catch (InterruptedException e2) {
                            System.err.println(e2.getLocalizedMessage());
                        }
                        catch (IOException e1) {
                            System.err.println("TCPServerBody.stopListening : " + e1);
                            throw e1;
                        }
                        finally {
                            if (this.thread != null && this.thread.isAlive()) {
                                try {
                                    System.err.println("TCPServerBody.stopListening : rude task killing (" + this.hashCode() + ")");
                                    this.ssch.close();
                                }
                                catch (IOException e3) {
                                    System.err.println("TCPServerBody.stopListening 2: " + e3);
                                }
                            }
                            this.thread = null;
                            this.stopAll();
                        }
                    }
                }
            }
        }

        @Override
        public boolean isActive() {
            return this.isListening;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(OSCPacket p, SocketAddress target) throws IOException {
            OSCTransmitter trns;
            Object object = this.connSync;
            synchronized (object) {
                trns = (OSCTransmitter)this.mapTrns.get(target);
            }
            if (trns == null) {
                throw new NotYetConnectedException();
            }
            trns.send(p);
        }

        @Override
        public void dispose() {
            try {
                this.stop();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.ssch.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopAll() {
            Object object = this.connSync;
            synchronized (object) {
                Iterator iter = this.mapRcv.values().iterator();
                while (iter.hasNext()) {
                    ((OSCReceiver)iter.next()).dispose();
                }
                this.mapRcv.clear();
                iter = this.mapTrns.values().iterator();
                while (iter.hasNext()) {
                    ((OSCTransmitter)iter.next()).dispose();
                }
                this.mapTrns.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setBufferSize(int size) {
            Object object = this.connSync;
            synchronized (object) {
                this.bufSize = size;
                Iterator iter = this.mapRcv.values().iterator();
                while (iter.hasNext()) {
                    ((OSCReceiver)iter.next()).setBufferSize(size);
                }
                iter = this.mapTrns.values().iterator();
                while (iter.hasNext()) {
                    ((OSCTransmitter)iter.next()).setBufferSize(size);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getBufferSize() {
            Object object = this.connSync;
            synchronized (object) {
                return this.bufSize;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dumpIncomingOSC(int mode, PrintStream stream) {
            Object object = this.connSync;
            synchronized (object) {
                this.inMode = mode;
                this.inStream = stream;
                Iterator iter = this.mapRcv.values().iterator();
                while (iter.hasNext()) {
                    ((OSCReceiver)iter.next()).dumpOSC(mode, stream);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dumpOutgoingOSC(int mode, PrintStream stream) {
            Object object = this.connSync;
            synchronized (object) {
                this.outMode = mode;
                this.outStream = stream;
                Iterator iter = this.mapTrns.values().iterator();
                while (iter.hasNext()) {
                    ((OSCTransmitter)iter.next()).dumpOSC(mode, stream);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            Object object;
            block19: while (true) {
                while (this.isListening) {
                    try {
                        SocketChannel sch = this.ssch.accept();
                        if (!this.isListening) {
                            return;
                        }
                        if (sch == null) continue;
                        SocketAddress sender = sch.socket().getRemoteSocketAddress();
                        object = this.connSync;
                        synchronized (object) {
                            OSCReceiver rcv = OSCReceiver.newUsing(this.defaultCodec, sch);
                            rcv.setBufferSize(this.bufSize);
                            this.mapRcv.put(sender, rcv);
                            OSCTransmitter trns = OSCTransmitter.newUsing(this.defaultCodec, sch);
                            trns.setBufferSize(this.bufSize);
                            this.mapTrns.put(sender, trns);
                            rcv.dumpOSC(this.inMode, this.inStream);
                            trns.dumpOSC(this.outMode, this.outStream);
                            rcv.addOSCListener(this);
                            rcv.startListening();
                        }
                    }
                    catch (ClosedChannelException e11) {
                        if (this.isListening) {
                            System.err.println(e11);
                        }
                        Object object2 = this.threadSync;
                        synchronized (object2) {
                            this.thread = null;
                            this.threadSync.notifyAll();
                            return;
                        }
                    }
                    catch (IOException e1) {
                        try {
                            if (!this.isListening) continue block19;
                            System.err.println(new OSCException(6, e1.toString()));
                            continue block19;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                            return;
                        }
                    }
                }
            }
            finally {
                object = this.threadSync;
                synchronized (object) {
                    this.thread = null;
                    this.threadSync.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void messageReceived(OSCMessage msg, SocketAddress sender, long time) {
            List list = this.collListeners;
            synchronized (list) {
                for (int i = 0; i < this.collListeners.size(); ++i) {
                    OSCListener listener = (OSCListener)this.collListeners.get(i);
                    listener.messageReceived(msg, sender, time);
                }
            }
        }
    }

    private static class UDPOSCServer
    extends OSCServer {
        private final OSCReceiver rcv;
        private final OSCTransmitter trns;

        protected UDPOSCServer(OSCPacketCodec c, InetSocketAddress localAddress) throws IOException {
            super(c, "udp");
            this.rcv = OSCReceiver.newUsing(c, "udp", localAddress);
            this.trns = OSCTransmitter.newUsing(c, "udp", localAddress);
        }

        @Override
        public InetSocketAddress getLocalAddress() throws IOException {
            return this.rcv.getLocalAddress();
        }

        @Override
        public void addOSCListener(OSCListener listener) {
            this.rcv.addOSCListener(listener);
        }

        @Override
        public void removeOSCListener(OSCListener listener) {
            this.rcv.removeOSCListener(listener);
        }

        @Override
        public void setCodec(OSCPacketCodec c) {
            this.rcv.setCodec(c);
            this.trns.setCodec(c);
            super.setCodec(c);
        }

        @Override
        public void setCodec(OSCPacketCodec c, SocketAddress target) throws IOException {
            throw new IOException("Not supported in UDP mode");
        }

        @Override
        public OSCPacketCodec getCodec(SocketAddress target) throws IOException {
            throw new IOException("Not supported in UDP mode");
        }

        @Override
        public void start() throws IOException {
            if (!this.trns.isConnected()) {
                this.trns.connect();
                this.rcv.setChannel(this.trns.getChannel());
            }
            this.rcv.startListening();
        }

        @Override
        public void stop() throws IOException {
            this.rcv.stopListening();
        }

        @Override
        public boolean isActive() {
            return this.rcv.isListening();
        }

        @Override
        public void send(OSCPacket p, SocketAddress target) throws IOException {
            this.trns.send(p, target);
        }

        @Override
        public void dispose() {
            this.rcv.dispose();
            this.trns.dispose();
        }

        @Override
        public void setBufferSize(int size) {
            this.rcv.setBufferSize(size);
            this.trns.setBufferSize(size);
        }

        @Override
        public int getBufferSize() {
            return this.rcv.getBufferSize();
        }

        @Override
        public void dumpIncomingOSC(int mode, PrintStream stream) {
            this.rcv.dumpOSC(mode, stream);
        }

        @Override
        public void dumpOutgoingOSC(int mode, PrintStream stream) {
            this.trns.dumpOSC(mode, stream);
        }
    }
}

