/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.internal.osc.test;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Random;
import org.praxislive.internal.osc.OSCBundle;
import org.praxislive.internal.osc.OSCClient;
import org.praxislive.internal.osc.OSCListener;
import org.praxislive.internal.osc.OSCMessage;
import org.praxislive.internal.osc.OSCReceiver;
import org.praxislive.internal.osc.OSCServer;
import org.praxislive.internal.osc.OSCTransmitter;

public abstract class NetUtilTest {
    protected static boolean pause = false;
    protected static volatile boolean received;

    private NetUtilTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void client(String protocol) {
        OSCClient c;
        NetUtilTest.postln("NetUtilTest.client( \"" + protocol + "\" )\n");
        NetUtilTest.postln("talking to localhost port 57110");
        final Object sync = new Object();
        try {
            c = OSCClient.newUsing(protocol);
            c.setTarget(new InetSocketAddress(InetAddress.getLocalHost(), 57110));
            NetUtilTest.postln("  start()");
            c.start();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return;
        }
        c.addOSCListener(new OSCListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void messageReceived(OSCMessage m, SocketAddress addr, long time) {
                if (m.getName().equals("/n_end")) {
                    Object object = sync;
                    synchronized (object) {
                        sync.notifyAll();
                    }
                }
            }
        });
        c.dumpOSC(3, System.err);
        try {
            c.send(new OSCMessage("/notify", new Object[]{new Integer(1)}));
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        for (int i = 0; i < 4; ++i) {
            OSCBundle bndl1 = new OSCBundle(System.currentTimeMillis() + 50L);
            OSCBundle bndl2 = new OSCBundle(System.currentTimeMillis() + 1550L);
            Integer nodeID = new Integer(1001 + i);
            bndl1.addPacket(new OSCMessage("/s_new", new Object[]{"default", nodeID, new Integer(1), new Integer(0)}));
            bndl1.addPacket(new OSCMessage("/n_set", new Object[]{nodeID, "freq", new Float(Math.pow(2.0, (float)i / 6.0f) * 441.0)}));
            bndl2.addPacket(new OSCMessage("/n_set", new Object[]{nodeID, "gate", new Float(-3.0f)}));
            try {
                c.send(bndl1);
                c.send(bndl2);
                Object object = sync;
                synchronized (object) {
                    sync.wait();
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        try {
            c.send(new OSCMessage("/notify", new Object[]{new Integer(0)}));
        }
        catch (IOException e3) {
            e3.printStackTrace();
        }
        c.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void server(String protocol) {
        OSCServer c;
        NetUtilTest.postln("NetUtilTest.server( \"" + protocol + "\" )\n");
        NetUtilTest.postln("listening at port 21588. recognized commands: /pause, /quit, /dumpOSC");
        final Object sync = new Object();
        try {
            c = OSCServer.newUsing(protocol, 21588);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return;
        }
        c.addOSCListener(new OSCListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void messageReceived(OSCMessage m, SocketAddress addr, long time) {
                try {
                    NetUtilTest.postln("send " + addr);
                    c.send(new OSCMessage("/done", new Object[]{m.getName()}), addr);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                if (m.getName().equals("/pause")) {
                    pause = true;
                    Object object = sync;
                    synchronized (object) {
                        sync.notifyAll();
                    }
                } else if (m.getName().equals("/quit")) {
                    Object object = sync;
                    synchronized (object) {
                        sync.notifyAll();
                    }
                } else if (m.getName().equals("/dumpOSC")) {
                    c.dumpOSC(((Number)m.getArg(0)).intValue(), System.err);
                }
            }
        });
        try {
            do {
                if (pause) {
                    NetUtilTest.postln("  waiting four seconds...");
                    try {
                        Thread.sleep(4000L);
                    }
                    catch (InterruptedException e1) {
                        // empty catch block
                    }
                    pause = false;
                }
                NetUtilTest.postln("  start()");
                c.start();
                try {
                    Object e1 = sync;
                    synchronized (e1) {
                        sync.wait();
                    }
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                NetUtilTest.postln("  stop()");
                c.stop();
            } while (pause);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        c.dispose();
    }

    public static void codecSpeed() {
        int cnt;
        long t1;
        int k;
        int j;
        ByteBuffer b = ByteBuffer.allocateDirect(65536);
        ArrayList<Object> args = new ArrayList<Object>(1024);
        Object[][] argsArgs = new Object[1024][];
        Random rnd = new Random(19088760L);
        ByteBuffer[] b2 = new ByteBuffer[1024];
        byte[] bytes = new byte[16];
        NetUtilTest.postln("Testing OSCMessage encoding speed...");
        for (int i = 0; i < argsArgs.length; ++i) {
            args.clear();
            block17: for (j = 0; j < i % 1024; ++j) {
                switch (j % 5) {
                    case 0: {
                        args.add(new Integer(rnd.nextInt()));
                        continue block17;
                    }
                    case 1: {
                        args.add(new Float(rnd.nextFloat()));
                        continue block17;
                    }
                    case 2: {
                        args.add(new Long(rnd.nextLong()));
                        continue block17;
                    }
                    case 3: {
                        args.add(new Double(rnd.nextDouble()));
                        continue block17;
                    }
                    case 4: {
                        rnd.nextBytes(bytes);
                        for (k = 0; k < bytes.length; ++k) {
                            bytes[k] = (byte)(Math.max(32, bytes[k]) & 0x7F);
                        }
                        args.add(new String(bytes));
                    }
                }
            }
            argsArgs[i] = args.toArray();
        }
        try {
            t1 = System.currentTimeMillis();
            cnt = 0;
            while (System.currentTimeMillis() - t1 < 5000L) {
                b.clear();
                new OSCMessage("/test", argsArgs[cnt % argsArgs.length]).encode(b);
                ++cnt;
            }
            NetUtilTest.postln(String.valueOf(cnt) + " messages encoded in 5 seconds.");
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        NetUtilTest.postln("Testing OSCMessage decoding speed...");
        try {
            ByteBuffer b3;
            for (int i = 0; i < b2.length; ++i) {
                args.clear();
                block21: for (j = 0; j < i % 1024; ++j) {
                    switch (j % 3) {
                        case 0: {
                            args.add(new Integer(rnd.nextInt()));
                            continue block21;
                        }
                        case 1: {
                            args.add(new Float(rnd.nextFloat()));
                            continue block21;
                        }
                        case 2: {
                            rnd.nextBytes(bytes);
                            for (k = 0; k < bytes.length; ++k) {
                                bytes[k] = (byte)(Math.max(32, bytes[k]) & 0x7F);
                            }
                            args.add(new String(bytes));
                        }
                    }
                }
                OSCMessage msg = new OSCMessage("/test", args.toArray());
                b3 = ByteBuffer.allocateDirect(msg.getSize());
                msg.encode(b3);
                b2[i] = b3;
            }
            t1 = System.currentTimeMillis();
            cnt = 0;
            while (System.currentTimeMillis() - t1 < 5000L) {
                b3 = b2[cnt % b2.length];
                b3.clear();
                b3.position(8);
                OSCMessage.decodeMessage("/test", b3);
                ++cnt;
            }
            NetUtilTest.postln(String.valueOf(cnt) + " messages decoded in 5 seconds.");
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pingPong() {
        Object object;
        InetSocketAddress targetAddr;
        boolean shouldFail;
        int j;
        String proto;
        int i;
        String[] protos = new String[]{"udp", "tcp"};
        String[] words = new String[]{"One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve"};
        final Object sync = new Object();
        int wordIdx = 0;
        int failures = 0;
        System.out.println("\n---------- RECEIVER / TRANSMITTER ----------");
        for (i = 0; i < 1; ++i) {
            proto = protos[i];
            System.out.println("---------- Testing protocol '" + proto + "' ----------");
            for (j = 0; j < 4; ++j) {
                boolean rcvLoop = j / 2 == 0;
                boolean trnsLoop = j % 2 == 0;
                shouldFail = !trnsLoop && rcvLoop;
                received = false;
                System.out.println("Receiver loopBack = " + rcvLoop + "; Transmitter loopBack = " + trnsLoop);
                OSCReceiver rcv = null;
                OSCTransmitter trns = null;
                try {
                    rcv = OSCReceiver.newUsing(proto, 0, rcvLoop);
                    trns = OSCTransmitter.newUsing(proto, 0, trnsLoop);
                    rcv.dumpOSC(1, System.out);
                    rcv.startListening();
                    rcv.addOSCListener(new OSCListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void messageReceived(OSCMessage msg, SocketAddress addr, long when) {
                            System.out.println("   Received msg '" + msg.getName() + "' from " + addr);
                            Object object = sync;
                            synchronized (object) {
                                received = true;
                                sync.notifyAll();
                            }
                        }
                    });
                    trns.connect();
                    int targetPort = rcv.getLocalAddress().getPort();
                    targetAddr = trnsLoop ? new InetSocketAddress("127.0.0.1", targetPort) : new InetSocketAddress(InetAddress.getLocalHost(), targetPort);
                    trns.setTarget(targetAddr);
                    trns.send(new OSCMessage("/test", new Object[]{words[wordIdx], new Integer(wordIdx + 1)}));
                    try {
                        object = sync;
                        synchronized (object) {
                            sync.wait(2000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                if (received != shouldFail) {
                    System.out.println("... OK");
                } else {
                    System.out.println("\n... FAILED!!!\n");
                    ++failures;
                }
                rcv.dispose();
                trns.dispose();
                wordIdx = (wordIdx + 1) % words.length;
            }
        }
        System.out.println("\n------------- CLIENT / SERVER --------------");
        for (i = 0; i < protos.length; ++i) {
            proto = protos[i];
            System.out.println("---------- Testing protocol '" + proto + "' ----------");
            for (j = 0; j < 4; ++j) {
                boolean clientLoop = j / 2 == 0;
                boolean serverLoop = j % 2 == 0;
                shouldFail = !clientLoop && serverLoop;
                received = false;
                System.out.println("Client loopBack = " + clientLoop + "; Server loopBack = " + serverLoop);
                OSCClient client = null;
                OSCServer server = null;
                try {
                    client = OSCClient.newUsing(proto, 0, clientLoop);
                    server = OSCServer.newUsing(proto, 0, serverLoop);
                    server.dumpOSC(1, System.out);
                    server.start();
                    server.addOSCListener(new OSCListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void messageReceived(OSCMessage msg, SocketAddress addr, long when) {
                            System.out.println("   Received msg '" + msg.getName() + "' from " + addr);
                            Object object = sync;
                            synchronized (object) {
                                received = true;
                                sync.notifyAll();
                            }
                        }
                    });
                    int targetPort = server.getLocalAddress().getPort();
                    targetAddr = clientLoop ? new InetSocketAddress("127.0.0.1", targetPort) : new InetSocketAddress(InetAddress.getLocalHost(), targetPort);
                    client.setTarget(targetAddr);
                    client.connect();
                    client.send(new OSCMessage("/test", new Object[]{words[wordIdx], new Integer(wordIdx + 1)}));
                    try {
                        object = sync;
                        synchronized (object) {
                            sync.wait(2000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                if (received != shouldFail) {
                    System.out.println("... OK");
                } else {
                    System.out.println("\n... FAILED!!!\n");
                    ++failures;
                }
                client.dispose();
                server.dispose();
                wordIdx = (wordIdx + 1) % words.length;
            }
        }
        System.out.println("\nNumber of tests failed: " + failures);
    }

    protected static void postln(String s) {
        System.err.println(s);
    }
}

