/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.internal.osc;

import java.util.ArrayList;
import java.util.List;
import org.praxislive.internal.osc.OSCPacket;

public class OSCBundle
extends OSCPacket {
    public static final String TAG = "#bundle";
    public static final long NOW = 1L;
    private static final long SECONDS_FROM_1900_TO_1970 = 2208988800L;
    private long timetag;
    protected final List collPackets = new ArrayList();

    public OSCBundle() {
        this.timetag = 1L;
    }

    public OSCBundle(long when) {
        this.setTimeTagAbsMillis(when);
    }

    public OSCBundle(double when) {
        this.setTimeTagRelSecs(when);
    }

    public OSCBundle(long absMillisOffset, long sampleFrames, int sampleRate) {
        this.setTimeTagSamples(absMillisOffset, sampleFrames, sampleRate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPacket(OSCPacket p) {
        if (p != null) {
            List list = this.collPackets;
            synchronized (list) {
                this.collPackets.add(p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSCPacket getPacket(int idx) {
        List list = this.collPackets;
        synchronized (list) {
            return (OSCPacket)this.collPackets.get(idx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPacketCount() {
        List list = this.collPackets;
        synchronized (list) {
            return this.collPackets.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePacket(int idx) {
        List list = this.collPackets;
        synchronized (list) {
            this.collPackets.remove(idx);
        }
    }

    public void setTimeTagAbsMillis(long when) {
        long secsSince1900 = when / 1000L + 2208988800L;
        long secsFractional = (when % 1000L << 32) / 1000L;
        this.timetag = secsSince1900 << 32 | secsFractional;
    }

    public void setTimeTagRaw(long raw) {
        this.timetag = raw;
    }

    public void setTimeTagRelSecs(double when) {
        this.timetag = ((long)when << 32) + (long)(when % 1.0 * 4.294967296E9 + 0.5);
    }

    public void setTimeTagSamples(long absMillisOffset, long sampleFrames, int sampleRate) {
        double seconds = (double)sampleFrames / (double)sampleRate + (double)absMillisOffset / 1000.0;
        this.timetag = ((long)seconds + 2208988800L << 32) + (long)(seconds % 1.0 * 4.294967296E9 + 0.5);
    }

    public long getTimeTag() {
        return this.timetag;
    }
}

