/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.internal.osc;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.praxislive.internal.osc.OSCBidi;
import org.praxislive.internal.osc.OSCListener;
import org.praxislive.internal.osc.OSCPacket;
import org.praxislive.internal.osc.OSCPacketCodec;
import org.praxislive.internal.osc.OSCReceiver;
import org.praxislive.internal.osc.OSCTransmitter;

public class OSCClient
implements OSCBidi {
    private final OSCReceiver rcv;
    private final OSCTransmitter trns;
    private int bufSize = 8192;
    private final String protocol;

    private OSCClient(OSCReceiver rcv, OSCTransmitter trns, String protocol) {
        this.rcv = rcv;
        this.trns = trns;
        this.protocol = protocol;
    }

    public static OSCClient newUsing(String protocol) throws IOException {
        return OSCClient.newUsing(OSCPacketCodec.getDefaultCodec(), protocol);
    }

    public static OSCClient newUsing(OSCPacketCodec c, String protocol) throws IOException {
        return OSCClient.newUsing(c, protocol, 0);
    }

    public static OSCClient newUsing(String protocol, int port) throws IOException {
        return OSCClient.newUsing(OSCPacketCodec.getDefaultCodec(), protocol, port);
    }

    public static OSCClient newUsing(OSCPacketCodec c, String protocol, int port) throws IOException {
        return OSCClient.newUsing(c, protocol, port, false);
    }

    public static OSCClient newUsing(String protocol, int port, boolean loopBack) throws IOException {
        return OSCClient.newUsing(OSCPacketCodec.getDefaultCodec(), protocol, port, loopBack);
    }

    public static OSCClient newUsing(OSCPacketCodec c, String protocol, int port, boolean loopBack) throws IOException {
        OSCReceiver rcv = OSCReceiver.newUsing(c, protocol, port, loopBack);
        OSCTransmitter trns = OSCTransmitter.newUsing(c, protocol, port, loopBack);
        return new OSCClient(rcv, trns, protocol);
    }

    public static OSCClient newUsing(String protocol, InetSocketAddress localAddress) throws IOException {
        OSCReceiver rcv = OSCReceiver.newUsing(protocol, localAddress);
        OSCTransmitter trns = OSCTransmitter.newUsing(protocol, localAddress);
        return new OSCClient(rcv, trns, protocol);
    }

    public static OSCClient newUsing(OSCPacketCodec c, String protocol, InetSocketAddress localAddress) throws IOException {
        OSCReceiver rcv = OSCReceiver.newUsing(c, protocol, localAddress);
        OSCTransmitter trns = OSCTransmitter.newUsing(c, protocol, localAddress);
        return new OSCClient(rcv, trns, protocol);
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public InetSocketAddress getLocalAddress() throws IOException {
        return this.rcv.getLocalAddress();
    }

    public void setTarget(SocketAddress target) {
        this.rcv.setTarget(target);
        this.trns.setTarget(target);
    }

    @Override
    public void setCodec(OSCPacketCodec c) {
        this.rcv.setCodec(c);
        this.trns.setCodec(c);
    }

    @Override
    public OSCPacketCodec getCodec() {
        return this.rcv.getCodec();
    }

    public void connect() throws IOException {
        this.trns.connect();
    }

    public boolean isConnected() {
        return this.trns.isConnected();
    }

    public void send(OSCPacket p) throws IOException {
        this.trns.send(p);
    }

    public void addOSCListener(OSCListener listener) {
        this.rcv.addOSCListener(listener);
    }

    public void removeOSCListener(OSCListener listener) {
        this.rcv.removeOSCListener(listener);
    }

    @Override
    public void start() throws IOException {
        if (!this.trns.isConnected()) {
            this.trns.connect();
            this.rcv.setChannel(this.trns.getChannel());
        }
        this.rcv.startListening();
    }

    @Override
    public boolean isActive() {
        return this.rcv.isListening();
    }

    @Override
    public void stop() throws IOException {
        this.rcv.stopListening();
    }

    @Override
    public void setBufferSize(int size) {
        this.bufSize = size;
        this.rcv.setBufferSize(size);
        this.trns.setBufferSize(size);
    }

    @Override
    public int getBufferSize() {
        return this.bufSize;
    }

    @Override
    public void dumpOSC(int mode, PrintStream stream) {
        this.dumpIncomingOSC(mode, stream);
        this.dumpOutgoingOSC(mode, stream);
    }

    @Override
    public void dumpIncomingOSC(int mode, PrintStream stream) {
        this.rcv.dumpOSC(mode, stream);
    }

    @Override
    public void dumpOutgoingOSC(int mode, PrintStream stream) {
        this.trns.dumpOSC(mode, stream);
    }

    @Override
    public void dispose() {
        this.rcv.dispose();
        this.trns.dispose();
    }
}

