/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.internal.osc;

import java.io.IOException;
import java.io.PrintStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.praxislive.internal.osc.NetUtil;
import org.praxislive.internal.osc.OSCBundle;
import org.praxislive.internal.osc.OSCChannel;
import org.praxislive.internal.osc.OSCException;
import org.praxislive.internal.osc.OSCListener;
import org.praxislive.internal.osc.OSCMessage;
import org.praxislive.internal.osc.OSCPacket;
import org.praxislive.internal.osc.OSCPacketCodec;

public abstract class OSCReceiver
implements OSCChannel,
Runnable {
    private final List collListeners = new ArrayList();
    protected Thread thread = null;
    protected final Object generalSync = new Object();
    protected final Object threadSync = new Object();
    protected boolean isListening = false;
    private final Object bufSync = new Object();
    private int bufSize = 8192;
    protected ByteBuffer byteBuf = null;
    protected boolean allocBuf = true;
    private int dumpMode = 0;
    private PrintStream printStream = null;
    private OSCPacketCodec c;
    private final String protocol;
    protected final InetSocketAddress localAddress;
    protected final boolean revivable;
    protected SocketAddress target = null;

    protected OSCReceiver(OSCPacketCodec c, String protocol, InetSocketAddress localAddress, boolean revivable) {
        this.c = c;
        this.protocol = protocol;
        this.localAddress = localAddress;
        this.revivable = revivable;
    }

    public static OSCReceiver newUsing(String protocol) throws IOException {
        return OSCReceiver.newUsing(OSCPacketCodec.getDefaultCodec(), protocol);
    }

    public static OSCReceiver newUsing(OSCPacketCodec c, String protocol) throws IOException {
        return OSCReceiver.newUsing(c, protocol, 0);
    }

    public static OSCReceiver newUsing(String protocol, int port) throws IOException {
        return OSCReceiver.newUsing(OSCPacketCodec.getDefaultCodec(), protocol, 0);
    }

    public static OSCReceiver newUsing(OSCPacketCodec c, String protocol, int port) throws IOException {
        return OSCReceiver.newUsing(c, protocol, 0, false);
    }

    public static OSCReceiver newUsing(String protocol, int port, boolean loopBack) throws IOException {
        return OSCReceiver.newUsing(OSCPacketCodec.getDefaultCodec(), protocol, port, loopBack);
    }

    public static OSCReceiver newUsing(OSCPacketCodec c, String protocol, int port, boolean loopBack) throws IOException {
        InetSocketAddress localAddress = new InetSocketAddress(loopBack ? "127.0.0.1" : "0.0.0.0", port);
        return OSCReceiver.newUsing(c, protocol, localAddress);
    }

    public static OSCReceiver newUsing(String protocol, InetSocketAddress localAddress) throws IOException {
        return OSCReceiver.newUsing(OSCPacketCodec.getDefaultCodec(), protocol, localAddress);
    }

    public static OSCReceiver newUsing(OSCPacketCodec c, String protocol, InetSocketAddress localAddress) throws IOException {
        if (protocol.equals("udp")) {
            return new UDPOSCReceiver(c, localAddress);
        }
        if (protocol.equals("tcp")) {
            return new TCPOSCReceiver(c, localAddress);
        }
        throw new IllegalArgumentException(NetUtil.getResourceString("errUnknownProtocol") + protocol);
    }

    public static OSCReceiver newUsing(DatagramChannel dch) throws IOException {
        return OSCReceiver.newUsing(OSCPacketCodec.getDefaultCodec(), dch);
    }

    public static OSCReceiver newUsing(OSCPacketCodec c, DatagramChannel dch) throws IOException {
        return new UDPOSCReceiver(c, dch);
    }

    public static OSCReceiver newUsing(SocketChannel sch) throws IOException {
        return OSCReceiver.newUsing(OSCPacketCodec.getDefaultCodec(), sch);
    }

    public static OSCReceiver newUsing(OSCPacketCodec c, SocketChannel sch) throws IOException {
        return new TCPOSCReceiver(c, sch);
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public abstract InetSocketAddress getLocalAddress() throws IOException;

    public abstract void setTarget(SocketAddress var1);

    @Override
    public void setCodec(OSCPacketCodec c) {
        this.c = c;
    }

    @Override
    public OSCPacketCodec getCodec() {
        return this.c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOSCListener(OSCListener listener) {
        List list = this.collListeners;
        synchronized (list) {
            this.collListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOSCListener(OSCListener listener) {
        List list = this.collListeners;
        synchronized (list) {
            this.collListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startListening() throws IOException {
        Object object = this.generalSync;
        synchronized (object) {
            if (Thread.currentThread() == this.thread) {
                throw new IllegalStateException(NetUtil.getResourceString("errNotInThisThread"));
            }
            if (this.isListening && (this.thread == null || !this.thread.isAlive())) {
                this.isListening = false;
            }
            if (!this.isListening) {
                if (!this.isConnected()) {
                    this.connect();
                }
                this.isListening = true;
                this.thread = new Thread((Runnable)this, "OSCReceiver");
                this.thread.setDaemon(true);
                this.thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isListening() {
        Object object = this.generalSync;
        synchronized (object) {
            return this.isListening;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopListening() throws IOException {
        Object object = this.generalSync;
        synchronized (object) {
            if (Thread.currentThread() == this.thread) {
                throw new IllegalStateException(NetUtil.getResourceString("errNotInThisThread"));
            }
            if (this.isListening) {
                this.isListening = false;
                if (this.thread != null && this.thread.isAlive()) {
                    try {
                        Object object2 = this.threadSync;
                        synchronized (object2) {
                            this.sendGuardSignal();
                            this.threadSync.wait(5000L);
                        }
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                    finally {
                        if (this.thread != null && this.thread.isAlive()) {
                            try {
                                System.err.println("OSCReceiver.stopListening : rude task killing (" + this.hashCode() + ")");
                                this.closeChannel();
                            }
                            catch (IOException e3) {
                                e3.printStackTrace();
                            }
                        }
                        this.thread = null;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBufferSize(int size) {
        Object object = this.bufSync;
        synchronized (object) {
            if (this.isListening) {
                throw new IllegalStateException(NetUtil.getResourceString("errNotWhileActive"));
            }
            if (this.bufSize != size) {
                this.bufSize = size;
                this.allocBuf = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBufferSize() {
        Object object = this.bufSync;
        synchronized (object) {
            return this.bufSize;
        }
    }

    @Override
    public void dumpOSC(int mode, PrintStream stream) {
        this.dumpMode = mode;
        this.printStream = stream == null ? System.err : stream;
    }

    @Override
    public void dispose() {
        try {
            this.stopListening();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            this.closeChannel();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.collListeners.clear();
        this.byteBuf = null;
    }

    protected abstract void sendGuardSignal() throws IOException;

    protected abstract void setChannel(SelectableChannel var1) throws IOException;

    protected abstract void closeChannel() throws IOException;

    protected static String debugTimeString() {
        return new SimpleDateFormat("HH:mm:ss.SSS").format(new Date());
    }

    protected void flipDecodeDispatch(SocketAddress sender) throws IOException {
        block5: {
            try {
                this.byteBuf.flip();
                OSCPacket p = this.c.decode(this.byteBuf);
                if (this.dumpMode != 0) {
                    this.printStream.print("r: ");
                    if ((this.dumpMode & 1) != 0) {
                        OSCPacket.printTextOn(this.printStream, p);
                    }
                    if ((this.dumpMode & 2) != 0) {
                        this.byteBuf.flip();
                        OSCPacket.printHexOn(this.printStream, this.byteBuf);
                    }
                }
                this.dispatchPacket(p, sender, 1L);
            }
            catch (BufferUnderflowException e1) {
                if (!this.isListening) break block5;
                System.err.println(new OSCException(6, e1.toString()));
            }
        }
    }

    private void dispatchPacket(OSCPacket p, SocketAddress sender, long time) {
        if (p instanceof OSCMessage) {
            this.dispatchMessage((OSCMessage)p, sender, time);
        } else if (p instanceof OSCBundle) {
            OSCBundle bndl = (OSCBundle)p;
            time = bndl.getTimeTag();
            for (int i = 0; i < bndl.getPacketCount(); ++i) {
                this.dispatchPacket(bndl.getPacket(i), sender, time);
            }
        } else assert (false) : p.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchMessage(OSCMessage msg, SocketAddress sender, long time) {
        List list = this.collListeners;
        synchronized (list) {
            for (int i = 0; i < this.collListeners.size(); ++i) {
                OSCListener listener = (OSCListener)this.collListeners.get(i);
                listener.messageReceived(msg, sender, time);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkBuffer() {
        Object object = this.bufSync;
        synchronized (object) {
            if (this.allocBuf) {
                this.byteBuf = ByteBuffer.allocateDirect(this.bufSize);
                this.allocBuf = false;
            }
        }
    }

    protected InetSocketAddress getLocalAddress(InetAddress addr, int port) throws UnknownHostException {
        return new InetSocketAddress(addr.getHostName().equals("0.0.0.0") ? InetAddress.getLocalHost() : addr, port);
    }

    public abstract void connect() throws IOException;

    public abstract boolean isConnected();

    private static class TCPOSCReceiver
    extends OSCReceiver {
        private SocketChannel sch = null;

        protected TCPOSCReceiver(OSCPacketCodec c, InetSocketAddress localAddress) {
            super(c, "tcp", localAddress, true);
        }

        protected TCPOSCReceiver(OSCPacketCodec c, SocketChannel sch) {
            super(c, "tcp", new InetSocketAddress(sch.socket().getLocalAddress(), sch.socket().getLocalPort()), false);
            this.sch = sch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void setChannel(SelectableChannel ch) throws IOException {
            Object object = this.generalSync;
            synchronized (object) {
                if (this.isListening) {
                    throw new IllegalStateException(NetUtil.getResourceString("errNotWhileActive"));
                }
                this.sch = (SocketChannel)ch;
                if (!this.sch.isBlocking()) {
                    this.sch.configureBlocking(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InetSocketAddress getLocalAddress() throws IOException {
            Object object = this.generalSync;
            synchronized (object) {
                if (this.sch != null) {
                    Socket s = this.sch.socket();
                    return this.getLocalAddress(s.getLocalAddress(), s.getLocalPort());
                }
                return this.getLocalAddress(this.localAddress.getAddress(), this.localAddress.getPort());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTarget(SocketAddress target) {
            Object object = this.generalSync;
            synchronized (object) {
                if (this.isConnected()) {
                    throw new AlreadyConnectedException();
                }
                this.target = target;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connect() throws IOException {
            Object object = this.generalSync;
            synchronized (object) {
                if (this.isListening) {
                    throw new IllegalStateException(NetUtil.getResourceString("errNotWhileActive"));
                }
                if (this.sch != null && !this.sch.isOpen()) {
                    if (!this.revivable) {
                        throw new IOException(NetUtil.getResourceString("errCannotRevive"));
                    }
                    this.sch = null;
                }
                if (this.sch == null) {
                    SocketChannel newCh = SocketChannel.open();
                    newCh.socket().bind(this.localAddress);
                    this.sch = newCh;
                }
                if (!this.sch.isConnected()) {
                    this.sch.connect(this.target);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isConnected() {
            Object object = this.generalSync;
            synchronized (object) {
                return this.sch != null && this.sch.isConnected();
            }
        }

        @Override
        protected void closeChannel() throws IOException {
            if (this.sch != null) {
                try {
                    this.sch.close();
                }
                finally {
                    this.sch = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            SocketAddress sender = this.sch.socket().getRemoteSocketAddress();
            this.checkBuffer();
            block17: while (true) {
                while (this.isListening) {
                    try {
                        int len;
                        this.byteBuf.rewind().limit(4);
                        do {
                            if ((len = this.sch.read(this.byteBuf)) != -1) continue;
                            return;
                        } while (this.byteBuf.hasRemaining());
                        this.byteBuf.rewind();
                        int packetSize = this.byteBuf.getInt();
                        this.byteBuf.rewind().limit(packetSize);
                        while (this.byteBuf.hasRemaining()) {
                            len = this.sch.read(this.byteBuf);
                            if (len != -1) continue;
                            return;
                        }
                        this.flipDecodeDispatch(sender);
                    }
                    catch (IllegalArgumentException e1) {
                        if (!this.isListening) continue;
                        OSCException e2 = new OSCException(6, e1.toString());
                        System.err.println("OSCReceiver.run : " + e2.getClass().getName() + " : " + e2.getLocalizedMessage());
                    }
                    catch (ClosedChannelException e1) {
                        if (this.isListening) {
                            System.err.println("OSCReceiver.run : " + e1.getClass().getName() + " : " + e1.getLocalizedMessage());
                        }
                        Object object = this.threadSync;
                        synchronized (object) {
                            this.thread = null;
                            this.threadSync.notifyAll();
                            return;
                        }
                    }
                    catch (IOException e1) {
                        try {
                            if (!this.isListening) continue block17;
                            System.err.println("OSCReceiver.run : " + e1.getClass().getName() + " : " + e1.getLocalizedMessage());
                            continue block17;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                            return;
                        }
                    }
                }
            }
            finally {
                Object object = this.threadSync;
                synchronized (object) {
                    this.thread = null;
                    this.threadSync.notifyAll();
                }
            }
        }

        @Override
        protected void sendGuardSignal() throws IOException {
            this.sch.socket().shutdownInput();
        }
    }

    private static class UDPOSCReceiver
    extends OSCReceiver {
        private DatagramChannel dch;

        protected UDPOSCReceiver(OSCPacketCodec c, InetSocketAddress localAddress) throws IOException {
            super(c, "udp", localAddress, true);
        }

        protected UDPOSCReceiver(OSCPacketCodec c, DatagramChannel dch) throws IOException {
            super(c, "udp", new InetSocketAddress(dch.socket().getLocalAddress(), dch.socket().getLocalPort()), false);
            this.dch = dch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void setChannel(SelectableChannel ch) throws IOException {
            Object object = this.generalSync;
            synchronized (object) {
                if (this.isListening) {
                    throw new IllegalStateException(NetUtil.getResourceString("errNotWhileActive"));
                }
                this.dch = (DatagramChannel)ch;
                if (!this.dch.isBlocking()) {
                    this.dch.configureBlocking(true);
                }
                if (this.dch.isConnected()) {
                    throw new IllegalStateException(NetUtil.getResourceString("errChannelConnected"));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InetSocketAddress getLocalAddress() throws IOException {
            Object object = this.generalSync;
            synchronized (object) {
                if (this.dch != null) {
                    DatagramSocket ds = this.dch.socket();
                    return this.getLocalAddress(ds.getLocalAddress(), ds.getLocalPort());
                }
                return this.getLocalAddress(this.localAddress.getAddress(), this.localAddress.getPort());
            }
        }

        @Override
        public void setTarget(SocketAddress target) {
            this.target = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connect() throws IOException {
            Object object = this.generalSync;
            synchronized (object) {
                if (this.isListening) {
                    throw new IllegalStateException(NetUtil.getResourceString("errNotWhileActive"));
                }
                if (this.dch != null && !this.dch.isOpen()) {
                    if (!this.revivable) {
                        throw new IOException(NetUtil.getResourceString("errCannotRevive"));
                    }
                    this.dch = null;
                }
                if (this.dch == null) {
                    DatagramChannel newCh = DatagramChannel.open();
                    newCh.socket().bind(this.localAddress);
                    this.setChannel(newCh);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isConnected() {
            Object object = this.generalSync;
            synchronized (object) {
                return this.dch != null && this.dch.isOpen();
            }
        }

        @Override
        protected void closeChannel() throws IOException {
            if (this.dch != null) {
                try {
                    this.dch.close();
                }
                finally {
                    this.dch = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            this.checkBuffer();
            block16: while (true) {
                while (this.isListening) {
                    try {
                        this.byteBuf.clear();
                        SocketAddress sender = this.dch.receive(this.byteBuf);
                        if (!this.isListening) {
                            return;
                        }
                        if (sender == null || this.target != null && !this.target.equals(sender)) continue;
                        this.flipDecodeDispatch(sender);
                    }
                    catch (ClosedChannelException e1) {
                        if (this.isListening) {
                            System.err.println("OSCReceiver.run : " + e1.getClass().getName() + " : " + e1.getLocalizedMessage());
                        }
                        Object object = this.threadSync;
                        synchronized (object) {
                            this.thread = null;
                            this.threadSync.notifyAll();
                            return;
                        }
                    }
                    catch (IOException e1) {
                        try {
                            if (!this.isListening) continue block16;
                            System.err.println("OSCReceiver.run : " + e1.getClass().getName() + " : " + e1.getLocalizedMessage());
                            continue block16;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                            return;
                        }
                    }
                }
            }
            finally {
                Object object = this.threadSync;
                synchronized (object) {
                    this.thread = null;
                    this.threadSync.notifyAll();
                }
            }
        }

        @Override
        protected void sendGuardSignal() throws IOException {
            DatagramSocket guard = new DatagramSocket();
            DatagramPacket guardPacket = new DatagramPacket(new byte[0], 0);
            guardPacket.setSocketAddress(this.getLocalAddress());
            guard.send(guardPacket);
            guard.close();
        }
    }
}

