/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.launcher.jline;

import java.util.stream.Collectors;
import org.praxislive.base.AbstractRoot;
import org.praxislive.core.Call;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.Value;
import org.praxislive.core.services.ScriptService;
import org.praxislive.core.services.Services;
import org.praxislive.core.services.SystemManagerService;
import org.praxislive.core.types.PError;
import org.praxislive.core.types.PString;
import org.praxislive.launcher.jline.Response;
import org.praxislive.launcher.jline.TerminalImpl;

class JLineTerminalIO
extends AbstractRoot {
    private ControlAddress scriptService;
    private ControlAddress fromAddress;

    JLineTerminalIO() {
    }

    protected void activating() {
        this.setRunning();
    }

    protected void starting() {
        this.scriptService = this.getLookup().find(Services.class).flatMap(srvs -> srvs.locate(ScriptService.class)).map(cmp -> ControlAddress.of((ComponentAddress)cmp, (String)"eval")).orElseThrow();
        this.fromAddress = ControlAddress.of((ComponentAddress)this.getAddress(), (String)"io");
        TerminalImpl.getInstance().attach(this);
    }

    protected void terminating() {
        TerminalImpl.getInstance().detach(this);
    }

    protected void processCall(Call call, PacketRouter router) {
        if (call.isRequest()) {
            router.route((Packet)call.error(PError.of((String)"Unsupported Operation")));
            return;
        }
        String output = call.args().stream().map(Value::toString).collect(Collectors.joining(" "));
        TerminalImpl.getInstance().postResponse(new Response(output, call.isError()));
    }

    void postScript(String script) {
        this.invokeLater(() -> this.handleScript(script));
    }

    private void handleScript(String script) {
        try {
            this.getRouter().route((Packet)Call.create((ControlAddress)this.scriptService, (ControlAddress)this.fromAddress, (long)this.getExecutionContext().getTime(), (Value)PString.of((String)script)));
        }
        catch (Exception e) {
            TerminalImpl.getInstance().postResponse(new Response(String.valueOf(e), true));
        }
    }

    void postExit() {
        this.invokeLater(this::handleExit);
    }

    private void handleExit() {
        this.getLookup().find(Services.class).flatMap(s -> s.locate(SystemManagerService.class)).map(cmp -> ControlAddress.of((ComponentAddress)cmp, (String)"system-exit")).ifPresentOrElse(exit -> this.getRouter().route((Packet)Call.create((ControlAddress)exit, (ControlAddress)this.fromAddress, (long)this.getExecutionContext().getTime())), () -> System.exit(0));
    }
}

