/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.launcher.jline;

import java.util.Locale;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jline.reader.EOFError;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.completer.ArgumentCompleter;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;
import org.praxislive.core.syntax.Token;
import org.praxislive.core.syntax.Tokenizer;
import org.praxislive.launcher.jline.JLineTerminalIO;
import org.praxislive.launcher.jline.Response;

class TerminalImpl {
    private static final String PROMPT = "> ";
    private static final String CONTINUATION_PROMPT = "- ";
    private static final String EXIT_PROMPT = "Exit [Y/N] ? ";
    private static final String EXIT_NOTICE = "Shutting down ...";
    private static final System.Logger LOG;
    private static final TerminalImpl INSTANCE;
    private final BlockingQueue<Response> responses = new LinkedBlockingQueue<Response>(200);
    private final AtomicReference<JLineTerminalIO> service = new AtomicReference();
    private Thread inputThread;
    private Terminal terminal;
    private LineReader reader;

    private TerminalImpl() {
    }

    synchronized void attach(JLineTerminalIO service) {
        this.service.set(service);
        if (this.terminal == null) {
            try {
                this.terminal = TerminalBuilder.builder().jna(true).dumb(true).build();
                this.reader = LineReaderBuilder.builder().terminal(this.terminal).parser((line, cursor, context) -> {
                    if (this.isCompleteScript(line)) {
                        return new ArgumentCompleter.ArgumentLine(line, cursor);
                    }
                    throw new EOFError(cursor, cursor, line);
                }).option(LineReader.Option.DISABLE_EVENT_EXPANSION, true).variable("secondary-prompt-pattern", (Object)CONTINUATION_PROMPT).build();
                this.inputThread = new Thread(this::inputLoop);
                this.inputThread.start();
            }
            catch (Exception ex) {
                LOG.log(System.Logger.Level.ERROR, "Unable to start terminal IO", (Throwable)ex);
            }
        }
    }

    synchronized void detach(JLineTerminalIO service) {
        if (this.service.compareAndSet(service, null)) {
            this.postResponse(new Response("", false));
        }
    }

    synchronized void postResponse(Response response) {
        if (this.terminal != null) {
            this.responses.add(response);
        }
    }

    private void inputLoop() {
        while (true) {
            try {
                block7: while (true) {
                    String script;
                    if ((script = this.reader.readLine(PROMPT)) != null && !script.isBlank()) {
                        JLineTerminalIO root = this.service.get();
                        if (root != null) {
                            root.postScript(script);
                            Response response = this.responses.poll(10L, TimeUnit.SECONDS);
                            if (response == null) {
                                this.writeResponse(new Response("Timed out", true));
                            } else {
                                this.writeResponse(response);
                            }
                        } else {
                            this.writeResponse(new Response("Not running", true));
                        }
                    }
                    while (true) {
                        Response response;
                        if ((response = (Response)this.responses.poll()) == null) continue block7;
                        this.writeResponse(response);
                    }
                    break;
                }
            }
            catch (UserInterruptException ex) {
                if (!ex.getPartialLine().isBlank()) continue;
                try {
                    String confirm = this.reader.readLine(EXIT_PROMPT);
                    if (!"y".equals(confirm.trim().toLowerCase(Locale.ROOT))) continue;
                    this.terminal.writer().println(EXIT_NOTICE);
                    this.terminal.flush();
                    JLineTerminalIO root = this.service.get();
                    if (root != null) {
                        root.postExit();
                        Thread.sleep(5000L);
                    }
                    System.exit(0);
                }
                catch (UserInterruptException confirm) {
                }
                catch (Exception ex2) {
                    LOG.log(System.Logger.Level.DEBUG, "Exception in exit question", (Throwable)ex);
                }
                continue;
            }
            catch (Exception ex) {
                LOG.log(System.Logger.Level.DEBUG, "Exception in input loop", (Throwable)ex);
                continue;
            }
            break;
        }
    }

    private synchronized void writeResponse(Response response) {
        if (response.error) {
            this.terminal.writer().println(new AttributedString((CharSequence)("ERR : " + response.message), AttributedStyle.DEFAULT.foreground(1)).toAnsi(this.terminal));
            this.terminal.flush();
        } else {
            this.terminal.writer().println(new AttributedString((CharSequence)("--- : " + response.message), AttributedStyle.DEFAULT.foreground(2)).toAnsi(this.terminal));
            this.terminal.flush();
        }
    }

    private boolean isCompleteScript(String script) {
        try {
            Tokenizer tok = new Tokenizer((CharSequence)script);
            for (Token token : tok) {
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static TerminalImpl getInstance() {
        return INSTANCE;
    }

    static {
        System.setProperty("org.jline.reader.support.parsedline", "true");
        LOG = System.getLogger(JLineTerminalIO.class.getName());
        INSTANCE = new TerminalImpl();
    }
}

