/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.launcher;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import org.praxislive.base.AbstractRoot;
import org.praxislive.core.Call;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.Value;
import org.praxislive.core.services.ScriptService;
import org.praxislive.core.services.Services;
import org.praxislive.core.syntax.Token;
import org.praxislive.core.syntax.Tokenizer;
import org.praxislive.core.types.PError;
import org.praxislive.core.types.PString;

class FallbackTerminalIO
extends AbstractRoot {
    private Thread input;
    private String script;
    private ControlAddress scriptService;
    private ControlAddress fromAddress;

    FallbackTerminalIO() {
    }

    protected void activating() {
        this.setRunning();
    }

    protected void starting() {
        this.scriptService = this.getLookup().find(Services.class).flatMap(srvs -> srvs.locate(ScriptService.class)).map(cmp -> ControlAddress.of((ComponentAddress)cmp, (String)"eval")).orElseThrow();
        this.fromAddress = ControlAddress.of((ComponentAddress)this.getAddress(), (String)"io");
        this.input = new Thread(this::inputLoop);
        this.script = "";
        this.input.start();
    }

    protected void terminating() {
        if (this.input != null) {
            this.input.interrupt();
        }
    }

    protected void processCall(Call call, PacketRouter router) {
        if (call.isRequest()) {
            router.route((Packet)call.error(PError.of((String)"Unsupported Operation")));
            return;
        }
        String output = call.args().stream().map(Value::toString).collect(Collectors.joining(" "));
        if (call.isReply()) {
            System.out.println("--- : " + output);
        } else {
            System.err.println("ERR : " + output);
        }
    }

    private void processInput(String in) {
        if ("clear".equals(in)) {
            this.script = "";
            return;
        }
        this.script = !this.script.isEmpty() ? this.script + "\n" + in : in;
        Tokenizer tok = new Tokenizer((CharSequence)this.script);
        try {
            for (Token token : tok) {
            }
            Call exec = Call.create((ControlAddress)this.scriptService, (ControlAddress)this.fromAddress, (long)this.getExecutionContext().getTime(), (Value)PString.of((String)this.script));
            this.getRouter().route((Packet)exec);
            this.script = "";
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void inputLoop() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        while (!Thread.interrupted()) {
            try {
                String in = reader.readLine();
                this.invokeLater(() -> this.processInput(in));
            }
            catch (IOException iOException) {}
        }
    }
}

