/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.launcher;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.praxislive.hub.net.ChildLauncher;
import org.praxislive.launcher.Launcher;

class ChildLauncherImpl
implements ChildLauncher {
    private final Launcher.Context context;

    public ChildLauncherImpl(Launcher.Context context) {
        this.context = context;
    }

    public ChildLauncher.Info launch(List<String> javaOptions, List<String> arguments) throws Exception {
        ProcessBuilder pb = this.context.createChildProcessBuilder(javaOptions, List.of("--child"));
        pb.redirectErrorStream(true);
        Process process = pb.start();
        InputStream in = process.getInputStream();
        CompletableFuture infoFuture = new CompletableFuture();
        process.onExit().thenRun(() -> infoFuture.cancel(true));
        this.startDaemon(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("Listening at : ")) {
                        SocketAddress address = Launcher.parseListeningLine(line);
                        infoFuture.complete(new ChildLauncher.Info(process, address));
                    }
                    System.out.println(line);
                }
            }
            catch (Exception ex) {
                infoFuture.completeExceptionally(ex);
                process.destroy();
            }
        });
        return (ChildLauncher.Info)infoFuture.get(30L, TimeUnit.SECONDS);
    }

    private void startDaemon(Runnable task) {
        Thread t = new Thread(task);
        t.setDaemon(true);
        t.start();
    }
}

