/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.launcher;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.praxislive.base.AbstractRoot;
import org.praxislive.core.Call;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.Control;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.ControlInfo;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.Value;
import org.praxislive.core.services.ScriptService;
import org.praxislive.core.services.Services;
import org.praxislive.core.types.PError;
import org.praxislive.core.types.PString;

class ScriptRunner
extends AbstractRoot {
    private static final Logger LOG = Logger.getLogger(ScriptRunner.class.getName());
    private final String SCRIPT_CONTROL_ID = "_script-control";
    private final ScriptControl scriptControl;
    private final Map<String, Control> controls;

    public ScriptRunner(List<String> scripts) {
        if (scripts == null) {
            throw new NullPointerException();
        }
        this.scriptControl = new ScriptControl(scripts);
        this.controls = Map.of("_script-control", this.scriptControl);
    }

    protected void activating() {
        try {
            this.scriptControl.nextScript();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "ERROR: ", ex);
        }
    }

    protected void processCall(Call call, PacketRouter router) {
        try {
            this.controls.get(call.to().controlID()).call(call, router);
        }
        catch (Exception ex) {
            router.route((Packet)call.error(PError.of((Exception)ex)));
        }
    }

    private class ScriptControl
    implements Control {
        private final Queue<String> scriptQueue;
        private ControlAddress evalControl;
        private Call activeCall;

        ScriptControl(List<String> scripts) {
            this.scriptQueue = new LinkedList<String>(scripts);
        }

        public void call(Call call, PacketRouter router) throws Exception {
            if (call.isReply()) {
                this.processReturn(call);
            } else if (call.isError()) {
                this.processError(call);
            } else {
                throw new UnsupportedOperationException();
            }
        }

        private void processReturn(Call call) throws Exception {
            if (this.activeCall != null && call.matchID() == this.activeCall.matchID()) {
                this.activeCall = null;
                this.nextScript();
            }
        }

        private void processError(Call call) throws Exception {
            if (this.activeCall != null && call.matchID() == this.activeCall.matchID()) {
                this.activeCall = null;
                if (!call.args().isEmpty()) {
                    Value err = (Value)call.args().get(0);
                    LOG.log(Level.SEVERE, "ERROR: {0}", err.toString());
                }
            }
        }

        private void nextScript() {
            String script = this.scriptQueue.poll();
            if (script != null) {
                this.runScript(script);
            }
        }

        private void runScript(String script) {
            if (this.evalControl == null) {
                ComponentAddress ss = (ComponentAddress)ScriptRunner.this.getLookup().find(Services.class).flatMap(s -> s.locate(ScriptService.class)).orElseThrow(IllegalStateException::new);
                this.evalControl = ControlAddress.of((ComponentAddress)ss, (String)"eval");
            }
            this.activeCall = Call.create((ControlAddress)this.evalControl, (ControlAddress)ControlAddress.of((ComponentAddress)ScriptRunner.this.getAddress(), (String)"_script-control"), (long)ScriptRunner.this.getExecutionContext().getTime(), (Value)PString.of((String)script));
            ScriptRunner.this.getRouter().route((Packet)this.activeCall);
        }

        public ControlInfo getInfo() {
            return null;
        }
    }
}

