/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.launcher;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Objects;
import org.praxislive.base.AbstractRoot;
import org.praxislive.core.Call;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.RootHub;
import org.praxislive.core.Value;
import org.praxislive.core.services.LogLevel;
import org.praxislive.core.services.LogService;
import org.praxislive.core.services.Service;
import org.praxislive.core.types.PError;

class LogServiceImpl
extends AbstractRoot
implements RootHub.ServiceProvider {
    private final LogLevel logLevel;

    LogServiceImpl(LogLevel logLevel) {
        this.logLevel = Objects.requireNonNull(logLevel);
    }

    public List<Class<? extends Service>> services() {
        return List.of(LogService.class);
    }

    protected void processCall(Call call, PacketRouter router) {
        if (call.isRequest()) {
            try {
                this.processLog(call);
                if (call.isReplyRequired()) {
                    router.route((Packet)call.reply());
                }
            }
            catch (Exception ex) {
                router.route((Packet)call.error(PError.of((Exception)ex)));
            }
        }
    }

    private void processLog(Call call) throws Exception {
        ComponentAddress src = call.from().component();
        List args = call.args();
        for (int i = 1; i < args.size(); i += 2) {
            LogLevel level = LogLevel.valueOf((String)((Value)args.get(i - 1)).toString());
            if (!this.logLevel.isLoggable(level)) continue;
            Value arg = (Value)args.get(i);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.append(level.name()).append(" : ").append(src.toString()).println();
            if (arg instanceof PError) {
                PError err = (PError)arg;
                pw.append(err.exceptionType().getSimpleName()).append(" - ");
                pw.append(err.message()).append("\n");
                err.exception().ifPresent(ex -> ex.printStackTrace(pw));
            } else {
                pw.append(arg.toString()).println();
            }
            pw.flush();
            System.err.println(sw.toString());
        }
        System.err.flush();
    }
}

