/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.launcher;

import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.praxislive.code.CodeCompilerService;
import org.praxislive.core.Lookup;
import org.praxislive.core.MainThread;
import org.praxislive.core.Root;
import org.praxislive.core.services.LogLevel;
import org.praxislive.core.services.LogService;
import org.praxislive.core.services.SystemManagerService;
import org.praxislive.hub.Hub;
import org.praxislive.hub.net.ChildLauncher;
import org.praxislive.hub.net.NetworkCoreFactory;
import org.praxislive.launcher.ChildLauncherImpl;
import org.praxislive.launcher.FallbackTerminalIO;
import org.praxislive.launcher.LogServiceImpl;
import org.praxislive.launcher.ScriptRunner;
import org.praxislive.launcher.Signals;
import org.praxislive.launcher.TerminalIOProvider;
import picocli.CommandLine;

public class Launcher {
    static final String LISTENING_STATUS = "Listening at : ";

    public static void main(Context context, String[] args) {
        int ret = new CommandLine((Object)new Exec(context)).execute(args);
        System.exit(ret);
    }

    static SocketAddress parseListeningLine(String line) {
        if (line.startsWith(LISTENING_STATUS)) {
            try {
                int port = Integer.parseInt(line.substring(LISTENING_STATUS.length()).trim());
                return new InetSocketAddress(InetAddress.getLoopbackAddress(), port);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        throw new IllegalArgumentException();
    }

    @CommandLine.Command(mixinStandardHelpOptions=true)
    private static class Exec
    implements Callable<Integer> {
        @CommandLine.Option(names={"-f", "--file"}, description={"A script file or project directory to run."})
        private File file;
        @CommandLine.Option(names={"-p", "--port"}, converter={PortConverter.class}, description={"{auto | 0 .. 65535} : Launch a server on the specified port. If 0 or auto, a port is automatically chosen. Unless --network is specified, connections are only supported over local loopback. The port is reported to standard out as \"Listening at : [port]\"."})
        private Integer port;
        @CommandLine.Option(names={"-n", "--network"}, description={"{all | CIDR mask} : Launch a server that supports remote connections, from all addresses or matching mask. Implies --port auto if not otherwise specified."})
        private String network;
        @CommandLine.Option(names={"-i", "--interactive"}, description={"Allow for controlling the hub via PCL commands over the command line."})
        private boolean interactive;
        @CommandLine.Option(names={"--child"}, description={"Configure the process to run as a child process. Implies --port auto unless specified.", "A child process may not respond to normal termination signals, instead relying on the parent process to be terminated."})
        private boolean child;
        @CommandLine.Option(names={"--show-environment"}, description={"Output useful debugging information about process environment."})
        private boolean showEnv;
        @CommandLine.Option(names={"--no-signal-handlers"}, description={"Don't install signal handlers."}, hidden=true)
        private boolean noSignals;
        @CommandLine.Parameters(description={"Extra command line arguments."})
        private List<String> extraArgs;
        private final Context context;

        private Exec(Context context) {
            this.context = context;
        }

        @Override
        public Integer call() throws Exception {
            String script;
            File scriptFile;
            boolean requireServer;
            if (this.showEnv) {
                this.outputEnvironmentInfo();
            }
            if (this.child) {
                if (this.port == null) {
                    this.port = 0;
                }
                if (!this.noSignals) {
                    this.installChildSignalOverrides();
                }
            }
            boolean bl = requireServer = this.network != null || this.port != null;
            if (requireServer && this.port == null) {
                this.port = 0;
            }
            boolean allowRemote = requireServer && this.network != null;
            String cidr = allowRemote && !this.network.equalsIgnoreCase("all") ? this.network : null;
            Optional<File> autoRun = this.context.autoRunFile();
            if (this.file != null) {
                if (this.child) {
                    this.error("Cannot specify --file and --child");
                    return 1;
                }
                if (autoRun.isPresent()) {
                    this.error("Cannot specify --file when auto-run file exists");
                    return 1;
                }
            }
            if ((scriptFile = autoRun.orElse(this.file)) != null) {
                if ((scriptFile = scriptFile.getAbsoluteFile()).isDirectory()) {
                    scriptFile = new File(scriptFile, "project.pxp");
                }
                if (!scriptFile.exists()) {
                    this.error("No file found at " + String.valueOf(scriptFile));
                    return 1;
                }
                try {
                    script = "set _PWD " + String.valueOf(scriptFile.getParentFile().toURI()) + "\n" + Files.readString(scriptFile.toPath());
                }
                catch (Exception ex) {
                    this.error("Unable to read script at " + String.valueOf(scriptFile));
                    return 1;
                }
            } else {
                script = null;
            }
            if (!requireServer && !this.interactive && script == null) {
                if (this.showEnv) {
                    return 0;
                }
                this.error("WARNING : Nothing to do, exiting.");
                this.error("Use --help to see options");
                return 1;
            }
            MainThreadImpl main = new MainThreadImpl();
            int exitValue = 0;
            do {
                NetworkCoreFactory.Builder coreBuilder = NetworkCoreFactory.builder().childLauncher((ChildLauncher)new ChildLauncherImpl(this.context)).exposeServices(List.of(CodeCompilerService.class, LogService.class, SystemManagerService.class));
                if (requireServer) {
                    coreBuilder.enableServer();
                    coreBuilder.serverPort(this.port.intValue());
                }
                if (allowRemote && cidr != null) {
                    coreBuilder.allowRemoteServerConnection(cidr);
                } else if (allowRemote) {
                    coreBuilder.allowRemoteServerConnection();
                }
                NetworkCoreFactory coreFactory = coreBuilder.build();
                Hub.Builder hubBuilder = Hub.builder().setCoreRootFactory((Hub.CoreRootFactory)coreFactory).extendLookup((Object)main);
                if (script != null) {
                    hubBuilder.addExtension((Root)new ScriptRunner(List.of(script)));
                }
                if (this.interactive) {
                    Root terminalIO = this.createTerminalIO();
                    hubBuilder.addExtension(terminalIO);
                }
                LogLevel logLevel = LogLevel.INFO;
                hubBuilder.addExtension((Root)new LogServiceImpl(logLevel));
                hubBuilder.extendLookup((Object)logLevel);
                Hub hub = hubBuilder.build();
                hub.start();
                if (requireServer) {
                    NetworkCoreFactory.Info serverInfo = coreFactory.awaitInfo(30L, TimeUnit.SECONDS);
                    this.port = serverInfo.serverAddress().filter(a -> a instanceof InetSocketAddress).map(a -> (InetSocketAddress)a).orElseThrow().getPort();
                    this.out(Launcher.LISTENING_STATUS + this.port);
                }
                main.run(hub);
                exitValue = hub.exitValue();
            } while (requireServer);
            return exitValue;
        }

        private void installChildSignalOverrides() {
            String[] signals = new String[]{"INT", "QUIT", "TSTP", "CONT", "INFO", "WINCH"};
            try {
                ServiceLoader.load(Signals.class).findFirst().ifPresent(s -> {
                    for (String signal : signals) {
                        s.register(signal, () -> System.getLogger(Launcher.class.getName()).log(System.Logger.Level.DEBUG, () -> "Received signal : " + signal));
                    }
                });
            }
            catch (Exception ex) {
                System.getLogger(Launcher.class.getName()).log(System.Logger.Level.ERROR, "Error registering signal handler", (Throwable)ex);
            }
        }

        private Root createTerminalIO() {
            try {
                return ServiceLoader.load(TerminalIOProvider.class).findFirst().map(p -> p.createTerminalIO(Lookup.EMPTY)).orElseGet(FallbackTerminalIO::new);
            }
            catch (Exception ex) {
                System.getLogger(Launcher.class.getName()).log(System.Logger.Level.ERROR, "Error creating terminal IO, defaulting to fallback", (Throwable)ex);
                return new FallbackTerminalIO();
            }
        }

        private void outputEnvironmentInfo() {
            try {
                ProcessHandle handle = ProcessHandle.current();
                handle.info().command().ifPresent(s -> this.out("Command :\n" + s + "\n"));
                handle.info().arguments().ifPresent(args -> this.out("Arguments :\n" + Arrays.toString(args) + "\n"));
                handle.info().commandLine().ifPresent(s -> this.out("Full command line :\n" + s + "\n"));
                String modulePath = System.getProperty("jdk.module.path");
                this.out("Java module path :");
                this.out(modulePath == null || modulePath.isBlank() ? "[EMPTY]" : modulePath);
                this.out("");
                String classPath = System.getProperty("java.class.path");
                this.out("Java class path :");
                this.out(classPath == null || classPath.isBlank() ? "[EMPTY]" : classPath);
                this.out("");
                this.out("Environment variables :");
                this.out(String.valueOf(System.getenv()));
                this.out("");
            }
            catch (Exception e) {
                System.getLogger(Launcher.class.getName()).log(System.Logger.Level.DEBUG, "Exception thrown outputting environment info.", (Throwable)e);
            }
        }

        private void out(String msg) {
            System.out.println(msg);
        }

        private void error(String msg) {
            String ansiMsg = CommandLine.Help.Ansi.AUTO.string("@|bold,red " + msg + "|@");
            System.out.println(ansiMsg);
        }
    }

    public static interface Context {
        public ProcessBuilder createChildProcessBuilder(List<String> var1, List<String> var2);

        default public Optional<File> autoRunFile() {
            return Optional.empty();
        }
    }

    private static class MainThreadImpl
    implements MainThread {
        private final Thread main = Thread.currentThread();
        private final BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();

        private MainThreadImpl() {
        }

        public void runLater(Runnable task) {
            this.queue.add(task);
        }

        public boolean isMainThread() {
            return Thread.currentThread() == this.main;
        }

        private void run(Hub hub) {
            Runnable task;
            while (hub.isAlive()) {
                try {
                    task = this.queue.poll(500L, TimeUnit.MILLISECONDS);
                    if (task == null) continue;
                    task.run();
                }
                catch (Throwable t) {
                    System.getLogger(Launcher.class.getName()).log(System.Logger.Level.ERROR, "", t);
                }
            }
            while (true) {
                try {
                    while ((task = this.queue.poll(500L, TimeUnit.MILLISECONDS)) != null) {
                        task.run();
                    }
                }
                catch (Throwable t) {
                    System.getLogger(Launcher.class.getName()).log(System.Logger.Level.ERROR, "", t);
                    continue;
                }
                break;
            }
        }
    }

    private static class PortConverter
    implements CommandLine.ITypeConverter<Integer> {
        private PortConverter() {
        }

        public Integer convert(String arg0) throws Exception {
            if (arg0.equalsIgnoreCase("auto")) {
                return 0;
            }
            int port = Integer.parseInt(arg0);
            if (port < 0 || port > 65535) {
                throw new IllegalArgumentException("Port value out of range");
            }
            return port;
        }
    }
}

