/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.launcher;

import java.util.List;
import java.util.Objects;
import org.praxislive.base.AbstractRoot;
import org.praxislive.core.Call;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.RootHub;
import org.praxislive.core.Value;
import org.praxislive.core.services.LogLevel;
import org.praxislive.core.services.LogService;
import org.praxislive.core.services.Service;
import org.praxislive.core.types.PError;

class LogServiceImpl
extends AbstractRoot
implements RootHub.ServiceProvider {
    private static final String NEWLINE = System.lineSeparator();
    private final LogLevel logLevel;

    LogServiceImpl(LogLevel logLevel) {
        this.logLevel = Objects.requireNonNull(logLevel);
    }

    public List<Class<? extends Service>> services() {
        return List.of(LogService.class);
    }

    protected void processCall(Call call, PacketRouter router) {
        if (call.isRequest()) {
            try {
                this.processLog(call);
                if (call.isReplyRequired()) {
                    router.route((Packet)call.reply());
                }
            }
            catch (Exception ex) {
                router.route((Packet)call.error(PError.of((Exception)ex)));
            }
        }
    }

    private void processLog(Call call) throws Exception {
        ComponentAddress src = call.from().component();
        List args = call.args();
        StringBuilder sb = new StringBuilder();
        LogLevel lastLevel = null;
        for (int i = 1; i < args.size(); i += 2) {
            LogLevel level = LogLevel.valueOf((String)((Value)args.get(i - 1)).toString());
            if (!this.logLevel.isLoggable(level)) continue;
            Value arg = (Value)args.get(i);
            if (level != lastLevel) {
                lastLevel = level;
                sb.append(level.name()).append(" : ").append(src.toString()).append(NEWLINE);
            }
            PError.from((Value)arg).ifPresentOrElse(err -> {
                sb.append(err.errorType()).append(" - ").append(err.message()).append(NEWLINE);
                String stack = err.stackTrace();
                if (!stack.isBlank()) {
                    sb.append(stack).append(NEWLINE);
                }
            }, () -> sb.append(arg.toString()).append(NEWLINE));
            System.err.print(sb.toString());
            sb.setLength(0);
        }
        System.err.flush();
    }
}

