/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.launcher;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.praxislive.core.Settings;

public class SettingsProvider
extends Settings.Provider {
    private static final Preferences PREFS = Preferences.userNodeForPackage(SettingsProvider.class);
    private static final Logger LOGGER = Logger.getLogger(SettingsProvider.class.getName());
    private static final String SYS_PREFIX = "praxis.";
    private final Map<String, String> map = new ConcurrentHashMap<String, String>();

    public SettingsProvider() {
        this.initPersisted();
        this.initSystemProperties();
    }

    private void initPersisted() {
        try {
            for (String key : PREFS.keys()) {
                String val = PREFS.get(key, null);
                this.map.put(key, val);
                LOGGER.log(Level.FINE, "Persisted setting, key : {0}, value : {1}", new Object[]{key, val});
            }
        }
        catch (BackingStoreException ex) {
            LOGGER.log(Level.WARNING, "Couldn't access persisted preferences.", ex);
        }
    }

    private void initSystemProperties() {
        try {
            Properties sys = System.getProperties();
            for (String key : sys.stringPropertyNames()) {
                String val;
                if (!key.startsWith(SYS_PREFIX) || (val = sys.getProperty(key)) == null) continue;
                if ((key = key.substring(SYS_PREFIX.length())).isEmpty()) {
                    LOGGER.log(Level.FINE, "Found key equal to prefix - ignoring");
                    continue;
                }
                String old = this.map.put(key, val);
                if (old == null) {
                    LOGGER.log(Level.FINE, "Runtime setting, key : {0}, value : {1}", new Object[]{key, val});
                    continue;
                }
                LOGGER.log(Level.FINE, "Runtime override, key : {0}, old value : {1}, new value : {2}", new Object[]{key, old, val});
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Couldn't access system properties.", ex);
        }
    }

    public String get(String key) {
        return this.map.get(key);
    }

    public void put(String key, String value, boolean persistent) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (persistent) {
            try {
                if (value == null) {
                    PREFS.remove(key);
                } else {
                    PREFS.put(key, value);
                }
                PREFS.flush();
            }
            catch (BackingStoreException ex) {
                LOGGER.log(Level.WARNING, "Couldn't persist setting.", ex);
            }
        }
        if (value == null) {
            this.map.remove(key);
        } else {
            this.map.put(key, value);
        }
    }

    public boolean isPersistent(String key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

