/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.osc.components;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.praxislive.internal.osc.OSCListener;
import org.praxislive.internal.osc.OSCMessage;

class OSCContext {
    private static final Logger LOG = Logger.getLogger(OSCContext.class.getName());
    private Map<String, List<OSCListener>> listeners = new HashMap<String, List<OSCListener>>();

    OSCContext() {
    }

    void addListener(String oscAddress, OSCListener listener) {
        List<OSCListener> ls = this.listeners.get(oscAddress);
        LOG.log(Level.FINE, "Adding OSC listener on {0}", oscAddress);
        if (ls == null) {
            LOG.log(Level.FINE, "Creating OSC map for {0}", oscAddress);
            ls = new ArrayList<OSCListener>();
            this.listeners.put(oscAddress, ls);
        }
        ls.add(listener);
    }

    void removeListener(String oscAddress, OSCListener listener) {
        List<OSCListener> ls = this.listeners.get(oscAddress);
        if (ls == null) {
            LOG.log(Level.FINE, "Attempting to remove listener for address without listeners - {0}", oscAddress);
            return;
        }
        boolean changed = ls.remove(listener);
        if (!changed) {
            LOG.log(Level.FINE, "Attempting to remove non-existent listener on {0}", oscAddress);
            return;
        }
        if (ls.isEmpty()) {
            LOG.log(Level.FINE, "Removing OSC map for {0}", oscAddress);
            this.listeners.remove(oscAddress);
        }
    }

    void dispatch(OSCMessage msg, long time) {
        List<OSCListener> ls = this.listeners.get(msg.getName());
        if (ls != null) {
            for (OSCListener l : ls) {
                l.messageReceived(msg, null, time);
            }
        }
    }
}

