/*
 * Decompiled with CFR 0.152.
 */
package org.praxislive.osc.components;

import java.net.SocketAddress;
import java.util.List;
import org.praxislive.base.AbstractComponent;
import org.praxislive.base.AbstractProperty;
import org.praxislive.core.Call;
import org.praxislive.core.ComponentAddress;
import org.praxislive.core.ComponentInfo;
import org.praxislive.core.Control;
import org.praxislive.core.ControlAddress;
import org.praxislive.core.Info;
import org.praxislive.core.Packet;
import org.praxislive.core.PacketRouter;
import org.praxislive.core.Value;
import org.praxislive.core.protocols.ComponentProtocol;
import org.praxislive.core.types.PBoolean;
import org.praxislive.core.types.PNumber;
import org.praxislive.core.types.PString;
import org.praxislive.internal.osc.OSCListener;
import org.praxislive.internal.osc.OSCMessage;
import org.praxislive.osc.components.OSCContext;

public class OSCInput
extends AbstractComponent {
    private final OSCListener listener = new OSCListenerImpl();
    private final ComponentInfo info;
    private OSCContext context;
    private ControlAddress sendAddress = null;
    private String oscAddress = "";
    private ControlAddress returnAddress;

    public OSCInput() {
        this.registerControl("address", (Control)new SendAddressBinding());
        this.registerControl("osc-address", (Control)new OSCAddressBinding());
        this.registerControl("_log", new OSCLogControl());
        this.info = Info.component(cmp -> cmp.merge(ComponentProtocol.API_INFO).control("address", c -> c.property().input(a -> a.type(ControlAddress.class).property("allow-empty", (Value)PBoolean.TRUE))).control("osc-address", c -> c.property().input(a -> a.string().emptyIsDefault())));
    }

    public ComponentInfo getInfo() {
        return this.info;
    }

    public void hierarchyChanged() {
        ComponentAddress c;
        super.hierarchyChanged();
        OSCContext ctxt = this.getLookup().find(OSCContext.class).orElse(null);
        if (ctxt != this.context) {
            if (this.context != null) {
                this.unregisterListener();
                this.context = null;
            }
            if (ctxt == null) {
                return;
            }
            this.context = ctxt;
            this.registerListener();
        }
        this.returnAddress = (c = this.getAddress()) == null ? null : ControlAddress.of((ComponentAddress)c, (String)"_log");
    }

    private void registerListener() {
        if (this.sendAddress != null) {
            String osc = this.oscAddress.isEmpty() ? this.sendAddress.toString() : this.oscAddress;
            this.context.addListener(osc, this.listener);
        }
    }

    private void unregisterListener() {
        if (this.sendAddress != null) {
            String osc = this.oscAddress.isEmpty() ? this.sendAddress.toString() : this.oscAddress;
            this.context.removeListener(osc, this.listener);
        }
    }

    private void dispatch(OSCMessage msg, long time) {
        List<Object> arguments;
        if (this.sendAddress == null) {
            return;
        }
        PacketRouter router = this.getLookup().find(PacketRouter.class).orElse(c -> {});
        int count = msg.getArgCount();
        switch (count) {
            case 0: {
                arguments = List.of();
                break;
            }
            case 1: {
                arguments = List.of(this.objectToArg(msg.getArg(0)));
                break;
            }
            default: {
                Value[] args = new Value[count];
                for (int i = 0; i < count; ++i) {
                    args[i] = this.objectToArg(msg.getArg(i));
                }
                arguments = List.of(args);
            }
        }
        router.route((Packet)Call.createQuiet((ControlAddress)this.sendAddress, (ControlAddress)this.returnAddress, (long)time, arguments));
    }

    private Value objectToArg(Object obj) {
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? PBoolean.TRUE : PBoolean.FALSE;
        }
        if (obj instanceof Integer) {
            return PNumber.of((int)((Integer)obj));
        }
        if (obj instanceof Number) {
            return PNumber.of((double)((Number)obj).doubleValue());
        }
        if (obj == null) {
            return PString.EMPTY;
        }
        return PString.of((Object)obj);
    }

    private class OSCLogControl
    implements Control {
        private OSCLogControl() {
        }

        public void call(Call call, PacketRouter router) throws Exception {
        }
    }

    private class OSCListenerImpl
    implements OSCListener {
        private OSCListenerImpl() {
        }

        public void messageReceived(OSCMessage oscm, SocketAddress sa, long time) {
            OSCInput.this.dispatch(oscm, time);
        }
    }

    private class OSCAddressBinding
    extends AbstractProperty {
        private OSCAddressBinding() {
        }

        public void set(long time, Value value) {
            OSCInput.this.unregisterListener();
            OSCInput.this.oscAddress = value.toString();
            OSCInput.this.registerListener();
        }

        public Value get() {
            return PString.of((String)OSCInput.this.oscAddress);
        }
    }

    private class SendAddressBinding
    extends AbstractProperty {
        private SendAddressBinding() {
        }

        public void set(long time, Value value) throws Exception {
            ControlAddress send = value.isEmpty() ? null : (ControlAddress)ControlAddress.from((Value)value).get();
            OSCInput.this.unregisterListener();
            OSCInput.this.sendAddress = send;
            OSCInput.this.registerListener();
        }

        public Value get() {
            if (OSCInput.this.sendAddress == null) {
                return PString.EMPTY;
            }
            return OSCInput.this.sendAddress;
        }
    }
}

